/*
 * @(#)ChConsoleReadBalloon.java  23 March 2003
 *
 * @author Viera K. Proulx
 */

import java.awt.*;
import edu.neu.ccs.console.*;

/** An input channel to return Balloon object from console input. */
class ChConsoleReadBalloon implements ChBalloonInput, ConsoleAware{
    
    /*--------------------------------------------------------------
     Methods
     *------------------------------------------------------------*/
    
    /* read values for one balloon from the console */
    public Balloon read(){
        return new Balloon
            (console.in.demandInt("x: "),
             console.in.demandInt("y: "),
             console.in.demandInt("radius: "),
             new Color(demandShade("red shade: " ),
                       demandShade("green shade: "),
                       demandShade("blue shade: ")));
    }
    
    /* demand shade value in the valid range from the console */
    protected int demandShade(String s){

        int shade = console.in.demandInt(s);
        if ((shade >= 0) && (shade <= 255))
            return shade;
        
        console.out.println("" + shade + " is not within 0-255 range");
        return demandShade(s);
    }
    

}
