/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.MouseAction;
import edu.neu.ccs.gui.MouseActionAdapter;
import edu.neu.ccs.gui.Zoo;
import edu.neu.ccs.gui.ZooGroup;
import edu.neu.ccs.util.DimensionUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class Laminate
extends JComponent
implements ComponentListener {
    private Component target = null;
    private boolean activated = true;
    private boolean selected = false;
    private Point moveOffset = new Point();
    private MouseActionAdapter adapter = null;
    private boolean resizeable = true;
    private boolean moveable = true;
    private boolean resizingX = false;
    private boolean resizingY = false;

    public Laminate(Component c, boolean isActivated) {
        this.installMouseAdapter();
        this.setTarget(c);
        this.setActivated(isActivated);
    }

    public void componentHidden(ComponentEvent evt) {
        this.setVisible(this.target.isVisible());
    }

    public void componentMoved(ComponentEvent evt) {
        this.setLocation(this.target.getLocation());
        this.getZoo().repaint();
    }

    public void componentResized(ComponentEvent evt) {
        this.setSize(this.target.getSize());
        this.getZoo().repaint();
    }

    public void componentShown(ComponentEvent evt) {
        this.setVisible(this.target.isVisible());
    }

    public void setTarget(Component c) {
        if (this.target != null) {
            this.target.removeComponentListener(this);
            this.setActivated(false);
        }
        this.target = c;
        if (this.target != null) {
            this.target.addComponentListener(this);
            this.setActivated(true);
            this.setBounds(this.target.getBounds());
        }
    }

    public Component getTarget() {
        return this.target;
    }

    public void setActivated(boolean isActivated) {
        if (this.activated != isActivated) {
            this.activated = isActivated;
            if (this.activated) {
                this.adapter.addAsListenerTo(this);
            } else {
                this.adapter.removeAsListenerTo(this);
            }
        }
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setSelected(boolean isSelected) {
        this.selected = isSelected;
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public MouseActionAdapter getMouseActionAdapter() {
        return this.adapter;
    }

    public void setLocation(int x, int y) {
        this.setBoundsImpl(x, y, this.getWidth(), this.getHeight());
    }

    public void setLocation(Point p) {
        this.setBoundsImpl(p.x, p.y, this.getWidth(), this.getHeight());
    }

    public void setSize(int width, int height) {
        this.setBoundsImpl(this.getX(), this.getY(), width, height);
    }

    public void setSize(Dimension size) {
        this.setBoundsImpl(this.getX(), this.getY(), size.width, size.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setBoundsImpl(x, y, width, height);
    }

    public void setBounds(Rectangle bounds) {
        this.setBoundsImpl(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void setMoveable(boolean isMoveable) {
        this.moveable = isMoveable;
    }

    public boolean isMoveable() {
        return this.moveable && this.getZoo().allowsMove();
    }

    public void setResizeable(boolean isResizeable) {
        this.resizeable = isResizeable;
    }

    public boolean isResizeable() {
        return this.resizeable && this.getZoo().allowsResize();
    }

    protected void paintComponent(Graphics g) {
        if (this.isSelected()) {
            if (this.getZoo().hasFocus()) {
                g.setColor(this.getZoo().getFocusedHighlightColor());
            } else {
                g.setColor(this.getZoo().getUnfocusedHighlightColor());
            }
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            int width = this.getWidth();
            int height = this.getHeight();
            if (this.isResizableX()) {
                g.fillRect(width - 5, height / 2 - 2, 5, 5);
            }
            if (this.isResizableY()) {
                g.fillRect(width / 2 - 2, height - 5, 5, 5);
            }
            if (this.isResizableX() && this.isResizableY()) {
                g.fillRect(width - 5, height - 5, 5, 5);
            }
        }
    }

    protected Zoo getZoo() {
        return (Zoo)this.getParent();
    }

    protected void installMouseAdapter() {
        this.adapter = new MouseActionAdapter(this);
        this.installSelectionActions();
        this.installCursorActions();
        this.installManipulationActions();
    }

    protected void installSelectionActions() {
        this.adapter.addMousePressedAction(new 1());
    }

    protected void installCursorActions() {
        2 rollover = new 2();
        this.adapter.addMouseMovedAction(rollover);
        this.adapter.addMouseEnteredAction(rollover);
        this.adapter.addMouseExitedAction(new 3());
    }

    protected void installManipulationActions() {
        this.adapter.addMousePressedAction(new 4());
        this.adapter.addMouseDraggedAction(new 5());
        this.adapter.addMouseReleasedAction(new 6());
    }

    protected void startMoveAt(MouseEvent evt) {
        this.moveOffset.setLocation(evt.getX(), evt.getY());
        this.setResizing(false, false);
    }

    protected Rectangle restrictBounds(int x, int y, int width, int height) {
        Dimension size = new Dimension(width, height);
        if (this.getZoo() != null && this.getZoo().isRestrictingBounds()) {
            Rectangle bounds = this.getZooInnerBounds();
            x = Math.min(Math.max(bounds.x, x), bounds.x + bounds.width - this.target.getWidth());
            y = Math.min(Math.max(bounds.y, y), bounds.y + bounds.height - this.target.getHeight());
            size = DimensionUtilities.max(size, this.target.getMinimumSize());
            size = DimensionUtilities.min(size, this.target.getMaximumSize());
            size.width = Math.max(0, Math.min(size.width, bounds.x + bounds.width - this.target.getX()));
            size.height = Math.max(0, Math.min(size.height, bounds.y + bounds.height - this.target.getY()));
        }
        return new Rectangle(x, y, size.width, size.height);
    }

    protected void moveTo(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        x = this.getX() + x - this.moveOffset.x;
        y = this.getY() + y - this.moveOffset.y;
        this.target.setBounds(this.restrictBounds(x, y, this.target.getWidth(), this.target.getHeight()));
    }

    protected void resizeTo(MouseEvent evt) {
        Dimension d = new Dimension(evt.getX(), evt.getY());
        if (!this.resizingX) {
            d.width = this.getWidth();
        }
        if (!this.resizingY) {
            d.height = this.getHeight();
        }
        this.target.setBounds(this.restrictBounds(this.target.getX(), this.target.getY(), d.width, d.height));
        this.revalidateTarget();
    }

    protected void setResizing(boolean xAxis, boolean yAxis) {
        this.resizingX = xAxis;
        this.resizingY = yAxis;
        if ((this.resizingX || this.resizingY) && this.getTarget() instanceof ZooGroup) {
            ZooGroup group = (ZooGroup)this.getTarget();
            group.startResize();
        }
    }

    protected boolean isResizableX() {
        return this.isResizeable() && this.target.getMinimumSize().width < this.target.getMaximumSize().width;
    }

    protected boolean isResizableY() {
        return this.isResizeable() && this.target.getMinimumSize().height < this.target.getMaximumSize().height;
    }

    protected boolean isResizableXY() {
        return this.isResizableX() && this.isResizableY();
    }

    protected boolean inSE(int x, int y, int delta) {
        return Point2D.distance(x, y, this.getWidth(), this.getHeight()) <= (double)delta;
    }

    protected boolean inS(int x, int y, int delta) {
        return Point2D.distance(x, y, this.getWidth() / 2, this.getHeight()) <= (double)delta;
    }

    protected boolean inE(int x, int y, int delta) {
        return Point2D.distance(x, y, this.getWidth(), this.getHeight() / 2) <= (double)delta;
    }

    private void setBoundsImpl(int x, int y, int width, int height) {
        this.target.removeComponentListener(this);
        Rectangle bounds = this.restrictBounds(x, y, width, height);
        super.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
        this.target.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
        this.target.addComponentListener(this);
    }

    private void revalidateTarget() {
        if (this.target instanceof JComponent) {
            JComponent c = (JComponent)this.target;
            c.revalidate();
            return;
        }
        if (this.target instanceof Container) {
            Container c = (Container)this.target;
            c.validate();
            return;
        }
    }

    private Rectangle getZooInnerBounds() {
        Dimension size = this.getZoo().getSize();
        Insets insets = this.getZoo().getInsets();
        return new Rectangle(insets.left, insets.top, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
    }

    private final class 1
    extends MouseAction {
        public void mouseActionPerformed(MouseEvent evt) {
            Zoo parent = Laminate.this.getZoo();
            if (evt.isShiftDown()) {
                if (Laminate.this.isSelected()) {
                    parent.removeFromSelection(Laminate.this.getTarget());
                } else {
                    parent.addToSelection(Laminate.this.getTarget());
                }
            } else if (!Laminate.this.isSelected() || Laminate.this.getZoo().getSelectedComponentCount() != 1) {
                parent.selectOnly(Laminate.this.getTarget());
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseAction {
        public void mouseActionPerformed(MouseEvent evt) {
            if (!Laminate.this.isSelected()) {
                return;
            }
            int width = Laminate.this.getWidth();
            int height = Laminate.this.getHeight();
            int type = Laminate.this.getCursor().getType();
            if (Laminate.this.resizingX || Laminate.this.resizingY) {
                return;
            }
            if (Laminate.this.inSE(evt.getX(), evt.getY(), 5) && Laminate.this.isResizableXY()) {
                type = 5;
            } else if (Laminate.this.inS(evt.getX(), evt.getY(), 5) && Laminate.this.isResizableY()) {
                type = 9;
            } else if (Laminate.this.inE(evt.getX(), evt.getY(), 5) && Laminate.this.isResizableX()) {
                type = 11;
            } else if (Laminate.this.isMoveable()) {
                type = 13;
            }
            if (Laminate.this.getCursor().getType() != type) {
                Laminate.this.setCursor(new Cursor(type));
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends MouseAction {
        public void mouseActionPerformed(MouseEvent evt) {
            if (!Laminate.this.resizingX && !Laminate.this.resizingY) {
                Laminate.this.setCursor(new Cursor(0));
            }
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    extends MouseAction {
        public void mouseActionPerformed(MouseEvent evt) {
            if (!Laminate.this.isSelected()) {
                return;
            }
            if (Laminate.this.inSE(evt.getX(), evt.getY(), 5) && Laminate.this.isResizableXY()) {
                Laminate.this.setResizing(true, true);
            } else if (Laminate.this.inS(evt.getX(), evt.getY(), 5) && Laminate.this.isResizableY()) {
                Laminate.this.setResizing(false, true);
            } else if (Laminate.this.inE(evt.getX(), evt.getY(), 5) && Laminate.this.isResizableX()) {
                Laminate.this.setResizing(true, false);
            } else if (Laminate.this.isMoveable()) {
                Laminate.this.startMoveAt(evt);
            }
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    extends MouseAction {
        public void mouseActionPerformed(MouseEvent evt) {
            if (!Laminate.this.isSelected()) {
                return;
            }
            if (Laminate.this.resizingX || Laminate.this.resizingY) {
                Laminate.this.resizeTo(evt);
            } else if (Laminate.this.isMoveable()) {
                Laminate.this.moveTo(evt);
            }
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    extends MouseAction {
        public void mouseActionPerformed(MouseEvent evt) {
            if (Laminate.this.resizingX || Laminate.this.resizingY) {
                Laminate.this.setResizing(false, false);
                if (Laminate.this.getTarget() instanceof ZooGroup) {
                    ZooGroup group = (ZooGroup)Laminate.this.getTarget();
                    group.endResize();
                }
                if (Laminate.this.getTarget().contains(evt.getPoint())) {
                    Laminate.this.setCursor(new Cursor(13));
                } else {
                    Laminate.this.setCursor(new Cursor(0));
                }
            }
        }

        /* synthetic */ 6() {
        }
    }
}

