/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XPoint2D;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.ParseException;
import javax.swing.event.SwingPropertyChangeSupport;

public class Interval
implements Cloneable,
Serializable,
Stringable {
    protected static final String MINIMUM = "minimum";
    protected static final String MAXIMUM = "maximum";
    protected static final String MIDPOINT = "midpoint";
    protected static final String SIZE = "SIZE";
    protected double minimum = 0.0;
    protected double maximum = 0.0;
    protected double size = 0.0;
    protected double midpoint = 0.0;
    protected SwingPropertyChangeSupport changeAdapter = new SwingPropertyChangeSupport(this);

    public Interval() {
    }

    public Interval(double endpointA, double endpointB) {
        this.setEndpoints(endpointA, endpointB);
    }

    public Interval(String data) throws ParseException {
        this.fromStringData(data);
    }

    public String toStringData() {
        return this.toString();
    }

    public void fromStringData(String data) throws ParseException {
        if (data == null) {
            throw new ParseException("Input was null.", -1);
        }
        String[] pair = XPoint2D.decodeIntoPair(data);
        double lower = XDouble.parseDouble(pair[0]);
        double upper = XDouble.parseDouble(pair[1]);
        this.setEndpoints(lower, upper);
    }

    public String toString() {
        return "[" + this.minimum + ";" + this.maximum + "]";
    }

    public void setEndpoints(double endpointA, double endpointB) {
        double oldMin = this.getMinimum();
        double oldMax = this.getMaximum();
        double oldMid = this.getMidpoint();
        double oldSize = this.getSize();
        if (endpointA <= endpointB) {
            this.minimum = endpointA;
            this.maximum = endpointB;
        } else {
            this.minimum = endpointB;
            this.maximum = endpointA;
        }
        this.size = this.maximum - this.minimum;
        this.midpoint = (this.minimum + this.maximum) / 2.0;
        if (this.getMinimum() != oldMin) {
            this.changeAdapter.firePropertyChange(MINIMUM, new Double(oldMin), new Double(this.getMinimum()));
        }
        if (this.getMaximum() != oldMax) {
            this.changeAdapter.firePropertyChange(MAXIMUM, new Double(oldMax), new Double(this.getMaximum()));
        }
        if (this.getMidpoint() != oldMid) {
            this.changeAdapter.firePropertyChange(MIDPOINT, new Double(oldMid), new Double(this.getMidpoint()));
        }
        if (this.getSize() != oldSize) {
            this.changeAdapter.firePropertyChange(SIZE, new Double(oldSize), new Double(this.getSize()));
        }
    }

    public void setInterval(Interval other) {
        if (other == null) {
            return;
        }
        this.setEndpoints(other.minimum, other.maximum);
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getSize() {
        return this.size;
    }

    public double getMidpoint() {
        return this.midpoint;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(propertyName, listener);
    }
}

