/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.util.DimensionUtilities;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;

public class AlignedLayout
implements LayoutManager2,
JPTConstants {
    protected Component c = null;
    protected int alignment = 6;

    public AlignedLayout() {
    }

    public AlignedLayout(int alignment) {
        this.setAlignment(alignment);
    }

    public void addLayoutComponent(String name, Component component) {
        this.addLayoutComponent(component, null);
    }

    public void addLayoutComponent(Component component, Object constraints) {
        this.c = component;
    }

    public void removeLayoutComponent(Component component) {
        if (this.c == component) {
            this.c = null;
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        if (this.c == null) {
            return DimensionUtilities.createMinimumDimension();
        }
        return DimensionUtilities.expand(this.c.getMinimumSize(), parent.getInsets());
    }

    public Dimension preferredLayoutSize(Container parent) {
        if (this.c == null) {
            return DimensionUtilities.createMinimumDimension();
        }
        return DimensionUtilities.expand(this.c.getPreferredSize(), parent.getInsets());
    }

    public Dimension maximumLayoutSize(Container parent) {
        if (this.c == null) {
            return DimensionUtilities.createMaximumDimension();
        }
        return DimensionUtilities.expand(this.c.getMaximumSize(), parent.getInsets());
    }

    public void layoutContainer(Container parent) {
        if (this.c == null) {
            return;
        }
        Insets insets = parent.getInsets();
        Dimension pSize = DimensionUtilities.shrink(parent.getSize(), insets);
        Dimension cSize = DimensionUtilities.min(this.c.getPreferredSize(), pSize);
        Point location = this.applyAlignment(cSize, pSize, new Point(insets.left, insets.top));
        this.c.setBounds(location.x, location.y, cSize.width, cSize.height);
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    public void setAlignment(int align) {
        switch (align) {
            case -1: {
                align = 8;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.alignment = align;
            }
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    protected Point applyAlignment(Dimension cSize, Dimension pSize, Point origin) {
        Point p = new Point();
        int dx = pSize.width - cSize.width;
        int dy = pSize.height - cSize.height;
        if (dx < 0) {
            dx = 0;
        }
        if (dy < 0) {
            dy = 0;
        }
        int flushWest = origin.x;
        int centerWE = origin.x + dx / 2;
        int flushEast = origin.x + dx;
        int flushNorth = origin.y;
        int centerNS = origin.y + dy / 2;
        int flushSouth = origin.y + dy;
        switch (this.getAlignment()) {
            case 2: {
                p.setLocation(flushEast, flushNorth);
                break;
            }
            case 3: {
                p.setLocation(flushEast, centerNS);
                break;
            }
            case 4: {
                p.setLocation(flushEast, flushSouth);
                break;
            }
            case 1: {
                p.setLocation(centerWE, flushNorth);
                break;
            }
            case 0: {
                p.setLocation(centerWE, centerNS);
                break;
            }
            case 5: {
                p.setLocation(centerWE, flushSouth);
                break;
            }
            case 8: {
                p.setLocation(flushWest, flushNorth);
                break;
            }
            case 7: {
                p.setLocation(flushWest, centerNS);
                break;
            }
            default: {
                p.setLocation(flushWest, flushSouth);
            }
        }
        return p;
    }
}

