/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.codec.CodecUtilities;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.ParseException;
import java.util.StringTokenizer;
import javax.swing.event.SwingPropertyChangeSupport;

public final class XPoint2D
extends Point2D.Double
implements Cloneable,
Serializable,
Stringable {
    protected static final String X_PROPERTY = "x";
    protected static final String Y_PROPERTY = "y";
    protected SwingPropertyChangeSupport changeAdapter = new SwingPropertyChangeSupport(this);

    public XPoint2D() {
    }

    public XPoint2D(Point2D p) {
        this.setValue(p);
    }

    public XPoint2D(double x, double y) {
        this.setValue(x, y);
    }

    public XPoint2D(String data) throws ParseException {
        this.fromStringData(data);
    }

    public String toStringData() {
        return this.toString();
    }

    public void fromStringData(String data) throws ParseException {
        if (data == null) {
            throw new ParseException("Input was null.", -1);
        }
        String[] pair = XPoint2D.decodeIntoPair(data);
        double xx = XDouble.parseDouble(pair[0]);
        double yy = XDouble.parseDouble(pair[1]);
        this.setValue(xx, yy);
    }

    public String toString() {
        return "[" + this.x + ";" + this.y + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] decodeIntoPair(String data) throws ParseException {
        String NO_DATA = "Data string is missing or empty";
        String NO_PAIR = "Expected [x;y] or (x,y) with x and y of type double.";
        if (data == null) {
            throw new ParseException("Data string is missing or empty", 0);
        }
        String trim = data.trim();
        if (trim.length() == 0) {
            throw new ParseException("Data string is missing or empty", 0);
        }
        String[] pair = null;
        int last = trim.length() - 1;
        boolean isSimple = trim.charAt(0) == '[' && trim.charAt(last) == ']' || trim.charAt(0) == '(' && trim.charAt(last) == ')';
        if (!isSimple) return CodecUtilities.decode(data);
        String separator = trim.charAt(0) == '[' ? ";" : ",";
        String XY = trim.substring(1, last);
        StringTokenizer tokenizer = new StringTokenizer(XY, separator);
        int tokencount = tokenizer.countTokens();
        if (tokencount != 2) throw new ParseException("Expected [x;y] or (x,y) with x and y of type double.", data.length());
        pair = new String[]{tokenizer.nextToken(), tokenizer.nextToken()};
        return pair;
    }

    public void setValue(Point2D p) {
        if (p != null) {
            this.setValue(p.getX(), p.getY());
        }
    }

    public void setValue(double newX, double newY) {
        double oldX = this.x;
        double oldY = this.y;
        this.x = newX;
        this.y = newY;
        if (newX != oldX) {
            this.changeAdapter.firePropertyChange(X_PROPERTY, new Double(oldX), new Double(newX));
        }
        if (newY != oldY) {
            this.changeAdapter.firePropertyChange(Y_PROPERTY, new Double(oldY), new Double(newY));
        }
    }

    public double radius() {
        return this.distance(0.0, 0.0);
    }

    public double radiusSq() {
        return this.distanceSq(0.0, 0.0);
    }

    public double angleInRadians() {
        return XPoint2D.angleInRadians(1.0, 0.0, this.x, this.y);
    }

    public double angleInDegrees() {
        return Math.toDegrees(this.angleInRadians());
    }

    public static double angleInRadians(Point2D p, Point2D q) {
        if (p != null && q != null) {
            return XPoint2D.angleInRadians(p.getX(), p.getY(), q.getX(), q.getY());
        }
        return 0.0;
    }

    public static double angleInRadians(double x1, double y1, double x2, double y2) {
        double radians = Math.atan2(y2, x2) - Math.atan2(y1, x1);
        if (radians < 0.0) {
            radians += Math.PI * 2;
        }
        return radians;
    }

    public static double angleInDegrees(Point2D p, Point2D q) {
        return Math.toDegrees(XPoint2D.angleInRadians(p, q));
    }

    public static double angleInDegrees(double x1, double y1, double x2, double y2) {
        return Math.toDegrees(XPoint2D.angleInRadians(x1, y1, x2, y2));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(propertyName, listener);
    }
}

