/* 
TestSuite.java  26 February 2003 */


import java.awt.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

import java.math.*;

public class TestSuite extends JPFalt 
{
    public static void main(String[] args) { new TestSuite(); }
    
    ///////////////////////////////////////////////////////////
    // Place your actual methods here.                       //
    ///////////////////////////////////////////////////////////
    
    // Division by zero causes an ArithmeticException to be thrown.
    // Catch it here, and print out a message to the console with an
    // informative error message.
    void DividebyZero() {
    
    	int x = 3/0;
    	
    }
	 	
	/*----------------------------------------------------------------------- 
	 Test Balloons
	------------------------------------------------------------------------- */
    
    void TenBalloons() {
    // Create ten balloons
    // Use random number generator to select the center (between 100 and 200)
    // Use random number generator to select the radius (between 10 and 50)
    	
    	int x;								// declare horizontal coordinate
    	int y;								// declare vertical coordinate
    	int radius;							// declare variable for radius
    	
    	Balloon b;
    	    	
    	for (int i = 1; i <= 10; i++){		// count from one to ten
    	
    	    // set value of horizontal coordinate
    		x = MathUtilities.randomInt(100, 300);	
    			
    		// set value of vertical coordinate
    		y = MathUtilities.randomInt(100, 300);		
    		
    		// set value of variable for radius
    		radius = MathUtilities.randomInt(10, 90);
    		
			b = new Balloon(x, y, 
			                radius, 
			                new Color(x%256, y%256, radius));
			b.paintBalloon(window);
			
    	}
    	// post-mortem
    	console.out.println("Ten balloons done.");
    }
    
	/*-------------------------------------------------------- 
	 Test Balloon View
	--------------------------------------------------------*/
 
    void TestBalloonView() {
    
        Balloon[] b = new Balloon[4];
        int x;
        int y;
        int radius;
        
        /* make array of four balloons - a bad one */
        b[0] = new Balloon(100, 200, 25, Color.red);
        b[1] = new Balloon(300, 100, 40, Color.blue);
        
        // want another Balloon just like b[0]... but this doesn't make a new Balloon.
       	b[2] = b[0]; 
        	
        b[3] = new Balloon(200, 200, 30, Color.green);
    	 
		makeBalloonView(b);
	}
	
	/*----------------------------------------------------------------------- 
	 Test five random balloons
	------------------------------------------------------------------------- */
	void RandomBalloons(){
	
	    int x;
	    int y;
	    int radius;
	    
        Balloon[] b = new Balloon[5];
	
        for (int i = 0; i < 5; i++){
    	
    	    // set value of horizontal coordinate
    		x = MathUtilities.randomInt(100, 300);	
    			
    		// set value of vertical coordinate
    		y = MathUtilities.randomInt(100, 300);		
    		
    		// set value of variable for radius
    		radius = MathUtilities.randomInt(10, 90);
    		
			b[i] = new Balloon(x, y, 
			                radius, 
			                new Color(x%256, y%256, radius));
			                
			b[i].paintBalloon(window);
		}
		
		makeBalloonView(b);
	}
	
	/*--------------------------------------------------------
	A series of tests of balloon equality
	--------------------------------------------------------*/
	void TestBalloonEqual() {
		Balloon[] b = new Balloon[] {
			new Balloon(10, 20, 30, Color.blue),
			new Balloon(5, 50, 10, Color.red),
			new Balloon(10, 20, 30, Color.blue)
			};
			
		testHeader("-Balloon Equality Tests-");
		
		console.out.println("*Comparing: \n\t" + b[0] + " to\n\t" + b[1]);
		expected(false);
		actual(b[0].equals(b[1]));
		console.out.println();
		
		console.out.println("*Comparing:\n\t" + b[1] + "\n\tto itself");
		expected(true);
		actual(b[1].equals(b[1]));
		console.out.println();
		
		console.out.println("*Comparing:\n\t" + b[0] + " to\n\t" + b[2]);
		expected(true);
		actual(b[0].equals(b[2]));
		console.out.println();
	}

    /* Helper method to install controls for an array of balloons */
    void makeBalloonView(Balloon[] bArray){
     	
        /* install the views in a new table panel */
        GeneralDialog.showOKDialog(new TablePanel(
                                    (new BalloonDialog(bArray, window)).bw,
                                    1, 1,
                                    VERTICAL),
                                  "Balloon Array Controller");
    }
}

