/* 
BalloonDialog.java  26 February 2003 */


import java.awt.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

/* An array of balloon views allowing for global reset of whole array */
public class BalloonDialog{
    
    /* the views for the balloons */
    BalloonView[] bw;
    
    /* the array of balloon objects */
    Balloon[] bArray;
    
    /* number of balloon views */
    int length;
    
    /* The graphics display panel */
    BufferedPanel window;
    
    /* constructor */
    BalloonDialog(Balloon[] anArray, BufferedPanel window){
    
        this.window = window;
        this.bArray = anArray;
        
        /* display is limited to four balloons */
        this.length = Math.min(5, bArray.length);
        this.bw = new BalloonView[length];
        
        /* build a view for each balloon */
        for (int i = 0; i < this.length; i++){
            bw[i] = new BalloonView(i, bArray, this, window);
        }
        
        /* set the view states and paint the balloons */
        resetViews();
    } 
    
    /* reset all views and repaint all balloons */
    void resetViews(){
    
        window.clearPanel();
        for (int i = 0; i < this.length; i++){
            bw[i].setViewState();
            bArray[i].paintBalloon(window);
        }
        
    }  
}

