/*
 * @(#)Balloon.java  1.0  30 July 2002
 *
 * @author Viera K. Proulx
 */

import edu.neu.ccs.gui.*;	// to get BufferedPanel
import java.awt.*;			// to get Color
import java.awt.geom.*;		// to get Graphics2D functionality

/** A simple class to represent a balloon. */
class Balloon implements Cloneable {
    
    /*-------------------------------------------------------------------------
     Member data 
     *-----------------------------------------------------------------------*/
    
    /** center of the balloon */
    int x;
    int y;

    /** the radius of the balloon */
    int radius;

    /** the color of the balloon */
    Color c;

    /*-------------------------------------------------------------------------
     Constructor
     *-----------------------------------------------------------------------*/
    
    public Balloon (int some_x, int some_y, int some_radius, Color some_color){
        this.x = some_x;
        this.y = some_y;
        this.radius = some_radius;
        this.c = some_color;
    }
    
    /** copy constructor */
    public Balloon(Balloon someBalloon){
        new Balloon(someBalloon.x, someBalloon.y, 
        			someBalloon.radius, someBalloon.c);
    }

    /*-------------------------------------------------------------------------
     Methods 
     *-----------------------------------------------------------------------*/
    
    /** compute the diameter of the balloon */
    int getDiameter(){
        return 2 * this.radius;
    }
    
    /** compute the distance of this balloon from the top of window */
    int distanceFromTop(){
    	return this.y - this.radius;
    }

    /** compare the top of this and the given other balloon */
    boolean isHigherThan(Balloon otherBln){
        return this.distanceFromTop() < otherBln.distanceFromTop() ;
    }
        
    /** show balloon in the given buffered panel window */
    void paintBalloon(BufferedPanel window){
        
        if (window == null)
            return;
            
        // get graphics context and set the color
        Graphics2D G = window.getBufferGraphics();
        G.setPaint(c);
        
        // paint the ballon
        Ellipse2D.Double E = 
            new Ellipse2D.Double(this.x - this.radius, this.y - this.radius, 
                                 this.getDiameter(), this.getDiameter());
        G.fill(E);
        
        // paint the string
        Line2D.Double L =
            new Line2D.Double(this.x, this.y + this.radius, this.x, this.y + 3 * this.radius);
        G.draw(L);
        window.repaint();
    }
    
    /** clone! */
    public Object clone() throws CloneNotSupportedException {
    	return super.clone();
    }
    
    /** print the balloon data */
    public String toString(){
    	return ("new " + getClass() + "(" + 
    	        this.x + ", " + 
    	        this.y + ", " + 
    	        this.radius + ", " + 
    	        this.c + ")");
    }
    
}
