/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

import java.awt.Dimension;
import java.awt.Insets;

public class DimensionUtilities {
    public static Dimension createDimension(int width, int height) {
        width = Math.max(width, 0);
        height = Math.max(height, 0);
        return new Dimension(width, height);
    }

    public static Dimension createDimension(Dimension d) {
        return DimensionUtilities.createDimension((int)d.getWidth(), (int)d.getHeight());
    }

    public static Dimension createMinimumDimension() {
        return new Dimension(0, 0);
    }

    public static Dimension createMaximumDimension() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static Dimension min(Dimension d1, Dimension d2) {
        int width = Math.min((int)d1.getWidth(), (int)d2.getWidth());
        int height = Math.min((int)d1.getHeight(), (int)d2.getHeight());
        return DimensionUtilities.createDimension(width, height);
    }

    public static Dimension max(Dimension d1, Dimension d2) {
        int width = Math.max((int)d1.getWidth(), (int)d2.getWidth());
        int height = Math.max((int)d1.getHeight(), (int)d2.getHeight());
        return DimensionUtilities.createDimension(width, height);
    }

    public static Dimension expand(Dimension d, Insets insets) {
        int width = (int)d.getWidth();
        int height = (int)d.getHeight();
        int dx = insets.left + insets.right;
        int dy = insets.top + insets.bottom;
        if (dx > 0) {
            width = width < Integer.MAX_VALUE - dx ? (width += dx) : Integer.MAX_VALUE;
        }
        if (dy > 0) {
            height = height < Integer.MAX_VALUE - dy ? (height += dy) : Integer.MAX_VALUE;
        }
        return DimensionUtilities.createDimension(width, height);
    }

    public static Dimension shrink(Dimension d, Insets insets) {
        int width = (int)d.getWidth();
        int height = (int)d.getHeight();
        int dx = insets.left + insets.right;
        int dy = insets.top + insets.bottom;
        if (dx > 0) {
            width = width > dx ? (width -= dx) : 0;
        }
        if (dy > 0) {
            height = height > dy ? (height -= dy) : 0;
        }
        return DimensionUtilities.createDimension(width, height);
    }
}

