/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.parser;

import edu.neu.ccs.XBigInteger;
import edu.neu.ccs.XBoolean;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XNumber;
import edu.neu.ccs.parser.AbstractParser;
import edu.neu.ccs.parser.ParserUtilities;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Vector;

public class JPTParser
extends AbstractParser {
    protected NumericOperation opPlus;
    protected NumericOperation opMinus;
    protected NumericOperation opTimes;
    protected NumericOperation opSlash;
    protected NumericOperation opPercent;
    protected BooleanOperation opEQ;
    protected BooleanOperation opNE;
    protected BooleanOperation opLT;
    protected BooleanOperation opGT;
    protected BooleanOperation opLE;
    protected BooleanOperation opGE;
    protected BooleanOperation opAND;
    protected BooleanOperation opOR;
    protected BooleanOperation opNOT;
    protected AbstractParser.Procedure procAbs;
    protected AbstractParser.Procedure procCeiling;
    protected AbstractParser.Procedure procFloor;
    protected AbstractParser.Procedure procRound;
    protected AbstractParser.Procedure procMax;
    protected AbstractParser.Procedure procMin;
    protected AbstractParser.Procedure procSqrt;
    protected AbstractParser.Procedure procPower;
    protected AbstractParser.Procedure procToDegrees;
    protected AbstractParser.Procedure procToRadians;
    protected AbstractParser.Procedure procSin;
    protected AbstractParser.Procedure procSinDeg;
    protected AbstractParser.Procedure procCos;
    protected AbstractParser.Procedure procCosDeg;
    protected AbstractParser.Procedure procTan;
    protected AbstractParser.Procedure procTanDeg;
    protected AbstractParser.Procedure procASin;
    protected AbstractParser.Procedure procASinDeg;
    protected AbstractParser.Procedure procACos;
    protected AbstractParser.Procedure procACosDeg;
    protected AbstractParser.Procedure procATan;
    protected AbstractParser.Procedure procATanDeg;
    protected AbstractParser.Procedure procATan2;
    protected AbstractParser.Procedure procATan2Deg;
    protected AbstractParser.Procedure procExp;
    protected AbstractParser.Procedure procLn;
    protected AbstractParser.Procedure procLog;
    protected AbstractParser.Procedure procLogToBase;
    protected AbstractParser.Procedure procRandom;

    public Object parse(String d) throws ParseException {
        this.data = d;
        this.next = 0;
        if (this.data == null) {
            throw new ParseException("Input was null.", -1);
        }
        AbstractParser.ObjectOperationPair ooPair = this.parseExpression(new AbstractParser.ObjectOperationPair(null, this.identity));
        Object value = ooPair.value;
        if (value == null) {
            throw new ParseException("Expected expression.", this.next);
        }
        if (this.next < this.data.length()) {
            throw new ParseException("Expected end of expression.", this.next);
        }
        return value;
    }

    protected void defineNumericOperations() {
        this.opPlus = new 1("+", true, true);
        this.opMinus = new 2("-", true, true);
        this.opTimes = new 3("*", false, true);
        this.opSlash = new 4("/", false, true);
        this.opPercent = new 5("%", false, true);
    }

    protected void defineBooleanOperations() {
        this.opEQ = new 6("==", false, true, true);
        this.opNE = new 7("!=", false, true, true);
        this.opLT = new 8("<", false, true, true);
        this.opGT = new 9(">", false, true, true);
        this.opLE = new 10("<=", false, true, true);
        this.opGE = new 11(">=", false, true, true);
        this.opAND = new 12("&&", false, true, false);
        this.opOR = new 13("||", false, true, false);
        this.opNOT = new 14("!", true, false, false);
    }

    protected void addOperations() {
        this.defineNumericOperations();
        this.defineBooleanOperations();
        this.addOperationAfterPrecedenceOf(this.identity, this.opOR);
        this.addOperationAfterPrecedenceOf(this.opOR, this.opAND);
        this.addOperationAfterPrecedenceOf(this.opAND, this.opEQ);
        this.addOperationAtPrecedenceOf(this.opEQ, this.opNE);
        this.addOperationAfterPrecedenceOf(this.opEQ, this.opLT);
        this.addOperationAtPrecedenceOf(this.opLT, this.opGT);
        this.addOperationAtPrecedenceOf(this.opLT, this.opLE);
        this.addOperationAtPrecedenceOf(this.opLT, this.opGE);
        this.addOperationAfterPrecedenceOf(this.opLT, this.opPlus);
        this.addOperationAtPrecedenceOf(this.opPlus, this.opMinus);
        this.addOperationAfterPrecedenceOf(this.opPlus, this.opTimes);
        this.addOperationAtPrecedenceOf(this.opTimes, this.opSlash);
        this.addOperationAtPrecedenceOf(this.opTimes, this.opPercent);
        this.addOperationAfterPrecedenceOf(this.opTimes, this.opNOT);
    }

    protected void defineProcedures() {
        this.procAbs = new 15("abs", 1);
        this.procCeiling = new 16("ceiling", 1);
        this.procFloor = new 17("floor", 1);
        this.procRound = new 18("round", 1);
        this.procMax = new 19("max", 2);
        this.procMin = new 20("min", 2);
        this.procSqrt = new 21("sqrt", 1);
        this.procPower = new 22("power", 2);
        this.procToDegrees = new 23("todegrees", 1);
        this.procToRadians = new 24("toradians", 1);
        this.procSin = new 25("sin", 1);
        this.procSinDeg = new 26("sindeg", 1);
        this.procCos = new 27("cos", 1);
        this.procCosDeg = new 28("cosdeg", 1);
        this.procTan = new 29("tan", 1);
        this.procTanDeg = new 30("tandeg", 1);
        this.procASin = new 31("asin", 1);
        this.procASinDeg = new 32("asindeg", 1);
        this.procACos = new 33("acos", 1);
        this.procACosDeg = new 34("acosdeg", 1);
        this.procATan = new 35("atan", 1);
        this.procATanDeg = new 36("atandeg", 1);
        this.procATan2 = new 37("atan2", 2);
        this.procATan2Deg = new 38("atan2deg", 2);
        this.procExp = new 39("exp", 1);
        this.procLn = new 40("ln", 1);
        this.procLog = new 41("log", 1);
        this.procLogToBase = new 42("logtobase", 2);
        this.procRandom = new 43("random", 2);
    }

    protected void addProcedures() {
        this.defineProcedures();
        this.addProcedure(this.procAbs);
        this.addProcedure(this.procCeiling);
        this.addProcedure(this.procFloor);
        this.addProcedure(this.procRound);
        this.addProcedure(this.procMax);
        this.addProcedure(this.procMin);
        this.addProcedure(this.procSqrt);
        this.addProcedure(this.procPower);
        this.addProcedure(this.procToDegrees);
        this.addProcedure(this.procToRadians);
        this.addProcedure(this.procSin);
        this.addProcedure(this.procSinDeg);
        this.addProcedure(this.procCos);
        this.addProcedure(this.procCosDeg);
        this.addProcedure(this.procTan);
        this.addProcedure(this.procTanDeg);
        this.addProcedure(this.procASin);
        this.addProcedure(this.procASinDeg);
        this.addProcedure(this.procACos);
        this.addProcedure(this.procACosDeg);
        this.addProcedure(this.procATan);
        this.addProcedure(this.procATanDeg);
        this.addProcedure(this.procATan2);
        this.addProcedure(this.procATan2Deg);
        this.addProcedure(this.procExp);
        this.addProcedure(this.procLn);
        this.addProcedure(this.procLog);
        this.addProcedure(this.procLogToBase);
        this.addProcedure(this.procRandom);
    }

    protected void addConstants() {
        this.addConstant("pi", new XDouble(Math.PI));
        this.addConstant("e", new XDouble(Math.E));
        this.addConstant("true", new XBoolean(true));
        this.addConstant("false", new XBoolean(false));
        this.addConstant("Infinity", new XDouble(Double.POSITIVE_INFINITY));
        this.addConstant("NaN", new XDouble(Double.NaN));
    }

    /*
     * Unable to fully structure code
     */
    protected AbstractParser.ObjectOperationPair parseExpression(AbstractParser.ObjectOperationPair standing) throws ParseException {
        left = standing.value;
        term = null;
        oldOp = standing.operation;
        newOp = null;
        oldPr = this.precedenceOf(oldOp);
        newPr = -1;
        if (oldOp == null) {
            throw new ParseException("Expected binary operation.", this.next);
        }
        while (true) {
            term = this.nextTerm();
            newOp = this.nextOperation();
            newPr = this.precedenceOf(newOp);
            if (newOp == null || newOp.isBinary()) ** GOTO lbl19
            throw new ParseException("Expected binary operation.", this.next);
lbl-1000:
            // 1 sources

            {
                ooPair = this.parseExpression(new AbstractParser.ObjectOperationPair(term, newOp));
                term = ooPair.value;
                newOp = ooPair.operation;
                newPr = this.precedenceOf(newOp);
lbl19:
                // 2 sources

                ** while (newPr > oldPr)
            }
lbl20:
            // 1 sources

            term = oldOp.performOperation(left, term);
            if (newPr != oldPr) break;
            left = term;
            oldOp = newOp;
        }
        return new AbstractParser.ObjectOperationPair(term, newOp);
    }

    protected Object nextTerm() throws ParseException {
        AbstractParser.Operation[] operations = this.nextUnaryOperations();
        int length = operations.length;
        Object term = this.nextSimpleTerm();
        int i = length - 1;
        while (i >= 0) {
            term = operations[i].performOperation(null, term);
            --i;
        }
        return term;
    }

    protected Object nextSimpleTerm() throws ParseException {
        Object term = null;
        if (this.nextTokenIs(this.NESTED_EXPRESSION_START)) {
            term = this.parseNestedExpression();
        } else if (this.startsNumber()) {
            term = this.parseNumber();
        } else if (this.startsIdentifier()) {
            String identifier = this.parseIdentifier();
            term = this.nextTokenIs(this.ARGUMENT_LIST_START) ? this.parseProcedureCall(identifier) : this.parseVariable(identifier);
        } else {
            throw new ParseException("Expected term.", this.next);
        }
        return term;
    }

    protected AbstractParser.Operation[] nextUnaryOperations() throws ParseException {
        AbstractParser.Operation operation;
        Vector<AbstractParser.Operation> operations = new Vector<AbstractParser.Operation>();
        while ((operation = this.nextOperation()) != null) {
            if (operation.isUnary()) {
                operations.add(operation);
                continue;
            }
            throw new ParseException("Expected unary operation.", this.next);
        }
        return operations.toArray(new AbstractParser.Operation[0]);
    }

    protected Object parseNestedExpression() throws ParseException {
        Object term = null;
        if (this.nextTokenIs(this.NESTED_EXPRESSION_START)) {
            ++this.next;
            AbstractParser.ObjectOperationPair ooPair = this.parseExpression(new AbstractParser.ObjectOperationPair(null, this.identity));
            term = ooPair.value;
            this.skipWhitespace();
            if (this.next == this.data.length() || !this.nextTokenIs(this.NESTED_EXPRESSION_END)) {
                throw new ParseException("Expected end of nested expression.", this.next);
            }
            ++this.next;
        }
        return term;
    }

    protected Object parseProcedureCall(String identifier) throws ParseException {
        if (!this.procedures.containsKey(identifier)) {
            throw new ParseException("Unrecognized procedure " + identifier + ".", this.next);
        }
        AbstractParser.Procedure procedure = (AbstractParser.Procedure)this.procedures.get(identifier);
        Object term = null;
        try {
            term = procedure.procedureCall(this.parseArgumentList());
        }
        catch (ParseException exception) {
            throw new ParseException(exception.getMessage(), this.next);
        }
        return term;
    }

    protected Object parseVariable(String identifier) throws ParseException {
        if (!this.environment.containsKey(identifier)) {
            throw new ParseException("Unrecognized identifier.", this.next);
        }
        return this.environment.get(identifier);
    }

    private final class 1
    extends NumericOperation {
        public Object unaryForXIntegral(XBigInteger a) {
            return a;
        }

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger va = a.getValue();
            BigInteger vb = b.getValue();
            return new XBigInteger(va.add(vb));
        }

        public Object unaryForXFloating(XDouble x) {
            return x;
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vx = x.getValue();
            double vy = y.getValue();
            return new XDouble(vx + vy);
        }

        /* synthetic */ 1(String $0, boolean $1, boolean $2) {
            super($0, $1, $2);
        }
    }

    private final class 2
    extends NumericOperation {
        public Object unaryForXIntegral(XBigInteger a) {
            BigInteger va = a.getValue();
            return new XBigInteger(va.negate());
        }

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger va = a.getValue();
            BigInteger vb = b.getValue();
            return new XBigInteger(va.subtract(vb));
        }

        public Object unaryForXFloating(XDouble x) {
            double vx = x.getValue();
            return new XDouble(-vx);
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vx = x.getValue();
            double vy = y.getValue();
            return new XDouble(vx - vy);
        }

        /* synthetic */ 2(String $0, boolean $1, boolean $2) {
            super($0, $1, $2);
        }
    }

    private final class 3
    extends NumericOperation {
        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger va = a.getValue();
            BigInteger vb = b.getValue();
            return new XBigInteger(va.multiply(vb));
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vx = x.getValue();
            double vy = y.getValue();
            return new XDouble(vx * vy);
        }

        /* synthetic */ 3(String $0, boolean $1, boolean $2) {
            super($0, $1, $2);
        }
    }

    private final class 4
    extends NumericOperation {
        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger va = a.getValue();
            BigInteger vb = b.getValue();
            if (vb.equals(BigInteger.ZERO)) {
                int test = va.compareTo(BigInteger.ZERO);
                if (test > 0) {
                    return new XDouble(Double.POSITIVE_INFINITY);
                }
                if (test < 0) {
                    return new XDouble(Double.NEGATIVE_INFINITY);
                }
                return new XDouble(Double.NaN);
            }
            return new XBigInteger(va.divide(vb));
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vx = x.getValue();
            double vy = y.getValue();
            return new XDouble(vx / vy);
        }

        /* synthetic */ 4(String $0, boolean $1, boolean $2) {
            super($0, $1, $2);
        }
    }

    private final class 5
    extends NumericOperation {
        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger va = a.getValue();
            BigInteger vb = b.getValue();
            if (vb.equals(BigInteger.ZERO)) {
                return new XDouble(Double.NaN);
            }
            return new XBigInteger(va.remainder(vb));
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vx = x.getValue();
            double vy = y.getValue();
            return new XDouble(vx % vy);
        }

        /* synthetic */ 5(String $0, boolean $1, boolean $2) {
            super($0, $1, $2);
        }
    }

    private final class 6
    extends BooleanOperation {
        public Object binaryForXBoolean(XBoolean p, XBoolean q) {
            boolean vq;
            boolean vp = p.getValue();
            return new XBoolean(vp == (vq = q.getValue()));
        }

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger vb;
            BigInteger va = a.getValue();
            int test = va.compareTo(vb = b.getValue());
            return new XBoolean(test == 0);
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vy;
            double vx = x.getValue();
            return new XBoolean(vx == (vy = y.getValue()));
        }

        /* synthetic */ 6(String $0, boolean $1, boolean $2, boolean $3) {
            super($0, $1, $2, $3);
        }
    }

    private final class 7
    extends BooleanOperation {
        public Object binaryForXBoolean(XBoolean p, XBoolean q) {
            boolean vq;
            boolean vp = p.getValue();
            return new XBoolean(vp != (vq = q.getValue()));
        }

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger vb;
            BigInteger va = a.getValue();
            int test = va.compareTo(vb = b.getValue());
            return new XBoolean(test != 0);
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vy;
            double vx = x.getValue();
            return new XBoolean(vx != (vy = y.getValue()));
        }

        /* synthetic */ 7(String $0, boolean $1, boolean $2, boolean $3) {
            super($0, $1, $2, $3);
        }
    }

    private final class 8
    extends BooleanOperation {
        public Object binaryForXBoolean(XBoolean p, XBoolean q) {
            boolean vp = p.getValue();
            boolean vq = q.getValue();
            return new XBoolean(!vp && vq);
        }

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger vb;
            BigInteger va = a.getValue();
            int test = va.compareTo(vb = b.getValue());
            return new XBoolean(test < 0);
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vy;
            double vx = x.getValue();
            return new XBoolean(vx < (vy = y.getValue()));
        }

        /* synthetic */ 8(String $0, boolean $1, boolean $2, boolean $3) {
            super($0, $1, $2, $3);
        }
    }

    private final class 9
    extends BooleanOperation {
        public Object binaryForXBoolean(XBoolean p, XBoolean q) {
            boolean vp = p.getValue();
            boolean vq = q.getValue();
            return new XBoolean(vp && !vq);
        }

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger vb;
            BigInteger va = a.getValue();
            int test = va.compareTo(vb = b.getValue());
            return new XBoolean(test > 0);
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vy;
            double vx = x.getValue();
            return new XBoolean(vx > (vy = y.getValue()));
        }

        /* synthetic */ 9(String $0, boolean $1, boolean $2, boolean $3) {
            super($0, $1, $2, $3);
        }
    }

    private final class 10
    extends BooleanOperation {
        public Object binaryForXBoolean(XBoolean p, XBoolean q) {
            boolean vp = p.getValue();
            boolean vq = q.getValue();
            return new XBoolean(!vp || vq);
        }

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger vb;
            BigInteger va = a.getValue();
            int test = va.compareTo(vb = b.getValue());
            return new XBoolean(test <= 0);
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vy;
            double vx = x.getValue();
            return new XBoolean(vx <= (vy = y.getValue()));
        }

        /* synthetic */ 10(String $0, boolean $1, boolean $2, boolean $3) {
            super($0, $1, $2, $3);
        }
    }

    private final class 11
    extends BooleanOperation {
        public Object binaryForXBoolean(XBoolean p, XBoolean q) {
            boolean vp = p.getValue();
            boolean vq = q.getValue();
            return new XBoolean(vp || !vq);
        }

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            BigInteger vb;
            BigInteger va = a.getValue();
            int test = va.compareTo(vb = b.getValue());
            return new XBoolean(test >= 0);
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            double vy;
            double vx = x.getValue();
            return new XBoolean(vx >= (vy = y.getValue()));
        }

        /* synthetic */ 11(String $0, boolean $1, boolean $2, boolean $3) {
            super($0, $1, $2, $3);
        }
    }

    private final class 12
    extends BooleanOperation {
        public Object binaryForXBoolean(XBoolean p, XBoolean q) {
            boolean vp = p.getValue();
            boolean vq = q.getValue();
            return new XBoolean(vp && vq);
        }

        /* synthetic */ 12(String $0, boolean $1, boolean $2, boolean $3) {
            super($0, $1, $2, $3);
        }
    }

    private final class 13
    extends BooleanOperation {
        public Object binaryForXBoolean(XBoolean p, XBoolean q) {
            boolean vp = p.getValue();
            boolean vq = q.getValue();
            return new XBoolean(vp || vq);
        }

        /* synthetic */ 13(String $0, boolean $1, boolean $2, boolean $3) {
            super($0, $1, $2, $3);
        }
    }

    private final class 14
    extends BooleanOperation {
        public Object unaryForXBoolean(XBoolean p) {
            boolean vp = p.getValue();
            return new XBoolean(vp ^ true);
        }

        /* synthetic */ 14(String $0, boolean $1, boolean $2, boolean $3) {
            super($0, $1, $2, $3);
        }
    }

    private final class 15
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            if (ParserUtilities.isXIntegral(args[0])) {
                XBigInteger a = ParserUtilities.toXBigInteger((XNumber)args[0]);
                BigInteger va = a.getValue();
                int test = va.compareTo(BigInteger.ZERO);
                if (test >= 0) {
                    return a;
                }
                va = va.negate();
                return new XBigInteger(va);
            }
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            if (vx >= 0.0) {
                return x;
            }
            return new XDouble(-vx);
        }

        /* synthetic */ 15(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 16
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            if (ParserUtilities.isXIntegral(args[0])) {
                XBigInteger a = ParserUtilities.toXBigInteger((XNumber)args[0]);
                return a;
            }
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            vx = Math.ceil(vx);
            return new XDouble(vx);
        }

        /* synthetic */ 16(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 17
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            if (ParserUtilities.isXIntegral(args[0])) {
                XBigInteger a = ParserUtilities.toXBigInteger((XNumber)args[0]);
                return a;
            }
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            vx = Math.floor(vx);
            return new XDouble(vx);
        }

        /* synthetic */ 17(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 18
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            if (ParserUtilities.isXIntegral(args[0])) {
                XBigInteger a = ParserUtilities.toXBigInteger((XNumber)args[0]);
                return a;
            }
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            vx = Math.rint(vx);
            return new XDouble(vx);
        }

        /* synthetic */ 18(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 19
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            double vy;
            this.checkArgs(args);
            if (ParserUtilities.isXIntegral(args[0]) && ParserUtilities.isXIntegral(args[1])) {
                BigInteger vb;
                XBigInteger a = ParserUtilities.toXBigInteger((XNumber)args[0]);
                XBigInteger b = ParserUtilities.toXBigInteger((XNumber)args[1]);
                BigInteger va = a.getValue();
                int test = va.compareTo(vb = b.getValue());
                if (test >= 0) {
                    return a;
                }
                return b;
            }
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            XDouble y = ParserUtilities.toXDouble((XNumber)args[1]);
            double vx = x.getValue();
            if (vx >= (vy = y.getValue())) {
                return x;
            }
            return y;
        }

        /* synthetic */ 19(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 20
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            double vy;
            this.checkArgs(args);
            if (ParserUtilities.isXIntegral(args[0]) && ParserUtilities.isXIntegral(args[1])) {
                BigInteger vb;
                XBigInteger a = ParserUtilities.toXBigInteger((XNumber)args[0]);
                XBigInteger b = ParserUtilities.toXBigInteger((XNumber)args[1]);
                BigInteger va = a.getValue();
                int test = va.compareTo(vb = b.getValue());
                if (test >= 0) {
                    return b;
                }
                return a;
            }
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            XDouble y = ParserUtilities.toXDouble((XNumber)args[1]);
            double vx = x.getValue();
            if (vx >= (vy = y.getValue())) {
                return y;
            }
            return x;
        }

        /* synthetic */ 20(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 21
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            if (vx == 0.0) {
                return x;
            }
            if (vx > 0.0) {
                return new XDouble(Math.sqrt(vx));
            }
            throw new ParseException("Negative argument " + vx + " to sqrt procedure", 0);
        }

        /* synthetic */ 21(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 22
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            XDouble y = ParserUtilities.toXDouble((XNumber)args[1]);
            double vx = x.getValue();
            double vy = y.getValue();
            if (vx == 0.0 && vy > 0.0) {
                return x;
            }
            if (vx > 0.0) {
                return new XDouble(Math.pow(vx, vy));
            }
            throw new ParseException("Invalid arguments " + vx + "," + vy + " to power procedure", 0);
        }

        /* synthetic */ 22(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 23
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            return new XDouble(Math.toDegrees(vx));
        }

        /* synthetic */ 23(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 24
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            return new XDouble(Math.toRadians(vx));
        }

        /* synthetic */ 24(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 25
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            return new XDouble(Math.sin(vx));
        }

        /* synthetic */ 25(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 26
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            return new XDouble(Math.sin(Math.toRadians(vx)));
        }

        /* synthetic */ 26(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 27
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            return new XDouble(Math.cos(vx));
        }

        /* synthetic */ 27(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 28
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            return new XDouble(Math.cos(Math.toRadians(vx)));
        }

        /* synthetic */ 28(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 29
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            return new XDouble(Math.tan(vx));
        }

        /* synthetic */ 29(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 30
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            return new XDouble(Math.tan(Math.toRadians(vx)));
        }

        /* synthetic */ 30(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 31
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            if (vx < -1.0 || vx > 1.0) {
                throw new ParseException("Invalid argument " + vx + " to asin procedure", 0);
            }
            return new XDouble(Math.asin(vx));
        }

        /* synthetic */ 31(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 32
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            if (vx < -1.0 || vx > 1.0) {
                throw new ParseException("Invalid argument " + vx + " to asindeg procedure", 0);
            }
            return new XDouble(Math.toDegrees(Math.asin(vx)));
        }

        /* synthetic */ 32(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 33
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            if (vx < -1.0 || vx > 1.0) {
                throw new ParseException("Invalid argument " + vx + " to acos procedure", 0);
            }
            return new XDouble(Math.acos(vx));
        }

        /* synthetic */ 33(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 34
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            if (vx < -1.0 || vx > 1.0) {
                throw new ParseException("Invalid argument " + vx + " to acosdeg procedure", 0);
            }
            return new XDouble(Math.toDegrees(Math.acos(vx)));
        }

        /* synthetic */ 34(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 35
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            return new XDouble(Math.atan(vx));
        }

        /* synthetic */ 35(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 36
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            return new XDouble(Math.toDegrees(Math.atan(vx)));
        }

        /* synthetic */ 36(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 37
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble y = ParserUtilities.toXDouble((XNumber)args[0]);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[1]);
            double vy = y.getValue();
            double vx = x.getValue();
            if (vx == 0.0 && vy == 0.0) {
                throw new ParseException("Invalid arguments " + vx + "," + vy + " to atan2 procedure", 0);
            }
            return new XDouble(Math.atan2(vy, vx));
        }

        /* synthetic */ 37(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 38
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble y = ParserUtilities.toXDouble((XNumber)args[0]);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[1]);
            double vy = y.getValue();
            double vx = x.getValue();
            if (vx == 0.0 && vy == 0.0) {
                throw new ParseException("Invalid arguments " + vx + "," + vy + " to atan2deg procedure", 0);
            }
            return new XDouble(Math.toDegrees(Math.atan2(vy, vx)));
        }

        /* synthetic */ 38(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 39
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            return new XDouble(Math.exp(vx));
        }

        /* synthetic */ 39(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 40
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            if (vx > 0.0) {
                return new XDouble(Math.log(vx));
            }
            throw new ParseException("Invalid argument " + vx + " to ln procedure", 0);
        }

        /* synthetic */ 40(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 41
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            double vx = x.getValue();
            if (vx > 0.0) {
                return new XDouble(Math.log(vx));
            }
            throw new ParseException("Invalid argument " + vx + " to log procedure", 0);
        }

        /* synthetic */ 41(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 42
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            XDouble b = ParserUtilities.toXDouble((XNumber)args[1]);
            double vx = x.getValue();
            double vb = b.getValue();
            if (vx > 0.0 && vb > 0.0) {
                return new XDouble(Math.log(vx) / Math.log(vb));
            }
            throw new ParseException("Invalid arguments " + vx + "," + vb + " to logtobase procedure", 0);
        }

        /* synthetic */ 42(String $0, int $1) {
            super($0, $1);
        }
    }

    private final class 43
    extends AbstractParser.Procedure {
        public Object procedureCall(Object[] args) throws ParseException {
            this.checkArgs(args);
            XDouble x = ParserUtilities.toXDouble((XNumber)args[0]);
            XDouble y = ParserUtilities.toXDouble((XNumber)args[1]);
            double vx = x.getValue();
            double vy = y.getValue();
            double r = Math.random();
            return new XDouble((1.0 - r) * vx + r * vy);
        }

        /* synthetic */ 43(String $0, int $1) {
            super($0, $1);
        }
    }

    public static class NumericOperation
    extends AbstractParser.Operation {
        public NumericOperation() {
        }

        public NumericOperation(String s) {
            super(s);
        }

        public NumericOperation(String s, boolean unary, boolean binary) {
            super(s, unary, binary);
        }

        public final Object performOperation(Object left, Object right) throws ParseException {
            if (left == null) {
                this.checkUnary();
                if (ParserUtilities.isXIntegral(right)) {
                    XBigInteger a = ParserUtilities.toXBigInteger((XNumber)right);
                    return this.unaryForXIntegral(a);
                }
                if (ParserUtilities.isXNumber(right)) {
                    XDouble x = ParserUtilities.toXDouble((XNumber)right);
                    return this.unaryForXFloating(x);
                }
                throw new ParseException("Numeric operation " + this.symbol + " expects 1 numeric argument.", 0);
            }
            this.checkBinary();
            if (ParserUtilities.isXIntegral(left) && ParserUtilities.isXIntegral(right)) {
                XBigInteger a = ParserUtilities.toXBigInteger((XNumber)left);
                XBigInteger b = ParserUtilities.toXBigInteger((XNumber)right);
                return this.binaryForXIntegral(a, b);
            }
            if (ParserUtilities.isXNumber(left) && ParserUtilities.isXNumber(right)) {
                XDouble x = ParserUtilities.toXDouble((XNumber)left);
                XDouble y = ParserUtilities.toXDouble((XNumber)right);
                return this.binaryForXFloating(x, y);
            }
            throw new ParseException("Numeric operation " + this.symbol + " expects 2 numeric arguments.", 0);
        }

        public Object unaryForXIntegral(XBigInteger a) {
            return null;
        }

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            return null;
        }

        public Object unaryForXFloating(XDouble x) {
            return null;
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            return null;
        }
    }

    public static class BooleanOperation
    extends AbstractParser.Operation {
        public boolean booleanOrNumeric = true;

        public BooleanOperation() {
        }

        public BooleanOperation(String s) {
            super(s);
        }

        public BooleanOperation(String s, boolean unary, boolean binary) {
            super(s, unary, binary);
        }

        public BooleanOperation(String s, boolean unary, boolean binary, boolean b_or_n) {
            super(s, unary, binary);
            this.booleanOrNumeric = b_or_n;
        }

        public final Object performOperation(Object left, Object right) throws ParseException {
            if (left == null) {
                this.checkUnary();
                if (ParserUtilities.isXBoolean(right)) {
                    XBoolean p = (XBoolean)right;
                    return this.unaryForXBoolean(p);
                }
                if (!this.booleanOrNumeric) {
                    throw new ParseException("Boolean operation " + this.symbol + " expects 1 boolean argument.", 0);
                }
                if (ParserUtilities.isXIntegral(right)) {
                    XBigInteger a = ParserUtilities.toXBigInteger((XNumber)right);
                    return this.unaryForXIntegral(a);
                }
                if (ParserUtilities.isXNumber(right)) {
                    XDouble x = ParserUtilities.toXDouble((XNumber)right);
                    return this.unaryForXFloating(x);
                }
                throw new ParseException("Boolean operation " + this.symbol + " expects 1 boolean or 1 numeric argument.", 0);
            }
            this.checkBinary();
            if (ParserUtilities.isXBoolean(left) && ParserUtilities.isXBoolean(right)) {
                XBoolean p = (XBoolean)left;
                XBoolean q = (XBoolean)right;
                return this.binaryForXBoolean(p, q);
            }
            if (!this.booleanOrNumeric) {
                throw new ParseException("Boolean operation " + this.symbol + " expects 2 boolean arguments.", 0);
            }
            if (ParserUtilities.isXIntegral(left) && ParserUtilities.isXIntegral(right)) {
                XBigInteger a = ParserUtilities.toXBigInteger((XNumber)left);
                XBigInteger b = ParserUtilities.toXBigInteger((XNumber)right);
                return this.binaryForXIntegral(a, b);
            }
            if (ParserUtilities.isXNumber(left) && ParserUtilities.isXNumber(right)) {
                XDouble x = ParserUtilities.toXDouble((XNumber)left);
                XDouble y = ParserUtilities.toXDouble((XNumber)right);
                return this.binaryForXFloating(x, y);
            }
            throw new ParseException("Boolean operation " + this.symbol + " expects 2 boolean or 2 numeric arguments.", 0);
        }

        public Object unaryForXBoolean(XBoolean p) {
            return null;
        }

        public Object binaryForXBoolean(XBoolean p, XBoolean q) {
            return null;
        }

        public Object unaryForXIntegral(XBigInteger a) {
            return null;
        }

        public Object binaryForXIntegral(XBigInteger a, XBigInteger b) {
            return null;
        }

        public Object unaryForXFloating(XDouble x) {
            return null;
        }

        public Object binaryForXFloating(XDouble x, XDouble y) {
            return null;
        }
    }
}

