/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.parser;

import edu.neu.ccs.XBigInteger;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XNumber;
import edu.neu.ccs.parser.Parser;
import edu.neu.ccs.util.JPTError;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractParser
implements Parser {
    protected static final Operation OPERATION_PREFIX = new Operation();
    protected static final int INTEGRAL = 100;
    protected static final int FLOATING = 101;
    protected String NESTED_EXPRESSION_START = "(";
    protected String NESTED_EXPRESSION_END = ")";
    protected String ARGUMENT_LIST_START = "(";
    protected String ARGUMENT_LIST_END = ")";
    protected String RADIX_POINT = ".";
    protected String ARGUMENT_SEPARATOR = ",";
    protected char UNDERSCORE = (char)95;
    protected Hashtable environment = new Hashtable();
    protected Hashtable constants = new Hashtable();
    protected Hashtable procedures = new Hashtable();
    protected Hashtable operations = new Hashtable();
    protected Hashtable prefixes = new Hashtable();
    protected Vector precedence = new Vector();
    protected final Operation identity = new 1("");
    protected String data;
    protected int next;

    public AbstractParser() {
        this.precedence.add(new Hashtable());
        this.addOperation(this.identity, 0);
        this.data = null;
        this.next = 0;
        this.addOperations();
        this.addProcedures();
        this.addConstants();
    }

    public abstract Object parse(String var1) throws ParseException;

    public void addConstant(String id, Object value) {
        if (this.constants.containsKey(id)) {
            throw new JPTError("Constant name " + id + " already in use");
        }
        this.assign(id, value);
        this.constants.put(id, value);
    }

    public void addProcedure(Procedure proc) {
        if (this.procedures.containsKey(proc.name)) {
            throw new JPTError("Procedure name " + proc.name + "already in use");
        }
        this.procedures.put(proc.name, proc);
    }

    public Operation addOperationAtPrecedenceOf(Operation compare, Operation op) {
        int pos = this.precedenceOf(compare);
        if (pos == -1) {
            throw new JPTError("Operation at comparable precedence not recognized.");
        }
        this.addOperation(op, pos);
        return op;
    }

    public Operation addOperationBeforePrecedenceOf(Operation compare, Operation op) {
        int pos = this.precedenceOf(compare);
        if (pos == -1) {
            throw new JPTError("Operation at comparable precedence not recognized.");
        }
        if (pos == 0) {
            throw new JPTError("Operation cannot be added at a precedence before the identity operation.");
        }
        this.precedence.insertElementAt(new Hashtable(), pos - 1);
        this.addOperation(op, pos);
        return op;
    }

    public Operation addOperationAfterPrecedenceOf(Operation compare, Operation op) {
        int pos = this.precedenceOf(compare);
        if (pos == -1) {
            throw new JPTError("Operation at comparable precedence not recognized.");
        }
        this.precedence.insertElementAt(new Hashtable(), ++pos);
        this.addOperation(op, pos);
        return op;
    }

    protected abstract ObjectOperationPair parseExpression(ObjectOperationPair var1) throws ParseException;

    protected void addOperations() {
    }

    protected void addProcedures() {
    }

    protected void addConstants() {
    }

    protected void setLeftParenthesisToken(String token) {
        if (token != null && token.length() > 0) {
            this.ARGUMENT_LIST_START = token;
        }
    }

    protected void setRightParenthesisToken(String token) {
        if (token != null && token.length() > 0) {
            this.ARGUMENT_LIST_END = token;
        }
    }

    protected void setRadixPointToken(String token) {
        if (token != null && token.length() > 0) {
            this.RADIX_POINT = token;
        }
    }

    protected void setArgumentSeparatorToken(String token) {
        if (token != null && token.length() > 0) {
            this.ARGUMENT_SEPARATOR = token;
        }
    }

    protected void assign(String id, Object value) {
        if (this.environment.containsKey(id)) {
            this.environment.remove(id);
        }
        this.environment.put(id, value);
    }

    protected void addOperation(Operation op, int pos) {
        if (this.operations.containsKey(op.symbol)) {
            throw new JPTError("Operation symbol " + op.symbol + " already in use");
        }
        this.operations.put(op.symbol, op);
        ((Hashtable)this.precedence.get(pos)).put(op.symbol, op);
        int n = op.symbol.length() - 1;
        int i = 1;
        while (i <= n) {
            String prefix = op.symbol.substring(0, n);
            if (!this.prefixes.containsKey(prefix)) {
                this.prefixes.put(prefix, prefix);
            }
            ++i;
        }
    }

    protected Operation isOperationOrPrefix(String symbol) {
        if (this.operations.containsKey(symbol)) {
            return (Operation)this.operations.get(symbol);
        }
        if (this.prefixes.containsKey(symbol)) {
            return OPERATION_PREFIX;
        }
        return null;
    }

    protected Operation nextOperation() {
        this.skipWhitespace();
        int end = this.next;
        Operation temp = null;
        Operation last = null;
        while (end < this.data.length()) {
            if ((temp = this.isOperationOrPrefix(this.data.substring(this.next, ++end))) == null) break;
            if (temp == OPERATION_PREFIX) continue;
            last = temp;
        }
        if (last != null) {
            this.next += last.symbol.length();
        }
        return last;
    }

    protected int precedenceOf(Operation op) {
        if (op == null) {
            return -1;
        }
        int i = 0;
        while (i < this.precedence.size()) {
            if (((Hashtable)this.precedence.get(i)).containsKey(op.symbol)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected boolean nextTokenIs(String pattern) {
        this.skipWhitespace();
        return this.nextTokenIs(pattern, this.next);
    }

    protected boolean nextTokenIs(String pattern, int start) {
        if (pattern == null || pattern.length() == 0 || start + pattern.length() > this.data.length()) {
            return false;
        }
        int i = 0;
        while (i < pattern.length()) {
            if (pattern.charAt(i) != this.data.charAt(start + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean startsNumber() {
        this.skipWhitespace();
        if (this.next >= this.data.length()) {
            return false;
        }
        return Character.isDigit(this.data.charAt(this.next)) || this.nextTokenIs(this.RADIX_POINT);
    }

    protected boolean startsIdentifier() {
        this.skipWhitespace();
        if (this.next >= this.data.length()) {
            return false;
        }
        char c = this.data.charAt(this.next);
        return Character.isLetter(c) || c == this.UNDERSCORE;
    }

    protected boolean withinIdentifier() {
        if (this.next >= this.data.length()) {
            return false;
        }
        char c = this.data.charAt(this.next);
        return Character.isLetter(c) || Character.isDigit(c) || c == this.UNDERSCORE;
    }

    protected String parseIdentifier() {
        if (!this.startsIdentifier()) {
            return "";
        }
        int start = this.next++;
        while (this.withinIdentifier()) {
            ++this.next;
        }
        return this.data.substring(start, this.next);
    }

    protected Object[] parseArgumentList() throws ParseException {
        Vector<Object> values = new Vector<Object>();
        this.skipWhitespace();
        if (!this.nextTokenIs(this.ARGUMENT_LIST_START)) {
            throw new ParseException("Expected start of argument list", this.next);
        }
        this.next += this.ARGUMENT_LIST_START.length();
        this.skipWhitespace();
        boolean expecting = this.nextTokenIs(this.ARGUMENT_LIST_END) ^ true;
        while (expecting) {
            ObjectOperationPair base = new ObjectOperationPair(null, this.identity);
            values.add(this.parseExpression((ObjectOperationPair)base).value);
            this.skipWhitespace();
            if (this.nextTokenIs(this.ARGUMENT_SEPARATOR)) {
                this.next += this.ARGUMENT_SEPARATOR.length();
            } else {
                expecting = false;
            }
            this.skipWhitespace();
        }
        if (!this.nextTokenIs(this.ARGUMENT_LIST_END)) {
            throw new ParseException("Expected end of argument list", this.next);
        }
        this.next += this.ARGUMENT_LIST_END.length();
        this.skipWhitespace();
        return values.toArray();
    }

    protected Object parseNumber() throws ParseException {
        this.skipWhitespace();
        int end = this.next;
        int type = 100;
        if (this.isSignAt(this.next)) {
            if (this.data.charAt(this.next) == '+') {
                ++this.next;
            }
            ++end;
        }
        if (this.nextTokenIs(this.RADIX_POINT, end = this.afterDigits(end))) {
            type = 101;
            end += this.RADIX_POINT.length();
            end = this.afterDigits(end);
        }
        if (this.isExponentAt(end)) {
            type = 101;
            ++end;
            end = this.afterSign(end);
            end = this.afterDigits(end);
        }
        String number = this.data.substring(this.next, end);
        this.next = end;
        if (type == 100) {
            try {
                BigInteger i = new BigInteger(number);
                return new XBigInteger(i);
            }
            catch (NumberFormatException ex) {
                return new ParseException("Expected valid numeric value: " + number + " " + ex.getMessage(), this.next);
            }
        }
        try {
            Double d = new Double(number);
            return new XDouble(d);
        }
        catch (NumberFormatException ex) {
            return new ParseException("Expected valid numeric value: " + number + " " + ex.getMessage(), this.next);
        }
    }

    protected int afterSign(int start) {
        return this.isSignAt(start) ? start + 1 : start;
    }

    protected boolean isSignAt(int start) {
        if (start >= this.data.length()) {
            return false;
        }
        char c = this.data.charAt(start);
        return c == '+' || c == '-';
    }

    protected boolean isExponentAt(int start) {
        if (start >= this.data.length()) {
            return false;
        }
        char c = this.data.charAt(start);
        return c == 'E' || c == 'e';
    }

    protected int afterDigits(int start) {
        while (start < this.data.length()) {
            char c = this.data.charAt(start);
            if (!Character.isDigit(c)) break;
            ++start;
        }
        return start;
    }

    protected void skipWhitespace() {
        while (this.next < this.data.length() && Character.isWhitespace(this.data.charAt(this.next))) {
            ++this.next;
        }
    }

    private final class 1
    extends Operation {
        public Object performOperation(Object left, Object right) throws ParseException {
            return right;
        }

        /* synthetic */ 1(String $0) {
            super($0);
        }
    }

    public static class ObjectOperationPair {
        public Object value = null;
        public Operation operation = null;

        public ObjectOperationPair(Object v, Operation o) {
            this.value = v;
            this.operation = o;
        }
    }

    public static class Operation {
        public String symbol = "\u0000";
        public boolean isUnary = true;
        public boolean isBinary = true;

        public Operation() {
        }

        public Operation(String s) {
            if (this.symbol != null) {
                this.symbol = s;
            }
        }

        public Operation(String s, boolean unary, boolean binary) {
            if (this.symbol != null) {
                this.symbol = s;
            }
            this.isUnary = unary;
            this.isBinary = binary;
        }

        public Object performOperation(Object left, Object right) throws ParseException {
            return null;
        }

        public boolean isUnary() {
            return this.isUnary;
        }

        public boolean isBinary() {
            return this.isBinary;
        }

        protected void checkUnary() throws ParseException {
            if (!this.isUnary) {
                throw new ParseException("Operation " + this.symbol + " expects 2 arguments.", 0);
            }
        }

        protected void checkBinary() throws ParseException {
            if (!this.isBinary) {
                throw new ParseException("Operation " + this.symbol + " expects 1 argument.", 0);
            }
        }
    }

    public static abstract class Procedure {
        public String name = "UnnamedProcedure";
        public int arguments = 1;

        public Procedure(String name, int arguments) {
            if (name != null && name.length() > 0) {
                this.name = name;
            }
            this.arguments = arguments;
        }

        public abstract Object procedureCall(Object[] var1) throws ParseException;

        protected void checkArgs(Object[] args) throws ParseException {
            if (args == null) {
                throw new ParseException("Null arguments to procedure " + this.name + ".", 0);
            }
            if (args.length != this.arguments) {
                throw new ParseException("Procedure " + this.name + " expects " + this.arguments + " arguments.", 0);
            }
        }

        protected void checkArgsAsNumeric(Object[] args) throws ParseException {
            this.checkArgs(args);
            int i = 0;
            while (i < this.arguments) {
                if (!(args[i] instanceof XNumber)) {
                    throw new ParseException("Procedure " + this.name + " expects numeric argument in position " + i + ".", 0);
                }
                ++i;
            }
        }
    }
}

