/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.jpf;

import edu.neu.ccs.console.ConsoleAware;
import edu.neu.ccs.gui.ActionsPanel;
import edu.neu.ccs.gui.BufferedPanel;
import edu.neu.ccs.gui.CenterLayout;
import edu.neu.ccs.gui.Display;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.JPTFrame;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.TableLayout;
import edu.neu.ccs.gui.TablePanel;
import edu.neu.ccs.gui.ThreadedAction;
import edu.neu.ccs.jpf.JPF;
import edu.neu.ccs.jpf.MethodGUI;
import edu.neu.ccs.util.JPTConstants;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.JRootPane;

class JPFApplication
extends DisplayPanel
implements JPTConstants,
ConsoleAware {
    public static final int BUFFER_WIDTH = 400;
    public static final int BUFFER_HEIGHT = 400;
    protected BufferedPanel window = new BufferedPanel(400, 400);
    protected JPF initializer = null;
    protected Class initializerClass = null;
    protected JPTFrame frame = null;
    protected String frameTitle = null;
    protected boolean showGraphicsWindow = true;
    protected final int MAXIMUM_ROWS = 25;
    protected ActionsPanel buttons = new ActionsPanel(new TableLayout(25, 1, 0, 0, 0, 0));
    protected DisplayPanel LHS = null;
    protected DisplayPanel RHS = null;
    protected TablePanel mainPanel = null;
    protected Action clearGraphics = new 1("Clear Graphics");
    protected Action toggleGraphics = new 2("Toggle Graphics");
    protected Action exitFramework = new 3("Exit");
    static /* synthetic */ Class class$edu$neu$ccs$jpf$JPF;
    static /* synthetic */ Class class$edu$neu$ccs$Stringable;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$awt$geom$Point2D$Double;

    public JPFApplication(JPF initializer, String title) {
        if (initializer == null) {
            return;
        }
        this.initializer = initializer;
        this.initializerClass = initializer.getClass();
        this.setFrameTitle(title);
        this.buildButtons();
        this.buildGUI();
        this.frame = JPTFrame.createQuickJPTFrame(this.getFrameTitle(), this, new CenterLayout(), 2);
    }

    public BufferedPanel getGraphicsWindow() {
        return this.window;
    }

    public String getFrameTitle() {
        return this.frameTitle;
    }

    public void setFrameTitle(String title) {
        String string = this.frameTitle = title != null && !title.equals("") ? title : JPFApplication.className(this.initializerClass);
        if (this.frame != null) {
            this.frame.setTitle(this.frameTitle);
        }
    }

    protected void buildButtons() {
        Method[] methods = this.getMethodList();
        int length = methods.length;
        int i = 0;
        while (i < length) {
            if (methods[i] != null) {
                this.addOneButton(this.makeActionFromMethod(methods[i]), this.getMethodToolTip(methods[i]));
            }
            ++i;
        }
        this.addOneButton(this.clearGraphics, "Clear the Graphics Window");
        this.addOneButton(this.toggleGraphics, "Show or Hide the Graphics Window");
        this.addOneButton(this.exitFramework, "Exit the Framework");
        this.buttons.uniformizeSize();
    }

    protected void clearGraphics() {
        this.window.clearPanel();
        this.window.repaint();
    }

    protected void toggleGraphics() {
        if (this.showGraphicsWindow) {
            this.mainPanel.remove(this.RHS);
        } else {
            this.mainPanel.add(this.RHS);
        }
        this.showGraphicsWindow ^= true;
        this.frame.pack();
        this.frame.setLocation(2);
    }

    protected void exitFramework() {
        ConsoleAware.console.setActivated(false);
        System.exit(0);
    }

    protected void addOneButton(Action action, String tooltip) {
        this.buttons.addAction(action);
        this.buttons.findMatchedButton(action).setToolTipText(tooltip);
    }

    protected String getMethodToolTip(Method method) {
        if (method == null) {
            return "";
        }
        return String.valueOf(this.isStatic(method) ? "static " : "") + JPFApplication.className(method.getReturnType()) + " " + method.getName() + "(" + this.getParameterNames(method) + ")" + " in " + JPFApplication.className(method.getDeclaringClass());
    }

    protected String getParameterNames(Method method) {
        String result = "";
        if (method == null) {
            return result;
        }
        Class<?>[] types = method.getParameterTypes();
        int length = types.length;
        if (length == 0) {
            return result;
        }
        result = JPFApplication.className(types[0]);
        int i = 1;
        while (i < length) {
            result = String.valueOf(result) + ", " + JPFApplication.className(types[i]);
            ++i;
        }
        return result;
    }

    protected void buildGUI() {
        this.showConsole();
        this.LHS = new Display(this.buttons, null, "Tasks");
        this.RHS = new Display(this.window, null, "Graphics");
        this.mainPanel = new TablePanel(new Object[]{this.LHS, this.RHS}, 0, 5, 5, 1);
        this.add(this.mainPanel);
    }

    protected void showConsole() {
        ConsoleAware.console.setActivated(true);
        ConsoleAware.console.selectColorTextScheme();
    }

    protected Method[] getMethodList() {
        Method[] methods = this.getExtraMethods(this.initializerClass, class$edu$neu$ccs$jpf$JPF != null ? class$edu$neu$ccs$jpf$JPF : (class$edu$neu$ccs$jpf$JPF = JPFApplication.class$("edu.neu.ccs.jpf.JPF")));
        int length = methods.length;
        int i = 0;
        while (i < length) {
            if (!this.isSimpleMethod(methods[i]) && !this.isGUIMethod(methods[i])) {
                methods[i] = null;
            }
            ++i;
        }
        this.removeDuplicateVirtualMethods(methods);
        return methods;
    }

    protected void removeDuplicateVirtualMethods(Method[] methods) {
        if (methods == null) {
            return;
        }
        int length = methods.length;
        int i = length - 1;
        while (i > 0) {
            if (methods[i] != null && !this.isStatic(methods[i])) {
                int j = i - 1;
                while (j >= 0) {
                    if (methods[j] != null && !this.isStatic(methods[j]) && this.isDuplicate(methods[i], methods[j])) {
                        methods[j] = null;
                    }
                    --j;
                }
            }
            --i;
        }
    }

    protected boolean isDuplicate(Method method1, Method method2) {
        if (method1 == null || method2 == null) {
            return false;
        }
        return method1.getName().equals(method2.getName()) && method1.getModifiers() == method2.getModifiers() && method2.getReturnType() == method2.getReturnType() && this.isDuplicateParameterList(method1, method2);
    }

    protected boolean isDuplicateParameterList(Method method1, Method method2) {
        Class<?>[] types2;
        int length2;
        if (method1 == null || method2 == null) {
            return false;
        }
        Class<?>[] types1 = method1.getParameterTypes();
        int length1 = types1.length;
        if (length1 != (length2 = (types2 = method2.getParameterTypes()).length)) {
            return false;
        }
        int i = 0;
        while (i < length1) {
            if (types1[i] != types2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Action makeActionFromMethod(Method method) {
        if (method == null) {
            return null;
        }
        String name = this.isStatic(method) ? String.valueOf(JPFApplication.className(method.getDeclaringClass())) + "." + method.getName() : method.getName();
        return new ThreadedAction(new 4(method, this, name));
    }

    protected synchronized void performAction(Method method) {
        String name = method.getName();
        try {
            if (this.isGUIMethod(method)) {
                this.performActionUsingGUI(method);
            } else if (this.isStatic(method)) {
                method.invoke(null, null);
            } else {
                method.invoke((Object)this.initializer, null);
            }
        }
        catch (Exception exception) {
            this.handleMethodException(exception, name);
        }
    }

    protected void handleMethodException(Throwable exception, String name) {
        if (exception instanceof IllegalAccessException) {
            IllegalAccessException illAccEx = (IllegalAccessException)exception;
            ConsoleAware.console.err.print("JPF Error: IllegalAccessException: ");
            ConsoleAware.console.err.println(String.valueOf(String.valueOf(illAccEx)) + "\n");
        } else if (exception instanceof IllegalArgumentException) {
            IllegalArgumentException illArgEx = (IllegalArgumentException)exception;
            ConsoleAware.console.err.print("JPF Error: IllegalArgumentException: ");
            ConsoleAware.console.err.println(String.valueOf(String.valueOf(illArgEx)) + "\n");
        } else if (exception instanceof InvocationTargetException) {
            InvocationTargetException invTarEx = (InvocationTargetException)exception;
            exception = invTarEx.getTargetException();
        }
        this.printExceptionTrace(exception, name);
    }

    protected void printExceptionTrace(Throwable exception, String name) {
        ConsoleAware.console.err.println("Exception: " + exception + "\nIn: " + name + "\n");
        StringWriter sWriter = new StringWriter();
        PrintWriter pWriter = new PrintWriter((Writer)sWriter, true);
        exception.printStackTrace(pWriter);
        String message = sWriter.toString();
        int index = message.indexOf(".reflect.");
        if (index >= 0) {
            message = message.substring(0, index);
        }
        if ((index = message.lastIndexOf("\n")) >= 0) {
            message = message.substring(0, index);
        }
        if (message.length() > 0) {
            ConsoleAware.console.err.println(String.valueOf(message) + "\n");
        }
    }

    public synchronized void performActionUsingGUI(Method method) {
        String title = String.valueOf(method.getName()) + " evaluator";
        MethodGUI gui = new MethodGUI(this, method);
        JPTFrame frame = JPTFrame.createQuickJPTFrame(title, gui, new CenterLayout(), 0);
        JRootPane pane = gui.getRootPane();
        if (pane != null) {
            pane.setDefaultButton(gui.evaluateButton);
        }
    }

    protected boolean isSimpleMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (method.getName().equals("main")) {
            return false;
        }
        if (method.getReturnType() != Void.TYPE) {
            return false;
        }
        if (method.getParameterTypes().length > 0) {
            return false;
        }
        int modifiers = method.getModifiers();
        return (modifiers & 1) != 0;
    }

    protected boolean isGUIMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (method.getName().equals("main")) {
            return false;
        }
        if (!this.isAcceptableMethodForGUI(method)) {
            return false;
        }
        int modifiers = method.getModifiers();
        return (modifiers & 1) != 0;
    }

    protected boolean isAcceptableTypeForGUI(Class c) {
        if (c == null) {
            return false;
        }
        if (c.isPrimitive()) {
            return true;
        }
        if ((class$edu$neu$ccs$Stringable != null ? class$edu$neu$ccs$Stringable : (class$edu$neu$ccs$Stringable = JPFApplication.class$("edu.neu.ccs.Stringable"))).isAssignableFrom(c)) {
            return true;
        }
        if (c.equals(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = JPFApplication.class$("java.lang.String")))) {
            return true;
        }
        if (c.equals(class$java$awt$Color != null ? class$java$awt$Color : (class$java$awt$Color = JPFApplication.class$("java.awt.Color")))) {
            return true;
        }
        if (c.equals(class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = JPFApplication.class$("java.math.BigInteger")))) {
            return true;
        }
        if (c.equals(class$java$math$BigDecimal != null ? class$java$math$BigDecimal : (class$java$math$BigDecimal = JPFApplication.class$("java.math.BigDecimal")))) {
            return true;
        }
        return c.equals(class$java$awt$geom$Point2D$Double != null ? class$java$awt$geom$Point2D$Double : (class$java$awt$geom$Point2D$Double = JPFApplication.class$("java.awt.geom.Point2D$Double")));
    }

    protected boolean isAcceptableMethodForGUI(Method method) {
        if (method == null) {
            return false;
        }
        Class<?> returnType = method.getReturnType();
        Class<?>[] parameterTypes = method.getParameterTypes();
        int length = parameterTypes.length;
        if (returnType.equals(Void.TYPE) && length == 0) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!this.isAcceptableTypeForGUI(parameterTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Method[] getExtraMethods(Class c, Class d) {
        if (c == null || c.equals(d) || c.isPrimitive() || c.isInterface() || c.isArray()) {
            return new Method[0];
        }
        return this.joinMethodArrays(this.getExtraMethods(c.getSuperclass(), d), c.getDeclaredMethods());
    }

    protected Method[] joinMethodArrays(Method[] listA, Method[] listB) {
        int lengthA = listA.length;
        int lengthB = listB.length;
        int length = lengthA + lengthB;
        Method[] list = new Method[length];
        int i = 0;
        while (i < lengthA) {
            list[i] = listA[i];
            ++i;
        }
        int i2 = lengthA;
        while (i2 < length) {
            list[i2] = listB[i2 - lengthA];
            ++i2;
        }
        return list;
    }

    protected boolean isStatic(Method method) {
        if (method == null) {
            return false;
        }
        int modifiers = method.getModifiers();
        return (modifiers & 8) != 0;
    }

    protected static String className(Class c) {
        String s = c.getName();
        int pos = s.lastIndexOf(".");
        if (pos < 0) {
            return s;
        }
        return s.substring(pos + 1);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private final class 1
    extends SimpleAction {
        public void perform() {
            JPFApplication.this.clearGraphics();
        }

        /* synthetic */ 1(String $0) {
            super($0);
        }
    }

    private final class 2
    extends SimpleAction {
        public void perform() {
            JPFApplication.this.toggleGraphics();
        }

        /* synthetic */ 2(String $0) {
            super($0);
        }
    }

    private final class 3
    extends SimpleAction {
        public void perform() {
            JPFApplication.this.exitFramework();
        }

        /* synthetic */ 3(String $0) {
            super($0);
        }
    }

    private static final class 4
    extends SimpleAction {
        private final /* synthetic */ JPFApplication this$0;
        private final /* synthetic */ Method val$method;

        public void perform() {
            this.this$0.performAction(this.val$method);
        }

        /* synthetic */ 4(Method val$method, JPFApplication this$0, String $0) {
            super($0);
            this.val$method = val$method;
            this.this$0 = this$0;
        }
    }
}

