/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XBigDecimal;
import edu.neu.ccs.XBigInteger;
import edu.neu.ccs.XBoolean;
import edu.neu.ccs.XByte;
import edu.neu.ccs.XChar;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XFloat;
import edu.neu.ccs.XInt;
import edu.neu.ccs.XLong;
import edu.neu.ccs.XShort;
import edu.neu.ccs.XString;
import edu.neu.ccs.filter.FilterException;
import edu.neu.ccs.filter.StringableFilter;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.gui.ErrorDialog;
import edu.neu.ccs.gui.FocusActionAdapter;
import edu.neu.ccs.gui.Fragile;
import edu.neu.ccs.gui.GeneralView;
import edu.neu.ccs.gui.InputProperties;
import edu.neu.ccs.gui.MalformedDataEvent;
import edu.neu.ccs.gui.MalformedDataListener;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.util.JPTConstants;
import edu.neu.ccs.util.StringableFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class TextFieldView
extends JTextField
implements GeneralView,
Fragile,
JPTConstants {
    public static final String AUTO_SELECT = "auto.select";
    public static final String FILTER = "filter";
    public static final int DEFAULT_WIDTH = 50;
    public static final boolean DEFAULT_AUTOSELECT_POLICY = true;
    protected boolean autoSelect = true;
    protected String defaultValue = "";
    protected StringableFactory factory = new StringableFactory(class$edu$neu$ccs$XString != null ? class$edu$neu$ccs$XString : (class$edu$neu$ccs$XString = TextFieldView.class$("edu.neu.ccs.XString")));
    protected InputProperties properties = new InputProperties();
    protected StringableFilter filter = null;
    static /* synthetic */ Class class$edu$neu$ccs$XString;
    static /* synthetic */ Class class$edu$neu$ccs$gui$MalformedDataListener;
    static /* synthetic */ Class class$edu$neu$ccs$XByte;
    static /* synthetic */ Class class$edu$neu$ccs$XShort;
    static /* synthetic */ Class class$edu$neu$ccs$XInt;
    static /* synthetic */ Class class$edu$neu$ccs$XLong;
    static /* synthetic */ Class class$edu$neu$ccs$XFloat;
    static /* synthetic */ Class class$edu$neu$ccs$XDouble;
    static /* synthetic */ Class class$edu$neu$ccs$XChar;
    static /* synthetic */ Class class$edu$neu$ccs$XBoolean;
    static /* synthetic */ Class class$edu$neu$ccs$XBigInteger;
    static /* synthetic */ Class class$edu$neu$ccs$XBigDecimal;

    public TextFieldView() {
        this("", null, null, null, 50);
    }

    public TextFieldView(int width) {
        this("", null, null, null, width);
    }

    public TextFieldView(String text) {
        this(text, null, null, null, 50);
    }

    public TextFieldView(String text, int width) {
        this(text, null, null, null, width);
    }

    public TextFieldView(String text, String errorPrompt, String dialogTitle) {
        this(text, errorPrompt, dialogTitle, null, 50);
    }

    public TextFieldView(String text, String errorPrompt, String dialogTitle, int width) {
        this(text, errorPrompt, dialogTitle, null, width);
    }

    public TextFieldView(String text, String errorPrompt, String dialogTitle, String suggestion) {
        this(text, errorPrompt, dialogTitle, suggestion, 50);
    }

    public TextFieldView(String text, String errorPrompt, String dialogTitle, String suggestion, int width) {
        super(text);
        this.initialize(errorPrompt, dialogTitle, suggestion, width);
    }

    public TextFieldView(Document document) {
        this(document, null, null, null, 50);
    }

    public TextFieldView(Document document, int width) {
        this(document, null, null, null, width);
    }

    public TextFieldView(Document document, String errorPrompt, String dialogTitle) {
        this(document, errorPrompt, dialogTitle, null, 50);
    }

    public TextFieldView(Document document, String errorPrompt, String dialogTitle, int width) {
        this(document, errorPrompt, dialogTitle, null, width);
    }

    public TextFieldView(Document document, String errorPrompt, String dialogTitle, String suggestion) {
        this(document, errorPrompt, dialogTitle, suggestion, 50);
    }

    public TextFieldView(Document document, String errorPrompt, String dialogTitle, String suggestion, int width) {
        super(document, null, 0);
        this.initialize(errorPrompt, dialogTitle, suggestion, width);
    }

    private void initialize(String errorPrompt, String dialogTitle, String suggestion, int width) {
        this.installFocusActions();
        this.setDefaultViewState(this.getText());
        this.properties.setInputPrompt(errorPrompt);
        this.properties.setDialogTitle(dialogTitle);
        this.properties.setSuggestion(suggestion);
        width = width > 0 ? width : 50;
        this.setPreferredWidth(width);
    }

    public void setDataType(Class dataType) {
        Class oldType = this.getDataType();
        this.factory.setDataType(dataType);
        this.firePropertyChange("data.type", oldType, this.getDataType());
    }

    public Stringable demandObject() {
        Stringable obj;
        block6: {
            obj = this.factory.getDefaultInstance();
            try {
                try {
                    obj.fromStringData(this.getViewState());
                    if (this.filter == null) break block6;
                    try {
                        obj = this.filter.filterStringable(obj);
                    }
                    catch (FilterException ex) {
                        throw new ParseException(ex.getMessage(), -1);
                    }
                }
                catch (NumberFormatException ex) {
                    throw new ParseException(ex.getMessage(), -1);
                }
            }
            catch (ParseException ex) {
                this.handleError(obj, 0, ex);
                this.repaint();
            }
        }
        return obj;
    }

    public Stringable requestObject() throws CancelledException {
        Stringable obj;
        block7: {
            obj = this.factory.getDefaultInstance();
            try {
                try {
                    obj.fromStringData(this.getViewState());
                    if (this.filter == null) break block7;
                    try {
                        obj = this.filter.filterStringable(obj);
                    }
                    catch (FilterException ex) {
                        throw new ParseException(ex.getMessage(), -1);
                    }
                }
                catch (NumberFormatException ex) {
                    throw new ParseException(ex.getMessage(), -1);
                }
            }
            catch (ParseException ex) {
                if (!this.handleError(obj, 1, ex)) {
                    throw new CancelledException();
                }
                this.repaint();
            }
        }
        return obj;
    }

    public void setInputProperties(InputProperties p) {
        if (p == null) {
            p = InputProperties.BASE_PROPERTIES;
        }
        InputProperties oldProperties = this.getInputProperties();
        this.properties = p;
        if (this.getInputProperties() != null && !this.getInputProperties().equals(oldProperties)) {
            this.firePropertyChange("input.properties", oldProperties, this.getInputProperties());
        }
    }

    public InputProperties getInputProperties() {
        return this.properties;
    }

    public Class getDataType() {
        return this.factory.getDataType();
    }

    public void setViewState(String data) {
        this.setText(data);
        this.firePropertyChange("view.state", null, data);
    }

    public String getViewState() {
        return this.getText();
    }

    public void setDefaultViewState(String data) {
        this.defaultValue = data = data == null ? "" : data;
        this.firePropertyChange("default.view.state", null, data);
    }

    public String getDefaultViewState() {
        return this.defaultValue;
    }

    public void reset() {
        this.setText(this.getDefaultViewState());
    }

    public void addMalformedDataListener(MalformedDataListener l) {
        this.listenerList.add(class$edu$neu$ccs$gui$MalformedDataListener != null ? class$edu$neu$ccs$gui$MalformedDataListener : (class$edu$neu$ccs$gui$MalformedDataListener = TextFieldView.class$("edu.neu.ccs.gui.MalformedDataListener")), l);
    }

    public void removeMalformedDataListener(MalformedDataListener l) {
        this.listenerList.remove(class$edu$neu$ccs$gui$MalformedDataListener != null ? class$edu$neu$ccs$gui$MalformedDataListener : (class$edu$neu$ccs$gui$MalformedDataListener = TextFieldView.class$("edu.neu.ccs.gui.MalformedDataListener")), l);
    }

    public byte demandByte() {
        return this.demandByte(null);
    }

    public byte demandByte(StringableFilter f) {
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XByte != null ? class$edu$neu$ccs$XByte : (class$edu$neu$ccs$XByte = TextFieldView.class$("edu.neu.ccs.XByte")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        XByte obj = (XByte)this.demandObject();
        this.factory.setDataType(oldClass);
        this.setFilter(oldFilter);
        return obj.getValue();
    }

    public byte requestByte() throws CancelledException {
        return this.requestByte(null);
    }

    public byte requestByte(StringableFilter f) throws CancelledException {
        XByte obj = null;
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XByte != null ? class$edu$neu$ccs$XByte : (class$edu$neu$ccs$XByte = TextFieldView.class$("edu.neu.ccs.XByte")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        try {
            obj = (XByte)this.requestObject();
        }
        finally {
            Object var6_5 = null;
            this.factory.setDataType(oldClass);
            this.setFilter(oldFilter);
        }
        return obj.getValue();
    }

    public short demandShort() {
        return this.demandShort(null);
    }

    public short demandShort(StringableFilter f) {
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XShort != null ? class$edu$neu$ccs$XShort : (class$edu$neu$ccs$XShort = TextFieldView.class$("edu.neu.ccs.XShort")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        XShort obj = (XShort)this.demandObject();
        this.factory.setDataType(oldClass);
        this.setFilter(oldFilter);
        return obj.getValue();
    }

    public short requestShort() throws CancelledException {
        return this.requestShort(null);
    }

    public short requestShort(StringableFilter f) throws CancelledException {
        XShort obj = null;
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XShort != null ? class$edu$neu$ccs$XShort : (class$edu$neu$ccs$XShort = TextFieldView.class$("edu.neu.ccs.XShort")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        try {
            obj = (XShort)this.requestObject();
        }
        finally {
            Object var6_5 = null;
            this.factory.setDataType(oldClass);
            this.setFilter(oldFilter);
        }
        return obj.getValue();
    }

    public int demandInt() {
        return this.demandInt(null);
    }

    public int demandInt(StringableFilter f) {
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XInt != null ? class$edu$neu$ccs$XInt : (class$edu$neu$ccs$XInt = TextFieldView.class$("edu.neu.ccs.XInt")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        XInt obj = (XInt)this.demandObject();
        this.factory.setDataType(oldClass);
        this.setFilter(oldFilter);
        return obj.getValue();
    }

    public int requestInt() throws CancelledException {
        return this.requestInt(null);
    }

    public int requestInt(StringableFilter f) throws CancelledException {
        XInt obj = null;
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XInt != null ? class$edu$neu$ccs$XInt : (class$edu$neu$ccs$XInt = TextFieldView.class$("edu.neu.ccs.XInt")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        try {
            obj = (XInt)this.requestObject();
        }
        finally {
            Object var6_5 = null;
            this.factory.setDataType(oldClass);
            this.setFilter(oldFilter);
        }
        return obj.getValue();
    }

    public long demandLong() {
        return this.demandLong(null);
    }

    public long demandLong(StringableFilter f) {
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XLong != null ? class$edu$neu$ccs$XLong : (class$edu$neu$ccs$XLong = TextFieldView.class$("edu.neu.ccs.XLong")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        XLong obj = (XLong)this.demandObject();
        this.factory.setDataType(oldClass);
        this.setFilter(oldFilter);
        return obj.getValue();
    }

    public long requestLong() throws CancelledException {
        return this.requestLong(null);
    }

    public long requestLong(StringableFilter f) throws CancelledException {
        XLong obj = null;
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XLong != null ? class$edu$neu$ccs$XLong : (class$edu$neu$ccs$XLong = TextFieldView.class$("edu.neu.ccs.XLong")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        try {
            obj = (XLong)this.requestObject();
        }
        finally {
            Object var6_5 = null;
            this.factory.setDataType(oldClass);
            this.setFilter(oldFilter);
        }
        return obj.getValue();
    }

    public float demandFloat() {
        return this.demandFloat(null);
    }

    public float demandFloat(StringableFilter f) {
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XFloat != null ? class$edu$neu$ccs$XFloat : (class$edu$neu$ccs$XFloat = TextFieldView.class$("edu.neu.ccs.XFloat")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        XFloat obj = (XFloat)this.demandObject();
        this.factory.setDataType(oldClass);
        this.setFilter(oldFilter);
        return obj.getValue();
    }

    public float requestFloat() throws CancelledException {
        return this.requestFloat(null);
    }

    public float requestFloat(StringableFilter f) throws CancelledException {
        XFloat obj = null;
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XFloat != null ? class$edu$neu$ccs$XFloat : (class$edu$neu$ccs$XFloat = TextFieldView.class$("edu.neu.ccs.XFloat")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        try {
            obj = (XFloat)this.requestObject();
        }
        finally {
            Object var6_5 = null;
            this.factory.setDataType(oldClass);
            this.setFilter(oldFilter);
        }
        return obj.getValue();
    }

    public double demandDouble() {
        return this.demandDouble(null);
    }

    public double demandDouble(StringableFilter f) {
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XDouble != null ? class$edu$neu$ccs$XDouble : (class$edu$neu$ccs$XDouble = TextFieldView.class$("edu.neu.ccs.XDouble")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        XDouble obj = (XDouble)this.demandObject();
        this.factory.setDataType(oldClass);
        this.setFilter(oldFilter);
        return obj.getValue();
    }

    public double requestDouble() throws CancelledException {
        return this.requestDouble(null);
    }

    public double requestDouble(StringableFilter f) throws CancelledException {
        XDouble obj = null;
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XDouble != null ? class$edu$neu$ccs$XDouble : (class$edu$neu$ccs$XDouble = TextFieldView.class$("edu.neu.ccs.XDouble")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        try {
            obj = (XDouble)this.requestObject();
        }
        finally {
            Object var6_5 = null;
            this.factory.setDataType(oldClass);
            this.setFilter(oldFilter);
        }
        return obj.getValue();
    }

    public char demandChar() {
        return this.demandChar(null);
    }

    public char demandChar(StringableFilter f) {
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XChar != null ? class$edu$neu$ccs$XChar : (class$edu$neu$ccs$XChar = TextFieldView.class$("edu.neu.ccs.XChar")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        XChar obj = (XChar)this.demandObject();
        this.factory.setDataType(oldClass);
        this.setFilter(oldFilter);
        return obj.getValue();
    }

    public char requestChar() throws CancelledException {
        return this.requestChar(null);
    }

    public char requestChar(StringableFilter f) throws CancelledException {
        XChar obj = null;
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XChar != null ? class$edu$neu$ccs$XChar : (class$edu$neu$ccs$XChar = TextFieldView.class$("edu.neu.ccs.XChar")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        try {
            obj = (XChar)this.requestObject();
        }
        finally {
            Object var6_5 = null;
            this.factory.setDataType(oldClass);
            this.setFilter(oldFilter);
        }
        return obj.getValue();
    }

    public boolean demandBoolean() {
        return this.demandBoolean(null);
    }

    public boolean demandBoolean(StringableFilter f) {
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XBoolean != null ? class$edu$neu$ccs$XBoolean : (class$edu$neu$ccs$XBoolean = TextFieldView.class$("edu.neu.ccs.XBoolean")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        XBoolean obj = (XBoolean)this.demandObject();
        this.factory.setDataType(oldClass);
        this.setFilter(oldFilter);
        return obj.getValue();
    }

    public boolean requestBoolean() throws CancelledException {
        return this.requestBoolean(null);
    }

    public boolean requestBoolean(StringableFilter f) throws CancelledException {
        XBoolean obj = null;
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XBoolean != null ? class$edu$neu$ccs$XBoolean : (class$edu$neu$ccs$XBoolean = TextFieldView.class$("edu.neu.ccs.XBoolean")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        try {
            obj = (XBoolean)this.requestObject();
        }
        finally {
            Object var6_5 = null;
            this.factory.setDataType(oldClass);
            this.setFilter(oldFilter);
        }
        return obj.getValue();
    }

    public String demandString() {
        return this.demandString(null);
    }

    public String demandString(StringableFilter f) {
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XString != null ? class$edu$neu$ccs$XString : (class$edu$neu$ccs$XString = TextFieldView.class$("edu.neu.ccs.XString")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        XString obj = (XString)this.demandObject();
        this.factory.setDataType(oldClass);
        this.setFilter(oldFilter);
        return obj.getValue();
    }

    public String requestString() throws CancelledException {
        return this.requestString(null);
    }

    public String requestString(StringableFilter f) throws CancelledException {
        XString obj = null;
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XString != null ? class$edu$neu$ccs$XString : (class$edu$neu$ccs$XString = TextFieldView.class$("edu.neu.ccs.XString")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        try {
            obj = (XString)this.requestObject();
        }
        finally {
            Object var6_5 = null;
            this.factory.setDataType(oldClass);
            this.setFilter(oldFilter);
        }
        return obj.getValue();
    }

    public BigInteger demandBigInteger() {
        return this.demandBigInteger(null);
    }

    public BigInteger demandBigInteger(StringableFilter f) {
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XBigInteger != null ? class$edu$neu$ccs$XBigInteger : (class$edu$neu$ccs$XBigInteger = TextFieldView.class$("edu.neu.ccs.XBigInteger")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        XBigInteger obj = (XBigInteger)this.demandObject();
        this.factory.setDataType(oldClass);
        this.setFilter(oldFilter);
        return obj.getValue();
    }

    public BigInteger requestBigInteger() throws CancelledException {
        return this.requestBigInteger(null);
    }

    public BigInteger requestBigInteger(StringableFilter f) throws CancelledException {
        XBigInteger obj = null;
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XBigInteger != null ? class$edu$neu$ccs$XBigInteger : (class$edu$neu$ccs$XBigInteger = TextFieldView.class$("edu.neu.ccs.XBigInteger")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        try {
            obj = (XBigInteger)this.requestObject();
        }
        finally {
            Object var6_5 = null;
            this.factory.setDataType(oldClass);
            this.setFilter(oldFilter);
        }
        return obj.getValue();
    }

    public BigDecimal demandBigDecimal() {
        return this.demandBigDecimal(null);
    }

    public BigDecimal demandBigDecimal(StringableFilter f) {
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XBigDecimal != null ? class$edu$neu$ccs$XBigDecimal : (class$edu$neu$ccs$XBigDecimal = TextFieldView.class$("edu.neu.ccs.XBigDecimal")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        XBigDecimal obj = (XBigDecimal)this.demandObject();
        this.factory.setDataType(oldClass);
        this.setFilter(oldFilter);
        return obj.getValue();
    }

    public BigDecimal requestBigDecimal() throws CancelledException {
        return this.requestBigDecimal(null);
    }

    public BigDecimal requestBigDecimal(StringableFilter f) throws CancelledException {
        XBigDecimal obj = null;
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(class$edu$neu$ccs$XBigDecimal != null ? class$edu$neu$ccs$XBigDecimal : (class$edu$neu$ccs$XBigDecimal = TextFieldView.class$("edu.neu.ccs.XBigDecimal")));
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(f);
        try {
            obj = (XBigDecimal)this.requestObject();
        }
        finally {
            Object var6_5 = null;
            this.factory.setDataType(oldClass);
            this.setFilter(oldFilter);
        }
        return obj.getValue();
    }

    public void setFilter(StringableFilter f) {
        StringableFilter oldFilter = this.getFilter();
        this.filter = f;
        if (this.getFilter() == oldFilter) {
            this.firePropertyChange(FILTER, oldFilter, this.getFilter());
        }
    }

    public StringableFilter getFilter() {
        return this.filter;
    }

    public void setPreferredWidth(int width) {
        if (width > 0) {
            this.setPreferredSize(new Dimension(width, this.getPreferredSize().height));
        }
    }

    public void setAutoSelect(boolean b) {
        boolean oldAuto = this.getAutoSelect();
        this.autoSelect = b;
        if (this.getAutoSelect() != oldAuto) {
            this.firePropertyChange(AUTO_SELECT, oldAuto, this.getAutoSelect());
        }
    }

    public boolean getAutoSelect() {
        return this.autoSelect;
    }

    protected boolean handleError(Stringable obj, int inputModel, ParseException exception) {
        this.fireDataMalformed(new MalformedDataEvent(this, this.getViewState(), exception));
        InputProperties errorProperties = new InputProperties(this.properties);
        errorProperties.setInputModel(inputModel);
        TextFieldView clone = new TextFieldView(this.getDocument());
        clone.setInputProperties(errorProperties);
        ErrorDialog d = new ErrorDialog(obj, clone, this.getFilter(), exception);
        ((Component)d).setVisible(true);
        this.fireDataMalformed(new MalformedDataEvent((Object)this, this.getViewState()));
        return d.wasCancelled() ^ true;
    }

    protected void installFocusActions() {
        FocusActionAdapter adapter = new FocusActionAdapter();
        adapter.addFocusGainedAction(new 1());
        this.addFocusListener(adapter);
    }

    protected void fireDataMalformed(MalformedDataEvent evt) {
        Object[] obj = this.listenerList.getListenerList();
        int i = obj.length - 2;
        while (i >= 0) {
            if (obj[i] != null && obj[i].equals(class$edu$neu$ccs$gui$MalformedDataListener != null ? class$edu$neu$ccs$gui$MalformedDataListener : TextFieldView.class$("edu.neu.ccs.gui.MalformedDataListener"))) {
                MalformedDataListener m = (MalformedDataListener)obj[i + 1];
                m.dataMalformed(evt);
            }
            i -= 2;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private final class 1
    extends SimpleAction {
        public void perform() {
            if (TextFieldView.this.getAutoSelect()) {
                TextFieldView.this.selectAll();
            }
        }

        /* synthetic */ 1() {
        }
    }
}

