/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XInt;
import edu.neu.ccs.gui.CenterLayout;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.WindowActionAdapter;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.JFrame;

public class JPTFrame
extends JFrame
implements JPTConstants {
    public static final int EXIT_ON_CLOSE = 3;
    public static final int EXIT_ON_CLOSE_IF_LAST = 6;
    public static final int DEFAULT_CLOSE_OPERATION = 6;
    protected static XInt counter = new XInt(0);
    protected int closeOperation = 6;

    public JPTFrame() {
        this("");
    }

    public JPTFrame(String title) {
        super(title);
        super.setDefaultCloseOperation(0);
        this.setDefaultCloseOperation(6);
        this.installWindowAdapter();
        XInt xInt = counter;
        synchronized (xInt) {
            counter.setValue(counter.getValue() + 1);
        }
    }

    public void center() {
        this.setLocation(0);
    }

    public void setLocation(int alignment) {
        this.setLocation(alignment, new Insets(0, 0, 0, 0));
    }

    public void setLocation(int alignment, Insets insets) {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        Point p = new Point();
        int dx = size.width - insets.left - insets.right - this.getWidth();
        int dy = size.height - insets.top - insets.bottom - this.getHeight();
        if (dx < 0) {
            dx = 0;
        }
        if (dy < 0) {
            dy = 0;
        }
        int flushWest = insets.left;
        int centerWE = insets.left + dx / 2;
        int flushEast = insets.left + dx;
        int flushNorth = insets.top;
        int centerNS = insets.top + dy / 2;
        int flushSouth = insets.top + dy;
        switch (alignment) {
            case 2: {
                p.setLocation(flushEast, flushNorth);
                break;
            }
            case 3: {
                p.setLocation(flushEast, centerNS);
                break;
            }
            case 4: {
                p.setLocation(flushEast, flushSouth);
                break;
            }
            case 1: {
                p.setLocation(centerWE, flushNorth);
                break;
            }
            case -1: 
            case 0: {
                p.setLocation(centerWE, centerNS);
                break;
            }
            case 5: {
                p.setLocation(centerWE, flushSouth);
                break;
            }
            case 8: {
                p.setLocation(flushWest, flushNorth);
                break;
            }
            case 7: {
                p.setLocation(flushWest, centerNS);
                break;
            }
            case 6: {
                p.setLocation(flushWest, flushSouth);
                break;
            }
            default: {
                return;
            }
        }
        ((Component)this).setLocation(p.x, p.y);
    }

    public void addNotify() {
        super.addNotify();
        ((Component)this).setSize(this.getSize().width + this.getInsets().left + this.getInsets().right, this.getSize().height + this.getInsets().top + this.getInsets().bottom);
    }

    public void setDefaultCloseOperation(int operation) {
        switch (operation) {
            case -1: {
                this.closeOperation = 6;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                this.closeOperation = operation;
                break;
            }
            default: {
                return;
            }
        }
    }

    public int getDefaultCloseOperation() {
        return this.closeOperation;
    }

    public static int getJPTFrameCount() {
        XInt xInt = counter;
        synchronized (xInt) {
            int $return = counter.getValue();
            Object var2_2 = null;
            return $return;
        }
    }

    public void dispose() {
        XInt xInt = counter;
        synchronized (xInt) {
            counter.setValue(counter.getValue() - 1);
            super.dispose();
        }
    }

    public static JPTFrame createQuickJPTFrame(String title, Component contents) {
        return JPTFrame.createQuickJPTFrame(title, contents, new CenterLayout());
    }

    public static JPTFrame createQuickJPTFrame(String title, Component contents, LayoutManager layout) {
        return JPTFrame.createQuickJPTFrame(title, contents, layout, -1);
    }

    public static JPTFrame createQuickJPTFrame(String title, Component contents, int location) {
        return JPTFrame.createQuickJPTFrame(title, contents, new CenterLayout(), location);
    }

    public static JPTFrame createQuickJPTFrame(String title, Component contents, LayoutManager layout, int location) {
        JPTFrame f = new JPTFrame(title == null ? "" : title);
        if (layout != null) {
            f.getContentPane().setLayout(layout);
        }
        if (contents != null) {
            f.getContentPane().add(contents);
        }
        f.pack();
        f.setLocation(location);
        ((Component)f).setVisible(true);
        return f;
    }

    protected static XInt getCounter() {
        return counter;
    }

    public void installWindowAdapter() {
        WindowActionAdapter adapter = new WindowActionAdapter(this);
        adapter.addWindowClosingAction(new 1());
    }

    private final class 1
    extends SimpleAction {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void perform() {
            XInt xInt = JPTFrame.getCounter();
            synchronized (xInt) {
                int operation = JPTFrame.this.getDefaultCloseOperation();
                if (operation == 0) {
                    return;
                }
                ((Component)JPTFrame.this).setVisible(false);
                if (operation == 1) {
                    return;
                }
                JPTFrame.this.dispose();
                if (operation == 2) {
                    return;
                }
                if (operation != 3) {
                    if (JPTFrame.getJPTFrameCount() != 0) return;
                }
                System.exit(0);
                return;
            }
        }

        /* synthetic */ 1() {
        }
    }
}

