/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.util.JPTConstants;
import java.io.Serializable;
import java.util.Hashtable;

public class InputProperties
implements JPTConstants,
Cloneable,
Serializable {
    public static final String INPUT_PROMPT = "input.prompt";
    public static final String DIALOG_TITLE = "dialog.title";
    public static final String INPUT_MODEL = "input.model";
    public static final String SUGGESTION = "suggestion";
    public static final InputProperties BASE_PROPERTIES = new InputProperties(null);
    protected Hashtable table = new Hashtable();
    protected InputProperties next = null;

    static {
        BASE_PROPERTIES.setProperty(INPUT_PROMPT, "Please enter a valid value:");
        BASE_PROPERTIES.setProperty(DIALOG_TITLE, "Input");
        BASE_PROPERTIES.setProperty(INPUT_MODEL, new Integer(1));
        BASE_PROPERTIES.setProperty(SUGGESTION, null);
    }

    public InputProperties() {
        this.next = BASE_PROPERTIES;
    }

    public InputProperties(InputProperties properties) {
        this.next = properties;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InputProperties)) {
            return false;
        }
        if (this.table == null) {
            return false;
        }
        InputProperties p = (InputProperties)other;
        return this.table.equals(p.table) && (this.next != null && p.next != null && this.next.equals(p.next) || this.next == null && p.next == null);
    }

    public void setProperty(String propertyName, Object property) {
        if (this.table.containsKey(propertyName)) {
            this.table.remove(propertyName);
        }
        if (property != null) {
            this.table.put(propertyName, property);
        }
    }

    public Object getProperty(String propertyName) {
        Object found = this.table.get(propertyName);
        if (found == null && this.next != null) {
            found = this.next.getProperty(propertyName);
        }
        return found;
    }

    public void setInputPrompt(String inputPrompt) {
        this.setProperty(INPUT_PROMPT, inputPrompt);
    }

    public String getInputPrompt() {
        return (String)this.getProperty(INPUT_PROMPT);
    }

    public void setDialogTitle(String dialogTitle) {
        this.setProperty(DIALOG_TITLE, dialogTitle);
    }

    public String getDialogTitle() {
        return (String)this.getProperty(DIALOG_TITLE);
    }

    public void setInputModel(int inputModel) {
        this.setProperty(INPUT_MODEL, new Integer(inputModel));
    }

    public int getInputModel() {
        return (Integer)this.getProperty(INPUT_MODEL);
    }

    public void setSuggestion(String suggestion) {
        this.setProperty(SUGGESTION, suggestion);
    }

    public String getSuggestion() {
        return (String)this.getProperty(SUGGESTION);
    }
}

