/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XString;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.Fragile;
import edu.neu.ccs.gui.InputProperties;
import edu.neu.ccs.gui.MalformedDataEvent;
import edu.neu.ccs.gui.MalformedDataListener;
import edu.neu.ccs.gui.TextFieldView;
import edu.neu.ccs.gui.TypedView;
import edu.neu.ccs.util.JPTUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileView
extends DisplayPanel
implements TypedView,
Fragile {
    public static final String LAST_PATH = "last.path";
    public static final String DEFAULT_FILENAME = "";
    public static final String DEFAULT_BUTTON_LABEL = "Browse";
    public static final int DEFAULT_ALIGNMENT = 4;
    protected static final FileFilter ALL_FILES_FILTER = new 1();
    protected static String lastPath = null;
    protected int align = 4;
    protected TextFieldView field = null;
    protected JButton browse = null;
    protected InputProperties properties = new InputProperties();
    static /* synthetic */ Class class$edu$neu$ccs$XString;
    static /* synthetic */ Class class$edu$neu$ccs$gui$MalformedDataListener;

    public FileView() {
        this(DEFAULT_FILENAME, 4);
    }

    public FileView(String name) {
        this(name, 4);
    }

    public FileView(String name, int align) {
        try {
            lastPath = System.getProperty("user.dir");
        }
        catch (SecurityException securityException) {}
        this.field = new TextFieldView(name);
        this.field.setPreferredWidth(100);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.field, "Center");
        this.setAlignment(align);
        this.addMalformedDataListener(this);
    }

    public Stringable demandObject() {
        return new XString(this.getViewState());
    }

    public Stringable requestObject() throws CancelledException {
        return this.demandObject();
    }

    public void setInputProperties(InputProperties p) {
        if (p == null) {
            p = InputProperties.BASE_PROPERTIES;
        }
        InputProperties oldProperties = this.getInputProperties();
        this.properties = p;
        if (this.getInputProperties() != null && !this.getInputProperties().equals(oldProperties)) {
            this.firePropertyChange("input.properties", oldProperties, this.getInputProperties());
        }
    }

    public InputProperties getInputProperties() {
        return this.properties;
    }

    public Class getDataType() {
        return class$edu$neu$ccs$XString != null ? class$edu$neu$ccs$XString : (class$edu$neu$ccs$XString = FileView.class$("edu.neu.ccs.XString"));
    }

    public void setViewState(String data) {
        this.field.setViewState(data);
        this.firePropertyChange("view.state", null, data);
    }

    public String getViewState() {
        return this.field.getViewState();
    }

    public void setDefaultViewState(String data) {
        this.field.setDefaultViewState(data);
        this.firePropertyChange("default.view.state", null, data);
    }

    public String getDefaultViewState(String data) {
        return this.field.getDefaultViewState();
    }

    public void reset() {
        this.field.reset();
    }

    public void setEnabled(boolean isEnabled) {
        this.field.setEnabled(isEnabled);
        this.browse.setEnabled(isEnabled);
        super.setEnabled(isEnabled);
    }

    public void addMalformedDataListener(MalformedDataListener l) {
        this.listenerList.add(class$edu$neu$ccs$gui$MalformedDataListener != null ? class$edu$neu$ccs$gui$MalformedDataListener : (class$edu$neu$ccs$gui$MalformedDataListener = FileView.class$("edu.neu.ccs.gui.MalformedDataListener")), l);
    }

    public void removeMalformedDataListener(MalformedDataListener l) {
        this.listenerList.remove(class$edu$neu$ccs$gui$MalformedDataListener != null ? class$edu$neu$ccs$gui$MalformedDataListener : (class$edu$neu$ccs$gui$MalformedDataListener = FileView.class$("edu.neu.ccs.gui.MalformedDataListener")), l);
    }

    public File demandExistingFile() {
        return new File(this.demandExistingFilename());
    }

    public File demandFile() {
        return new File(this.demandFilename());
    }

    public String demandExistingFilename() {
        try {
            return this.performRequest(false, true);
        }
        catch (CancelledException cancelledException) {
            return null;
        }
    }

    public String demandFilename() {
        try {
            return this.performRequest(true, true);
        }
        catch (CancelledException cancelledException) {
            return null;
        }
    }

    public File requestExistingFile() throws CancelledException {
        return new File(this.requestExistingFilename());
    }

    public File requestFile() throws CancelledException {
        return new File(this.requestFilename());
    }

    public String requestExistingFilename() throws CancelledException {
        return this.performRequest(false, false);
    }

    public String requestFilename() throws CancelledException {
        return this.performRequest(true, false);
    }

    public void setAlignment(int alignment) {
        int oldAlignment = this.getAlignment();
        switch (alignment) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.align = alignment;
                break;
            }
            case -1: {
                this.align = 4;
                break;
            }
            default: {
                return;
            }
        }
        if (this.browse == null) {
            this.browse = new JButton(DEFAULT_BUTTON_LABEL);
            this.browse.addActionListener(new 2());
        } else {
            this.remove(this.browse);
        }
        this.add((Component)this.browse, JPTUtilities.getBorderLayoutLocation(alignment));
        if (this.getAlignment() != oldAlignment) {
            this.firePropertyChange("alignment", oldAlignment, this.getAlignment());
        }
    }

    public int getAlignment() {
        return this.align;
    }

    public void setLastPath(String path) {
        String oldPath = this.getLastPath();
        lastPath = path;
        if (this.getLastPath() != null && !this.getLastPath().equals(oldPath)) {
            this.firePropertyChange(LAST_PATH, oldPath, this.getLastPath());
        }
    }

    public String getLastPath() {
        return lastPath;
    }

    protected JButton getBrowseButton() {
        return this.browse;
    }

    protected void fireDataMalformed(MalformedDataEvent evt) {
        Object[] obj = this.listenerList.getListenerList();
        int i = obj.length - 2;
        while (i >= 0) {
            if (obj[i] != null && obj[i].equals(class$edu$neu$ccs$gui$MalformedDataListener != null ? class$edu$neu$ccs$gui$MalformedDataListener : FileView.class$("edu.neu.ccs.gui.MalformedDataListener"))) {
                MalformedDataListener m = (MalformedDataListener)obj[i];
                m.dataMalformed(evt);
            }
            i -= 2;
        }
    }

    protected String performRequest(boolean anyValid, boolean mandatory) throws CancelledException {
        boolean alert = false;
        File file = new File(this.field.getViewState());
        JFileChooser fc = null;
        while (!file.exists()) {
            int selection;
            try {
                if (anyValid && file.createNewFile()) {
                    file.delete();
                    break;
                }
            }
            catch (IOException iOException) {}
            if (!alert) {
                alert = true;
                this.fireDataMalformed(new MalformedDataEvent(this, this.field.getViewState(), new ParseException("Path/filename is not valid.", -1)));
            }
            if (fc == null) {
                fc = new JFileChooser(file);
                fc.setMultiSelectionEnabled(false);
                fc.setFileFilter(ALL_FILES_FILTER);
            }
            if ((selection = fc.showDialog(this, "Select")) == 0) {
                file = fc.getSelectedFile();
                this.field.setViewState(file.getPath());
                this.setLastPath(file.getPath());
                continue;
            }
            if (selection == 1 && !mandatory) {
                if (alert) {
                    this.fireDataMalformed(new MalformedDataEvent((Object)this, null));
                }
                throw new CancelledException();
            }
            fc.setSelectedFile(file);
        }
        if (alert) {
            this.fireDataMalformed(new MalformedDataEvent((Object)this, this.field.getViewState()));
        }
        return this.field.getViewState();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private final class 1
    extends FileFilter {
        public boolean accept(File f) {
            return true;
        }

        public String getDescription() {
            return "All files (*.*)";
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            JFileChooser fc = new JFileChooser(FileView.this.getLastPath());
            fc.setFileFilter(ALL_FILES_FILTER);
            if (fc.showOpenDialog(null) == 0) {
                FileView.this.setViewState(fc.getSelectedFile().getPath());
                FileView.this.setLastPath(fc.getSelectedFile().getPath());
            }
        }

        /* synthetic */ 2() {
        }
    }

    public static class ExtensionFileFilter
    extends FileFilter
    implements Cloneable,
    Serializable {
        private String ext = null;

        public ExtensionFileFilter(String extension) {
            this.ext = extension.toUpperCase();
        }

        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            if (this.ext == null || this.ext.length() == 0) {
                return true;
            }
            return f.getName().toUpperCase().endsWith(this.ext);
        }

        public String getDescription() {
            if (this.ext == null) {
                return "All files: *.*";
            }
            return String.valueOf(this.ext) + " files: *." + this.ext.toLowerCase();
        }
    }
}

