/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.Annotation;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.Displayable;
import edu.neu.ccs.util.JPTUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class Display
extends DisplayPanel {
    public static final String ANNOTATION_TEXT = "annotation.text";
    public static final String ANNOTATION_ALIGNMENT = "annotation.alignment";
    public static final String TITLE_TEXT = "title.text";
    public static final String TITLE_ALIGNMENT = "title.alignment";
    public static final String DISPLAY = "display";
    public static final String ANNOTATION = "annotation";
    public static final String DEFAULT_ANNOTATION_TEXT = null;
    public static final String DEFAULT_TITLE_TEXT = null;
    public static final int DEFAULT_ANNOTATION_ALIGNMENT = 2;
    public static final int DEFAULT_TITLE_ALIGNMENT = 1;
    protected String title = null;
    protected int aAlign = 2;
    protected int tAlign = 1;
    protected Displayable view = null;
    protected Annotation caption = null;

    public Display() {
        this(new DisplayPanel(), null, null, 2, 1);
    }

    public Display(Displayable viewObject) {
        this(viewObject, null, null, 2, 1);
    }

    public Display(Displayable viewObject, String annotationText, String titleText) {
        this(viewObject, annotationText, titleText, 2, 1);
    }

    public Display(Displayable viewObject, String annotationText, String titleText, int annotationAlign, int titleAlign) {
        this.setLayout(new BorderLayout(5, 5));
        this.setDisplay(viewObject);
        this.setAnnotation(new Annotation(annotationText));
        this.setAnnotationAlignment(annotationAlign);
        this.setTitleText(titleText);
        this.setTitleAlignment(titleAlign);
    }

    public Display(Displayable viewObject, Settings settings) {
        this(viewObject, settings != null ? settings.annotationText : null, settings != null ? settings.titleText : null, settings != null ? settings.annotationAlign : 2, settings != null ? settings.titleAlign : 1);
    }

    public void setViewState(String data) {
        this.view.setViewState(data);
        this.firePropertyChange("view.state", null, data);
    }

    public String getViewState() {
        return this.view.getViewState();
    }

    public void setDefaultViewState(String data) {
        this.view.setDefaultViewState(data);
        this.firePropertyChange("default.view.state", null, data);
    }

    public void setAnnotationText(String text) {
        String oldText = this.getAnnotationText();
        if (this.caption == null) {
            this.setAnnotation(new Annotation(text));
        } else {
            this.caption.setText(text);
        }
        if (this.getAnnotationText() != null && !this.getAnnotationText().equals(oldText)) {
            this.firePropertyChange(ANNOTATION_TEXT, oldText, text);
        }
    }

    public String getAnnotationText() {
        if (this.caption == null) {
            return null;
        }
        return this.caption.getText();
    }

    public void setAnnotationAlignment(int alignment) {
        int oldAlignment = this.getAnnotationAlignment();
        switch (alignment) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.aAlign = alignment;
                break;
            }
            case -1: {
                this.aAlign = 2;
                break;
            }
            default: {
                return;
            }
        }
        this.revalidateAnnotationAndAlignment();
        if (this.getAnnotationAlignment() != oldAlignment) {
            this.firePropertyChange(ANNOTATION_ALIGNMENT, oldAlignment, this.getAnnotationAlignment());
        }
    }

    public int getAnnotationAlignment() {
        return this.aAlign;
    }

    public void setTitleText(String text) {
        String oldTitle = this.getTitleText();
        this.title = text;
        this.revalidateTitleAndAlignment();
        if (this.getTitleText() != null && !this.getTitleText().equals(oldTitle)) {
            this.firePropertyChange(TITLE_TEXT, oldTitle, this.getTitleText());
        }
    }

    public String getTitleText() {
        return this.title;
    }

    public void setTitleAlignment(int alignment) {
        int oldAlignment = this.getTitleAlignment();
        switch (alignment) {
            case 1: 
            case 3: {
                this.tAlign = alignment;
                break;
            }
            case -1: {
                this.tAlign = 1;
                break;
            }
            default: {
                return;
            }
        }
        this.revalidateTitleAndAlignment();
        if (this.getTitleAlignment() != oldAlignment) {
            this.firePropertyChange(ANNOTATION_ALIGNMENT, oldAlignment, this.getTitleAlignment());
        }
    }

    public int getTitleAlignment() {
        return this.tAlign;
    }

    public void setDisplay(Displayable viewObject) {
        Displayable oldDisplay = this.getDisplay();
        if (viewObject != oldDisplay) {
            if (this.view != null) {
                this.remove((Component)((Object)this.view));
            }
            if (viewObject == null) {
                viewObject = new DisplayPanel();
            }
            this.view = viewObject;
            this.add((Component)((Object)this.view), "Center");
            this.revalidate();
            this.firePropertyChange(DISPLAY, oldDisplay, this.getDisplay());
        }
    }

    public Displayable getDisplay() {
        return this.view;
    }

    public void setAnnotation(Annotation annotation) {
        Annotation oldAnnotation = this.getAnnotation();
        if (this.caption != null) {
            super.remove(this.caption);
            this.caption = null;
        }
        if (annotation != null) {
            this.caption = annotation;
            super.add((Component)this.caption, JPTUtilities.getBorderLayoutLocation(this.aAlign));
        }
        this.revalidate();
        if (annotation != oldAnnotation) {
            this.firePropertyChange(ANNOTATION, oldAnnotation, this.getAnnotation());
        }
    }

    public Annotation getAnnotation() {
        return this.caption;
    }

    public void setSettings(Settings s) {
        if (s != null) {
            this.setAnnotationText(s.annotationText);
            this.setTitleText(s.titleText);
            this.setAnnotationAlignment(s.annotationAlign);
            this.setTitleAlignment(s.titleAlign);
        } else {
            this.setAnnotationText(null);
            this.setTitleText(null);
            this.setAnnotationAlignment(2);
            this.setTitleAlignment(1);
        }
    }

    public Settings getSettings() {
        return new Settings(this.getAnnotationText(), this.getTitleText(), this.getAnnotationAlignment(), this.getTitleAlignment());
    }

    protected void revalidateTitleAndAlignment() {
        if (this.title != null) {
            int verticalLocation = this.tAlign == 1 ? 2 : 5;
            this.setBorder(new CompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(), " " + this.title + " ", 2, verticalLocation), new EmptyBorder(5, 5, 5, 5)));
        } else {
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        this.revalidate();
    }

    protected void revalidateAnnotationAndAlignment() {
        if (this.caption != null) {
            super.remove(this.caption);
            super.add((Component)this.caption, JPTUtilities.getBorderLayoutLocation(this.aAlign));
        }
        this.revalidate();
    }

    public static class Settings
    implements Cloneable,
    Serializable {
        public String annotationText = null;
        public String titleText = null;
        public int annotationAlign = 2;
        public int titleAlign = 1;

        public Settings(String aText, String tText, int aAlign, int tAlign) {
            this.annotationText = aText;
            this.titleText = tText;
            this.annotationAlign = aAlign;
            this.titleAlign = tAlign;
        }
    }
}

