/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.AlignedLayout;
import edu.neu.ccs.gui.ComponentWrapper;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.util.DimensionUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class ComponentWrapper
extends DisplayPanel {
    protected WrappedComponent wrapper = null;

    public ComponentWrapper(Component component) {
        this(component, 0);
    }

    public ComponentWrapper(Component component, int alignment) {
        super(new AlignedLayout(alignment));
        this.setWrappedComponent(component);
        this.setMinimumSize(DimensionUtilities.createMinimumDimension());
        this.setMaximumSize(DimensionUtilities.createMaximumDimension());
    }

    public void setEnabled(boolean isEnabled) {
        this.getWrappedComponent().setEnabled(isEnabled);
        super.setEnabled(isEnabled);
    }

    public void setWrappedComponent(Component component) {
        if (component == null) {
            throw new NullPointerException("The component to be wrapped is null.");
        }
        if (this.wrapper != null) {
            this.remove(this.wrapper);
        }
        this.wrapper = new WrappedComponent(component);
        this.add(this.wrapper);
    }

    public Component getWrappedComponent() {
        return this.wrapper.getWrappedComponent();
    }

    public void setAbsoluteSize(Dimension size) {
        if (size == null) {
            return;
        }
        size = DimensionUtilities.createDimension(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.setPreferredSize(size);
    }

    public void setAbsoluteSize(int width, int height) {
        this.setAbsoluteSize(DimensionUtilities.createDimension(width, height));
    }

    public void setMinimumSize(Dimension size) {
        if (size == null) {
            size = DimensionUtilities.createMinimumDimension();
        }
        this.wrapper.setMinimumSize(size);
        this.revalidate();
    }

    public void setMinimumSize(int width, int height) {
        this.setMinimumSize(DimensionUtilities.createDimension(width, height));
    }

    public Dimension getMinimumSize() {
        return this.wrapper.getMinimumSize();
    }

    public void setMaximumSize(Dimension size) {
        if (size == null) {
            size = DimensionUtilities.createMaximumDimension();
        }
        this.wrapper.setMaximumSize(size);
        this.revalidate();
    }

    public void setMaximumSize(int width, int height) {
        this.setMaximumSize(DimensionUtilities.createDimension(width, height));
    }

    public Dimension getMaximumSize() {
        return this.wrapper.getMaximumSize();
    }

    public void setPreferredSize(Dimension size) {
        if (size == null) {
            return;
        }
        this.wrapper.setPreferredSize(size);
        this.revalidate();
    }

    public void setPreferredSize(int width, int height) {
        this.setPreferredSize(DimensionUtilities.createDimension(width, height));
    }

    public Dimension getPreferredSize() {
        return this.wrapper.getPreferredSize();
    }

    public void setAlignment(int alignment) {
        LayoutManager layout = this.getLayout();
        if (!(layout instanceof AlignedLayout)) {
            return;
        }
        AlignedLayout aligned = (AlignedLayout)layout;
        aligned.setAlignment(alignment);
    }

    public int getAlignment() {
        LayoutManager layout = this.getLayout();
        if (!(layout instanceof AlignedLayout)) {
            return -1;
        }
        AlignedLayout aligned = (AlignedLayout)layout;
        return aligned.getAlignment();
    }

    class WrappedComponent
    extends JPanel {
        protected Dimension minimumSize = DimensionUtilities.createMinimumDimension();
        protected Dimension maximumSize = DimensionUtilities.createMaximumDimension();
        protected JScrollPane scroll = null;
        protected Border scrollBorder = null;
        protected Component inner = null;
        protected ComponentListener sizeListener = new 1(this);

        public WrappedComponent(Component component) {
            this.inner = component;
            this.scroll = new JScrollPane(this.inner);
            this.scrollBorder = this.scroll.getBorder();
            this.scroll.setBorder(null);
            this.scroll.addComponentListener(this.sizeListener);
            this.setLayout(new BorderLayout());
            this.add((Component)this.scroll, "Center");
        }

        public Component getWrappedComponent() {
            return this.inner;
        }

        public void setMinimumSize(Dimension d) {
            this.minimumSize = DimensionUtilities.createDimension(d);
            this.maximumSize = DimensionUtilities.max(this.minimumSize, this.maximumSize);
        }

        public Dimension getMinimumSize() {
            return this.minimumSize;
        }

        public void setMaximumSize(Dimension d) {
            this.maximumSize = DimensionUtilities.createDimension(d);
            int width = this.scroll.getVerticalScrollBar().isVisible() ? this.scroll.getVerticalScrollBar().getWidth() : 0;
            int height = this.scroll.getHorizontalScrollBar().isVisible() ? this.scroll.getHorizontalScrollBar().getHeight() : 0;
            this.maximumSize = DimensionUtilities.expand(this.maximumSize, new Insets(0, 0, height, width));
            this.minimumSize = DimensionUtilities.min(this.minimumSize, this.maximumSize);
        }

        public Dimension getMaximumSize() {
            return this.maximumSize;
        }

        public void setPreferredSize(Dimension d) {
            if (!(this.inner instanceof JComponent)) {
                return;
            }
            ((JComponent)this.inner).setPreferredSize(d);
        }

        public Dimension getPreferredSize() {
            Dimension size = DimensionUtilities.createDimension(this.scroll.getPreferredSize());
            size = DimensionUtilities.min(size, this.maximumSize);
            size = DimensionUtilities.max(size, this.minimumSize);
            return size;
        }
    }
}

