/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XColor;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.InputProperties;
import edu.neu.ccs.gui.MouseAction;
import edu.neu.ccs.gui.MouseActionAdapter;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.TextFieldView;
import edu.neu.ccs.gui.TypedView;
import edu.neu.ccs.util.DimensionUtilities;
import edu.neu.ccs.util.JPTConstants;
import edu.neu.ccs.util.JPTError;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import javax.swing.Action;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.LineBorder;

public class ColorView
extends DisplayPanel
implements TypedView,
JPTConstants {
    public static final String COLOR_PROPERTY = "color";
    public static final String DEFAULT_COLOR_PROPERTY = "default color";
    public static final String CHOOSER_CLICK_COUNT_PROPERTY = "chooser click count";
    protected static final Color DEFAULT_COLOR = SystemColor.text;
    protected static final String DEFAULT_COLOR_STRING = new XColor(DEFAULT_COLOR).toStringData();
    protected static final int DEFAULT_CHOOSER_CLICK_COUNT = 2;
    protected static final Dimension DEFAULT_DIMENSION = new Dimension(20, 20);
    JComponent colorBox = new 1();
    TextFieldView colorField = new TextFieldView(DEFAULT_COLOR_STRING, "Fix \"r,g,b\" or \"r,g,b,alpha\" values", "Malformed color");
    protected Color currentColor = DEFAULT_COLOR;
    protected Color defaultColor = DEFAULT_COLOR;
    protected int chooserClickCount = 2;
    protected InputProperties properties = new InputProperties();
    protected MouseActionAdapter mouseActions = null;
    protected Action setColorFromField = new 2("Set Color");
    static /* synthetic */ Class class$edu$neu$ccs$XColor;

    public ColorView() {
        this((Color)null, false);
    }

    public ColorView(Color color) {
        this(color, false);
    }

    public ColorView(Color color, boolean showField) {
        this.installColorBox(color);
        this.installColorField(showField);
        this.installMouseActions();
        this.reset();
    }

    public Stringable demandObject() {
        return new XColor(this.getColor());
    }

    public Stringable requestObject() {
        return this.demandObject();
    }

    public void setInputProperties(InputProperties p) {
        InputProperties oldProperties = this.getInputProperties();
        this.properties = p;
        if (this.getInputProperties() != null && !this.getInputProperties().equals(oldProperties)) {
            this.firePropertyChange("input.properties", oldProperties, this.getInputProperties());
        }
    }

    public InputProperties getInputProperties() {
        return this.properties;
    }

    public Class getDataType() {
        return class$edu$neu$ccs$XColor != null ? class$edu$neu$ccs$XColor : (class$edu$neu$ccs$XColor = ColorView.class$("edu.neu.ccs.XColor"));
    }

    public void setViewState(String data) {
        this.setColor(ColorView.parseColor(data, "setViewState"));
        this.firePropertyChange("view.state", null, data);
    }

    public String getViewState() {
        return this.demandObject().toStringData();
    }

    public void setDefaultViewState(String data) {
        this.defaultColor = ColorView.parseColor(data, "setDefaultViewState");
        this.colorField.setDefaultViewState(data);
        this.firePropertyChange("default.view.state", null, data);
    }

    public String getDefaultViewState() {
        XColor x = new XColor(this.defaultColor);
        return x.toStringData();
    }

    public void reset() {
        this.setColor(this.defaultColor);
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        Color oldColor = this.currentColor;
        this.currentColor = color;
        this.colorBox.repaint();
        XColor obj = new XColor(color);
        this.colorField.setViewState(obj.toStringData());
        if (!color.equals(oldColor)) {
            this.firePropertyChange(COLOR_PROPERTY, oldColor, color);
        }
    }

    public Color getColor() {
        return this.currentColor;
    }

    public void setDefaultColor(Color color) {
        if (color == null) {
            return;
        }
        Color oldColor = this.defaultColor;
        this.defaultColor = color;
        this.colorField.setDefaultViewState(this.getDefaultViewState());
        if (!color.equals(oldColor)) {
            this.firePropertyChange(DEFAULT_COLOR_PROPERTY, oldColor, color);
        }
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setAbsoluteSize(Dimension dimension) {
        dimension = dimension == null ? DEFAULT_DIMENSION : DimensionUtilities.createDimension(dimension);
        this.colorBox.setMinimumSize(dimension);
        this.colorBox.setMaximumSize(dimension);
        this.colorBox.setPreferredSize(dimension);
        this.revalidate();
    }

    public void setAbsoluteSize(int width, int height) {
        this.setAbsoluteSize(new Dimension(width, height));
    }

    public void setChooserClickCount(int count) {
        int oldChooserClickCount = this.chooserClickCount;
        this.chooserClickCount = count <= 1 ? 1 : 2;
        if (this.chooserClickCount != oldChooserClickCount) {
            this.firePropertyChange(CHOOSER_CLICK_COUNT_PROPERTY, oldChooserClickCount, this.chooserClickCount);
        }
    }

    public int getChooserClickCount() {
        return this.chooserClickCount;
    }

    public void setMouseActionAdapter(MouseActionAdapter adapter) {
        if (adapter == null) {
            return;
        }
        this.mouseActions = adapter;
    }

    public MouseActionAdapter getMouseActionAdapter() {
        return this.mouseActions;
    }

    protected static Color parseColor(String data, String caller) {
        try {
            return new XColor(data).getValue();
        }
        catch (ParseException parseException) {
            throw new JPTError("Malformed data in ColorView." + caller + ": " + data);
        }
    }

    protected void setColorFromField() {
        XColor c = (XColor)this.colorField.demandObject();
        this.setColor(c.getValue());
    }

    protected void installColorBox(Color color) {
        if (color != null) {
            this.setDefaultColor(color);
        } else {
            this.setDefaultColor(DEFAULT_COLOR);
        }
        this.setAbsoluteSize(DEFAULT_DIMENSION);
        this.colorBox.setBorder(new LineBorder(Color.black, 1));
        this.add(this.colorBox);
    }

    protected void installColorField(boolean showField) {
        this.colorField.setDataType(class$edu$neu$ccs$XColor != null ? class$edu$neu$ccs$XColor : (class$edu$neu$ccs$XColor = ColorView.class$("edu.neu.ccs.XColor")));
        this.colorField.setPreferredWidth(120);
        String s = this.getDefaultViewState();
        this.colorField.setDefaultViewState(s);
        this.colorField.getInputProperties().setSuggestion(s);
        this.colorField.addActionListener(this.setColorFromField);
        if (showField) {
            this.add(this.colorField);
        }
    }

    protected void installMouseActions() {
        this.mouseActions = new MouseActionAdapter(this.colorBox);
        this.mouseActions.addMouseClickedAction(new 3());
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private final class 1
    extends JComponent {
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(ColorView.this.getColor());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends SimpleAction {
        public void perform() {
            ColorView.this.setColorFromField();
        }

        /* synthetic */ 2(String $0) {
            super($0);
        }
    }

    private final class 3
    extends MouseAction {
        public void mouseActionPerformed(MouseEvent evt) {
            Color c;
            if (ColorView.this.colorBox.isEnabled() && evt.getClickCount() >= ColorView.this.chooserClickCount && (c = JColorChooser.showDialog(new JLabel("Choose Color:"), "", ColorView.this.getColor())) != null) {
                ColorView.this.setColor(c);
            }
        }

        /* synthetic */ 3() {
        }
    }
}

