/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XNumber;
import edu.neu.ccs.codec.CodecUtilities;
import edu.neu.ccs.filter.FilterException;
import edu.neu.ccs.filter.RangeFilter;
import edu.neu.ccs.gui.ActionsPanel;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.gui.Display;
import edu.neu.ccs.gui.DisplayCollection;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.Displayable;
import edu.neu.ccs.gui.InputProperties;
import edu.neu.ccs.gui.ScrollableDisplay;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.TextFieldView;
import edu.neu.ccs.gui.TypedView;
import edu.neu.ccs.util.JPTUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public abstract class ArrayPanel
extends DisplayPanel
implements TypedView {
    public static final String CONTROLS = "controls";
    public static final String INCREMENT_BUTTON_TEXT = "increment.button.text";
    public static final String DECREMENT_BUTTON_TEXT = "decrement.button.text";
    public static final String LENGTH_PROMPT = "length.prompt";
    public static final String SET_BUTTON_TEXT = "set.button.text";
    public static final String LENGTH = "length";
    public static final String MINIMUM_LENGTH = "minimum.length";
    public static final String MAXIMUM_LENGTH = "maximum.length";
    public static final int NO_CONTROLS = 0;
    public static final int INCREMENT_DECREMENT = 1;
    public static final int LENGTH_TEXT_FIELD = 2;
    protected static final int CONTROLS_MASK = 3;
    public static final int DEFAULT_CONTROLS = 3;
    public static final int DEFAULT_ALIGNMENT = 3;
    public static final int DEFAULT_ORIENTATION = 1;
    public static final int DEFAULT_MINIMUM_LENGTH = 0;
    public static final int DEFAULT_MAXIMUM_LENGTH = Integer.MAX_VALUE;
    protected int align = 3;
    protected int controlsValue = 3;
    protected int minLength = 0;
    protected int maxLength = Integer.MAX_VALUE;
    protected int userMinLength = 0;
    protected int userMaxLength = 0;
    protected DisplayCollection views = null;
    protected ScrollableDisplay scroller = null;
    protected DisplayPanel controlPanel = null;
    protected Action increment = null;
    protected Action decrement = null;
    protected ActionsPanel lengthActions = new ActionsPanel();
    protected TextFieldView lengthField = new TextFieldView("");
    protected RangeFilter.Long lengthFilter = null;
    protected Action set = null;
    protected ActionsPanel setActions = new ActionsPanel();
    protected Display lengthControls = null;
    protected InputProperties properties = new InputProperties();
    protected String defaultViewState = null;

    public ArrayPanel() {
        this(null, 1, 3, 3);
    }

    public ArrayPanel(Stringable[] obj) {
        this(obj, 1, 3, 3);
    }

    public ArrayPanel(Stringable[] obj, int orientation) {
        this(obj, orientation, 3, 3);
    }

    public ArrayPanel(Stringable[] obj, int orientation, int controls, int alignment) {
        this.setLayout(new BorderLayout());
        this.views = new DisplayCollection();
        this.scroller = new ScrollableDisplay(this.views);
        this.add((Component)this.scroller, "Center");
        this.userMinLength = this.transformRawLengthToUserLength(this.minLength);
        this.userMaxLength = this.transformRawLengthToUserLength(this.maxLength);
        this.lengthFilter = new 1(this.userMinLength, this.userMaxLength);
        this.lengthField.setPreferredWidth(40);
        this.lengthControls = new Display(this.lengthField, "Length:", null);
        this.setOrientation(orientation);
        this.setControls(controls);
        this.setAlignment(alignment);
        this.increment = new 2("Increment");
        this.decrement = new 3("Decrement");
        this.lengthActions.addAction(this.increment);
        this.lengthActions.addAction(this.decrement);
        this.set = new 4("Set");
        this.setActions.addAction(this.set);
        this.lengthField.addActionListener(this.set);
        if (obj != null) {
            int i = 0;
            while (i < obj.length) {
                this.increment(obj[i].toStringData());
                ++i;
            }
            this.setLength(obj.length);
        } else {
            this.setLength(0);
        }
    }

    public abstract Stringable demandObject();

    public abstract Stringable requestObject() throws CancelledException;

    public void setInputProperties(InputProperties p) {
        InputProperties oldProperties = this.properties;
        this.properties = p;
        if (this.getInputProperties() != null && !this.getInputProperties().equals(oldProperties)) {
            this.firePropertyChange("input.properties", oldProperties, this.properties);
        }
    }

    public InputProperties getInputProperties() {
        return this.properties;
    }

    public abstract Class getDataType();

    public void setViewState(String data) {
        if (data == null) {
            return;
        }
        String[] decoded = CodecUtilities.decode(data);
        if (decoded == null) {
            return;
        }
        this.setLength(decoded.length);
        this.views.setViewState(data);
        this.firePropertyChange("view.state", null, data);
    }

    public String getViewState() {
        return this.views.getViewState();
    }

    public void setDefaultViewState(String data) {
        this.defaultViewState = data;
        this.firePropertyChange("default.view.state", null, data);
    }

    public String getDefaultViewState() {
        if (this.defaultViewState == null) {
            return this.views.getDefaultViewState();
        }
        return this.defaultViewState;
    }

    public void reset() {
        this.setViewState(this.getDefaultViewState());
    }

    public Stringable[] demandObjectArray() {
        if (this.getLength() == 0) {
            return null;
        }
        Stringable[] obj = new Stringable[this.getLength()];
        int i = 0;
        while (i < this.getLength()) {
            Display d = (Display)this.views.getItem(i);
            TypedView t = (TypedView)d.getDisplay();
            obj[i] = t.demandObject();
            ++i;
        }
        return obj;
    }

    public Stringable[] requestObjectArray() throws CancelledException {
        if (this.getLength() == 0) {
            return null;
        }
        Stringable[] obj = new Stringable[this.getLength()];
        int i = 0;
        while (i < this.getLength()) {
            Display d = (Display)this.views.getItem(i);
            TypedView t = (TypedView)d.getDisplay();
            obj[i] = t.requestObject();
            ++i;
        }
        return obj;
    }

    public TypedView getView(int index) {
        Component c = this.views.getItem(index);
        Display d = (Display)c;
        return (TypedView)d.getDisplay();
    }

    public void setOrientation(int orientation) {
        int oldOrientation = this.getOrientation();
        this.views.setOrientation(orientation);
        if (this.getOrientation() != oldOrientation) {
            this.firePropertyChange("orientation", oldOrientation, this.getOrientation());
        }
    }

    public int getOrientation() {
        return this.views.getOrientation();
    }

    public void setAlignment(int alignment) {
        int oldAlignment = this.align;
        switch (alignment) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.align = alignment;
                break;
            }
            case -1: {
                this.align = 3;
                break;
            }
            default: {
                return;
            }
        }
        this.revalidateDisplay();
        if (this.align != oldAlignment) {
            this.firePropertyChange("alignment", oldAlignment, this.getAlignment());
        }
    }

    public int getAlignment() {
        return this.align;
    }

    public void setControls(int controls) {
        int oldControls = this.controlsValue;
        this.controlsValue = controls == -1 ? 3 : controls & 3;
        this.revalidateDisplay();
        if (this.controlsValue != oldControls) {
            this.firePropertyChange(CONTROLS, oldControls, this.getControls());
        }
    }

    public int getControls() {
        return this.controlsValue;
    }

    public void setIncrementButtonText(String s) {
        if (s == null) {
            return;
        }
        String oldText = this.getIncrementButtonText();
        this.increment.putValue("Name", s);
        if (this.getIncrementButtonText() != oldText) {
            this.firePropertyChange(INCREMENT_BUTTON_TEXT, oldText, this.getIncrementButtonText());
        }
    }

    public String getIncrementButtonText() {
        return (String)this.increment.getValue("Name");
    }

    public void setDecrementButtonText(String text) {
        if (text == null) {
            return;
        }
        String oldText = this.getDecrementButtonText();
        this.decrement.putValue("Name", text);
        if (this.getDecrementButtonText() != oldText) {
            this.firePropertyChange(DECREMENT_BUTTON_TEXT, oldText, this.getDecrementButtonText());
        }
    }

    public String getDecrementButtonText() {
        return (String)this.decrement.getValue("Name");
    }

    public void setLengthPrompt(String prompt) {
        if (prompt == null) {
            return;
        }
        String oldPrompt = this.getLengthPrompt();
        this.lengthControls.setAnnotationText(prompt);
        if (this.getLengthPrompt() != oldPrompt) {
            this.firePropertyChange(LENGTH_PROMPT, oldPrompt, this.getLengthPrompt());
        }
    }

    public String getLengthPrompt() {
        return this.lengthControls.getAnnotationText();
    }

    public void setSetButtonText(String text) {
        if (text == null) {
            return;
        }
        String oldText = this.getSetButtonText();
        this.set.putValue("Name", text);
        if (this.getSetButtonText() != oldText) {
            this.firePropertyChange(SET_BUTTON_TEXT, oldText, this.getSetButtonText());
        }
    }

    public String getSetButtonText() {
        return (String)this.set.getValue("Name");
    }

    public void setLength(int length) {
        int oldLength = this.getLength();
        if (length < this.minLength) {
            length = this.minLength;
        }
        if (length > this.maxLength) {
            length = this.maxLength;
        }
        int userLength = this.transformRawLengthToUserLength(length);
        this.lengthField.setViewState(String.valueOf(userLength));
        while (this.getLength() < length) {
            this.increment(null);
        }
        while (this.getLength() > length) {
            this.decrement();
        }
        if (this.getLength() != oldLength) {
            this.firePropertyChange(LENGTH, oldLength, this.getLength());
        }
    }

    public int getLength() {
        return this.views.getItemCount();
    }

    public void setMinimumLength(int length) {
        int oldMinLength = this.getMinimumLength();
        if (length < 0) {
            length = 0;
        }
        if (length > this.getMaximumLength()) {
            this.setMaximumLength(length);
        }
        this.minLength = length;
        this.userMinLength = this.transformRawLengthToUserLength(this.minLength);
        this.lengthFilter.setMinimum(this.userMinLength);
        if (this.getLength() > this.minLength) {
            this.decrement.setEnabled(this.isEnabled());
        } else {
            this.decrement.setEnabled(false);
            if (this.getLength() < this.minLength) {
                this.setLength(this.minLength);
            }
        }
        if (this.getMinimumLength() != oldMinLength) {
            this.firePropertyChange(MINIMUM_LENGTH, oldMinLength, this.getMinimumLength());
        }
    }

    public int getMinimumLength() {
        return this.minLength;
    }

    public void setMaximumLength(int length) {
        int oldMaxLength = this.getMaximumLength();
        if (length < 0) {
            length = 0;
        }
        if (length < this.getMinimumLength()) {
            this.setMinimumLength(length);
        }
        this.maxLength = length;
        this.userMaxLength = this.transformRawLengthToUserLength(this.maxLength);
        this.lengthFilter.setMaximum(this.userMaxLength);
        if (this.getLength() < this.maxLength) {
            this.increment.setEnabled(this.isEnabled());
        } else {
            this.increment.setEnabled(false);
            while (this.getLength() > this.maxLength) {
                this.setLength(this.maxLength);
            }
        }
        if (this.getMaximumLength() != oldMaxLength) {
            this.firePropertyChange(MAXIMUM_LENGTH, oldMaxLength, this.getMaximumLength());
        }
    }

    public int getMaximumLength() {
        return this.maxLength;
    }

    protected Display.Settings createDisplaySettingsFor(int index) {
        return new Display.Settings(this.createPromptTextFor(index), null, 2, -1);
    }

    protected TypedView createViewFor(int index) {
        return new TextFieldView("");
    }

    protected String createPromptTextFor(int index) {
        return String.valueOf(index) + ":";
    }

    public String createLengthSetOutOfBoundsMessage(FilterException exception) {
        try {
            if (exception.getModel() instanceof XNumber) {
                XNumber x = (XNumber)exception.getModel();
                int length = this.transformUserLengthToRawLength(x.intValue());
                if (length < this.minLength) {
                    return "The given " + this.getLengthPrompt() + " is less than the minimum " + this.getLengthPrompt() + " of " + this.transformRawLengthToUserLength(this.minLength);
                }
                return "The given " + this.getLengthPrompt() + " is greater than the maximum " + this.getLengthPrompt() + " of " + this.transformRawLengthToUserLength(this.maxLength);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return "The provided " + this.getLengthPrompt() + " is not in the range [" + this.transformRawLengthToUserLength(this.minLength) + ", " + this.transformRawLengthToUserLength(this.maxLength) + "]";
    }

    protected void increment(String data) {
        Display c = this.createDisplayFor(this.getLength());
        this.views.add(c);
        this.decrement.setEnabled(this.isEnabled());
        if (this.getLength() == this.maxLength) {
            this.increment.setEnabled(false);
        }
        if (data != null) {
            Displayable d = c;
            d.setViewState(data);
        }
    }

    protected TypedView decrement() {
        Component c = this.views.getItem(this.getLength() - 1);
        this.views.remove(c);
        Display d = (Display)c;
        TypedView v = (TypedView)d.getDisplay();
        this.increment.setEnabled(this.isEnabled());
        if (this.getLength() == this.minLength) {
            this.decrement.setEnabled(false);
        }
        return v;
    }

    protected void applyLengthFromControls() {
        int length;
        try {
            length = this.requestArrayLength();
        }
        catch (CancelledException cancelledException) {
            return;
        }
        this.setLength(length);
    }

    protected int requestArrayLength() throws CancelledException {
        return this.transformUserLengthToRawLength(this.lengthField.requestInt(this.lengthFilter));
    }

    protected int transformUserLengthToRawLength(int userLength) {
        return userLength;
    }

    protected int transformRawLengthToUserLength(int rawLength) {
        return rawLength;
    }

    protected void revalidateDisplay() {
        if (this.controlPanel != null) {
            this.remove(this.controlPanel);
        }
        this.controlPanel = this.createControlPanel();
        if (this.controlPanel != null) {
            this.add((Component)this.controlPanel, JPTUtilities.getBorderLayoutLocation(this.align));
        }
        this.revalidate();
    }

    protected DisplayPanel createControlPanel() {
        if (this.controlsValue == 0) {
            return null;
        }
        DisplayPanel temp = new DisplayPanel();
        temp.setLayout(new BoxLayout(temp, 1));
        if ((this.controlsValue & 1) != 0) {
            temp.add(this.lengthActions);
        }
        if ((this.controlsValue & 2) != 0) {
            JPanel p = new JPanel(new FlowLayout(1));
            p.add(this.lengthControls);
            p.add(this.setActions);
            temp.add(p);
        }
        temp.add(Box.createVerticalGlue());
        return temp;
    }

    private final Display createDisplayFor(int index) {
        return new Display(this.createViewFor(index), this.createDisplaySettingsFor(index));
    }

    private final class 1
    extends RangeFilter.Long {
        public Stringable filterStringable(Stringable obj) throws FilterException {
            try {
                return super.filterStringable(obj);
            }
            catch (FilterException ex) {
                throw new FilterException(obj, ArrayPanel.this.createLengthSetOutOfBoundsMessage(ex));
            }
        }

        /* synthetic */ 1(long $0, long $1) {
            super($0, $1);
        }
    }

    private final class 2
    extends SimpleAction {
        public void perform() {
            ArrayPanel.this.setLength(ArrayPanel.this.getLength() + 1);
        }

        /* synthetic */ 2(String $0) {
            super($0);
        }
    }

    private final class 3
    extends SimpleAction {
        public void perform() {
            ArrayPanel.this.setLength(ArrayPanel.this.getLength() - 1);
        }

        /* synthetic */ 3(String $0) {
            super($0);
        }
    }

    private final class 4
    extends SimpleAction {
        public void perform() {
            ArrayPanel.this.applyLengthFromControls();
        }

        /* synthetic */ 4(String $0) {
            super($0);
        }
    }
}

