/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.filter;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XNumber;
import edu.neu.ccs.filter.BoundFilter;
import edu.neu.ccs.filter.FilterException;

public class MaximumBoundFilter
extends BoundFilter {
    public static final String MAXIMUM = "maximum";

    public MaximumBoundFilter(boolean isInclusive) {
        super(isInclusive);
    }

    public static class Long
    extends MaximumBoundFilter {
        protected long maximum = 0L;

        public Long(long max) {
            this(max, true);
        }

        public Long(long max, boolean isInclusive) {
            super(isInclusive);
            this.setMaximum(max);
        }

        public Stringable filterStringable(Stringable obj) throws FilterException {
            XNumber n = (XNumber)super.filterStringable(obj);
            long l = n.longValue();
            if (l < this.getMaximum() || this.isInclusive() && l == this.getMaximum()) {
                return obj;
            }
            String message = "Value not within the range [inf. ,";
            message = String.valueOf(message) + this.getMaximum() + (super.isInclusive() ? "]" : ")");
            throw new FilterException(obj, message);
        }

        public void setMaximum(long max) {
            long oldMax = this.getMaximum();
            this.maximum = max;
            if (this.getMaximum() != oldMax) {
                this.changeAdapter.firePropertyChange(MaximumBoundFilter.MAXIMUM, new java.lang.Long(oldMax), new java.lang.Long(this.getMaximum()));
            }
        }

        public long getMaximum() {
            return this.maximum;
        }
    }

    public static class Double
    extends MaximumBoundFilter {
        protected double maximum = 0.0;

        public Double(double max) {
            this(max, true);
        }

        public Double(double max, boolean isInclusive) {
            super(isInclusive);
            this.setMaximum(max);
        }

        public Stringable filterStringable(Stringable obj) throws FilterException {
            XNumber n = (XNumber)super.filterStringable(obj);
            double d = n.doubleValue();
            if (d < this.getMaximum() || this.isInclusive() && d == this.getMaximum()) {
                return obj;
            }
            String message = "Value not within the range [inf. ,";
            message = String.valueOf(message) + this.getMaximum() + (super.isInclusive() ? "]" : ")");
            throw new FilterException(obj, message);
        }

        public void setMaximum(double max) {
            double oldMax = this.getMaximum();
            this.maximum = max;
            if (this.getMaximum() != oldMax) {
                this.changeAdapter.firePropertyChange(MaximumBoundFilter.MAXIMUM, new java.lang.Double(oldMax), new java.lang.Double(this.getMaximum()));
            }
        }

        public double getMaximum() {
            return this.maximum;
        }
    }

    public static class BigInteger
    extends MaximumBoundFilter {
        protected java.math.BigInteger maximum = null;

        public BigInteger(java.math.BigInteger max) {
            this(max, true);
        }

        public BigInteger(java.math.BigInteger max, boolean isInclusive) {
            super(isInclusive);
            this.setMaximum(max);
        }

        public Stringable filterStringable(Stringable obj) throws FilterException {
            XNumber n = (XNumber)super.filterStringable(obj);
            java.math.BigInteger b = new java.math.BigInteger(new java.lang.Long(n.longValue()).toString());
            if (b.compareTo(this.getMaximum()) < 0 || this.isInclusive() && b.compareTo(this.getMaximum()) == 0) {
                return obj;
            }
            String message = "Value not within the range [inf. ,";
            message = String.valueOf(message) + this.getMaximum() + (super.isInclusive() ? "]" : ")");
            throw new FilterException(obj, message);
        }

        public void setMaximum(java.math.BigInteger max) {
            if (max == null) {
                return;
            }
            java.math.BigInteger oldMax = this.getMaximum();
            this.maximum = max;
            if (!this.getMaximum().equals(oldMax)) {
                this.changeAdapter.firePropertyChange(MaximumBoundFilter.MAXIMUM, oldMax, this.getMaximum());
            }
        }

        public java.math.BigInteger getMaximum() {
            return this.maximum;
        }
    }

    public static class BigDecimal
    extends MaximumBoundFilter {
        protected java.math.BigDecimal maximum = null;

        public BigDecimal(java.math.BigDecimal max) {
            this(max, true);
        }

        public BigDecimal(java.math.BigDecimal max, boolean isInclusive) {
            super(isInclusive);
            this.setMaximum(max);
        }

        public Stringable filterStringable(Stringable obj) throws FilterException {
            XNumber n = (XNumber)super.filterStringable(obj);
            java.math.BigDecimal d = new java.math.BigDecimal(n.doubleValue());
            if (d.compareTo(this.getMaximum()) < 0 || this.isInclusive() && d.compareTo(this.getMaximum()) == 0) {
                return obj;
            }
            String message = "Value not within the range [inf. ,";
            message = String.valueOf(message) + this.getMaximum() + (super.isInclusive() ? "]" : ")");
            throw new FilterException(obj, message);
        }

        public void setMaximum(java.math.BigDecimal max) {
            if (max == null) {
                return;
            }
            java.math.BigDecimal oldMax = this.getMaximum();
            this.maximum = max;
            if (!this.getMaximum().equals(oldMax)) {
                this.changeAdapter.firePropertyChange(MaximumBoundFilter.MAXIMUM, oldMax, this.getMaximum());
            }
        }

        public java.math.BigDecimal getMaximum() {
            return this.maximum;
        }
    }
}

