/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.console;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XBigDecimal;
import edu.neu.ccs.XBigInteger;
import edu.neu.ccs.XBoolean;
import edu.neu.ccs.XByte;
import edu.neu.ccs.XChar;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XFloat;
import edu.neu.ccs.XInt;
import edu.neu.ccs.XLong;
import edu.neu.ccs.XObject;
import edu.neu.ccs.XShort;
import edu.neu.ccs.XString;
import edu.neu.ccs.console.ConsoleInputListener;
import edu.neu.ccs.console.ConsoleWindow;
import edu.neu.ccs.filter.CaseActionFilter;
import edu.neu.ccs.filter.FilterException;
import edu.neu.ccs.filter.StringableFilter;
import edu.neu.ccs.util.JPTConstants;
import edu.neu.ccs.util.StringableFactory;
import edu.neu.ccs.util.SystemUtilities;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import javax.swing.event.SwingPropertyChangeSupport;

public class ConsoleGateway
implements ConsoleInputListener,
JPTConstants,
Serializable {
    private static final int OUT = 0;
    private static final int ERR = 1;
    private static final int IN = 2;
    public static final String ACTIVATED = "activated";
    public static final String INPUT_COLOR = "input.color";
    public static final String OUTPUT_COLOR = "output.color";
    public static final String ERROR_COLOR = "error.color";
    protected SwingPropertyChangeSupport changeAdapter = new SwingPropertyChangeSupport(this);
    protected CaseActionFilter action = null;
    protected String input = "";
    protected transient InputStream inStream = null;
    protected transient OutputStream[] outStreams = null;
    protected transient String endl = null;
    protected ConsoleWindow window = null;
    public ConsoleInputStream in = new ConsoleInputStream();
    public PrintStream out = new PrintStream(new ConsoleOutputStream(0));
    public PrintStream err = new PrintStream(new ConsoleOutputStream(1));
    static /* synthetic */ Class class$edu$neu$ccs$XInt;
    static /* synthetic */ Class class$edu$neu$ccs$XByte;
    static /* synthetic */ Class class$edu$neu$ccs$XShort;
    static /* synthetic */ Class class$edu$neu$ccs$XLong;
    static /* synthetic */ Class class$edu$neu$ccs$XFloat;
    static /* synthetic */ Class class$edu$neu$ccs$XDouble;
    static /* synthetic */ Class class$edu$neu$ccs$XChar;
    static /* synthetic */ Class class$edu$neu$ccs$XBoolean;
    static /* synthetic */ Class class$edu$neu$ccs$XString;
    static /* synthetic */ Class class$edu$neu$ccs$XBigInteger;
    static /* synthetic */ Class class$edu$neu$ccs$XBigDecimal;

    public ConsoleGateway() {
        this.inStream = System.in;
        this.outStreams = new OutputStream[]{System.out, System.err};
        this.endl = SystemUtilities.getLineSeparator();
    }

    public synchronized void consoleInputPerformed(String text) {
        this.input = text.substring(0, text.indexOf(this.endl));
        this.notify();
    }

    public synchronized void prompt(String text) {
        if (text != null && text.length() > 0) {
            this.out.print(String.valueOf(text) + " ");
        }
    }

    public synchronized void prompt(String text, String response) {
        this.prompt(text);
        if (response != null && response.length() > 0) {
            this.out.print("[" + response + "] ");
        }
    }

    public synchronized void pressReturn() {
        this.pressReturn(null);
    }

    public synchronized void pressReturn(String prompt) {
        if (prompt != null && prompt.length() > 0) {
            this.out.println(prompt);
        }
        this.prompt("Press return to continue");
        this.getOneLine();
    }

    public synchronized boolean confirm(String text, boolean response) {
        String responseString = response ? "Y" : "N";
        String reply = "";
        while ((reply = this.in.demandString(text, responseString)).length() != 0) {
            if (Character.toUpperCase(reply.charAt(0)) == 'Y') {
                response = true;
                break;
            }
            if (Character.toUpperCase(reply.charAt(0)) == 'N') {
                response = false;
                break;
            }
            this.out.println("Must answer Y[es] or N[o].");
            this.out.println();
        }
        return response;
    }

    public synchronized void setCaseActionFilter(CaseActionFilter filter) {
        this.action = filter;
    }

    public synchronized CaseActionFilter getCaseActionFilter() {
        return this.action;
    }

    public synchronized void setActivated(boolean isActivated) {
        boolean oldActivated = this.isActivated();
        if (isActivated && !this.isActivated()) {
            this.window = new ConsoleWindow();
            ((Component)this.window).setVisible(true);
        } else if (!isActivated && this.isActivated()) {
            ConsoleWindow temp = this.window;
            this.window = null;
            temp.close();
        }
        if (this.isActivated() != oldActivated) {
            this.changeAdapter.firePropertyChange(ACTIVATED, oldActivated, this.isActivated());
        }
    }

    public synchronized boolean isActivated() {
        return this.window != null;
    }

    public synchronized void setInputColor(Color input) {
        if (this.isActivated()) {
            Color oldColor = this.getInputColor();
            this.window.setInputColor(input);
            this.changeAdapter.firePropertyChange(INPUT_COLOR, oldColor, this.getInputColor());
        }
    }

    public synchronized Color getInputColor() {
        if (this.isActivated()) {
            return this.window.getInputColor();
        }
        return null;
    }

    public synchronized void setOutputColor(Color output) {
        if (this.isActivated()) {
            Color oldColor = this.getOutputColor();
            this.window.setOutputColor(output);
            this.changeAdapter.firePropertyChange(OUTPUT_COLOR, oldColor, this.getOutputColor());
        }
    }

    public synchronized Color getOutputColor() {
        if (this.isActivated()) {
            return this.window.getOutputColor();
        }
        return null;
    }

    public synchronized void setErrorColor(Color error) {
        if (this.isActivated()) {
            Color oldColor = this.getErrorColor();
            this.window.setErrorColor(error);
            this.changeAdapter.firePropertyChange(ERROR_COLOR, oldColor, this.getErrorColor());
        }
    }

    public synchronized Color getErrorColor() {
        if (this.isActivated()) {
            return this.window.getErrorColor();
        }
        return null;
    }

    public synchronized void selectBlackTextScheme() {
        this.setOutputColor(Color.black);
        this.setInputColor(Color.black);
        this.setErrorColor(Color.black);
    }

    public synchronized void selectColorTextScheme() {
        this.setOutputColor(Color.black);
        this.setInputColor(Color.blue);
        this.setErrorColor(Color.red);
    }

    public void setFontSize(int size) {
        if (this.isActivated()) {
            this.window.setFontSize(size);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(propertyName, listener);
    }

    protected synchronized String getOneLine() {
        block14: {
            if (this.isActivated()) {
                this.input = null;
                this.window.setInputMode(true);
                try {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    Object var2_1 = null;
                    if (this.input == null) {
                        this.input = "";
                    }
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    if (this.input == null) {
                        this.input = "";
                    }
                    throw throwable;
                }
                this.window.setInputMode(false);
            } else {
                StringBuffer buffer = new StringBuffer("");
                while (buffer.toString().indexOf(this.endl) < 0) {
                    try {
                        int ch = this.inStream.read();
                        if (ch < 0) {
                            buffer.append(this.endl);
                            continue;
                        }
                        buffer.append((char)ch);
                    }
                    catch (IOException iOException) {
                        buffer.append(this.endl);
                    }
                }
                this.input = buffer.toString();
                this.input = this.input.substring(0, this.input.indexOf(this.endl));
            }
            if (this.action == null) break block14;
            try {
                XString x = (XString)this.action.filterStringable(new XString(this.input));
                this.input = x.getValue();
            }
            catch (FilterException filterException) {}
        }
        return this.input;
    }

    protected String getLineSeparator() {
        return this.endl;
    }

    protected void flush(int stream) throws IOException {
        if (!this.isActivated()) {
            this.outStreams[stream].flush();
        }
    }

    protected void write(String text, int stream) {
        if (text == null) {
            return;
        }
        if (this.isActivated()) {
            this.window.consoleOutputPerformed(text, stream);
        } else {
            try {
                this.outStreams[stream].write(text.getBytes());
            }
            catch (IOException ex) {
                System.err.print("Could not write to ");
                switch (stream) {
                    case 1: {
                        System.err.print("error");
                        break;
                    }
                    default: {
                        System.err.print("output");
                    }
                }
                System.err.println(" stream.");
                ex.printStackTrace();
            }
            try {
                this.outStreams[stream].flush();
            }
            catch (IOException ex) {
                System.err.print("Could not flush ");
                switch (stream) {
                    case 1: {
                        System.err.print("error");
                        break;
                    }
                    default: {
                        System.err.print("output");
                    }
                }
                System.err.println(" stream.");
                ex.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public class ConsoleInputStream
    implements Serializable {
        protected StringableFactory factory = new StringableFactory(class$edu$neu$ccs$XInt != null ? class$edu$neu$ccs$XInt : (class$edu$neu$ccs$XInt = ConsoleGateway.class$("edu.neu.ccs.XInt")));

        public void setDataType(Class c) {
            this.factory.setDataType(c);
        }

        public Class getDataType() {
            return this.factory.getDataType();
        }

        public void demand(String prompt, Stringable obj) {
            this.demand(prompt, null, obj, null);
        }

        public void demand(String prompt, Stringable obj, StringableFilter filter) {
            this.demand(prompt, null, obj, filter);
        }

        public void demand(String prompt, String defaultData, Stringable obj) {
            this.demand(prompt, defaultData, obj, null);
        }

        public void demand(String prompt, String defaultData, Stringable obj, StringableFilter filter) {
            while (true) {
                ConsoleGateway.this.prompt(prompt, defaultData);
                String inputData = ConsoleGateway.this.getOneLine();
                if (inputData.length() == 0 && defaultData != null) {
                    inputData = defaultData;
                }
                try {
                    block8: {
                        try {
                            obj.fromStringData(inputData);
                            if (filter == null) break block8;
                            try {
                                obj = filter.filterStringable(obj);
                            }
                            catch (FilterException ex) {
                                throw new ParseException(ex.getMessage(), -1);
                            }
                        }
                        catch (NumberFormatException ex) {
                            throw new ParseException(ex.getMessage(), -1);
                        }
                    }
                    return;
                }
                catch (ParseException e) {
                    ConsoleGateway.this.err.println(XObject.formatErrorMessage(e, inputData));
                    continue;
                }
                break;
            }
        }

        public boolean reading(String prompt, Stringable obj) {
            return this.reading(prompt, obj, null);
        }

        public boolean reading(String prompt, Stringable obj, StringableFilter filter) {
            while (true) {
                ConsoleGateway.this.prompt(prompt);
                String inputData = ConsoleGateway.this.getOneLine();
                if (inputData.length() == 0) {
                    return false;
                }
                try {
                    block8: {
                        try {
                            obj.fromStringData(inputData);
                            if (filter == null) break block8;
                            try {
                                obj = filter.filterStringable(obj);
                            }
                            catch (FilterException ex) {
                                throw new ParseException(ex.getMessage(), -1);
                            }
                        }
                        catch (NumberFormatException ex) {
                            throw new ParseException(ex.getMessage(), -1);
                        }
                    }
                    return true;
                }
                catch (ParseException ex) {
                    ConsoleGateway.this.err.println(XObject.formatErrorMessage(ex, inputData));
                    continue;
                }
                break;
            }
        }

        public Stringable demandObject(String prompt) {
            return this.demandObject(prompt, null, null);
        }

        public Stringable demandObject(String prompt, String data) {
            return this.demandObject(prompt, data, null);
        }

        public Stringable demandObject(String prompt, String data, StringableFilter filter) {
            Stringable obj = this.factory.getDefaultInstance();
            this.demand(prompt, data, obj, filter);
            return obj;
        }

        public byte demandByte(String prompt) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XByte != null ? class$edu$neu$ccs$XByte : (class$edu$neu$ccs$XByte = ConsoleGateway.class$("edu.neu.ccs.XByte")));
            Stringable obj = this.demandObject(prompt);
            XByte x = (XByte)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public byte demandByte(String prompt, byte value) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XByte != null ? class$edu$neu$ccs$XByte : (class$edu$neu$ccs$XByte = ConsoleGateway.class$("edu.neu.ccs.XByte")));
            Stringable obj = this.demandObject(prompt, String.valueOf(value));
            XByte x = (XByte)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public byte demandByte(String prompt, byte value, StringableFilter filter) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XByte != null ? class$edu$neu$ccs$XByte : (class$edu$neu$ccs$XByte = ConsoleGateway.class$("edu.neu.ccs.XByte")));
            Stringable obj = this.demandObject(prompt, String.valueOf(value), filter);
            XByte x = (XByte)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public short demandShort(String prompt) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XShort != null ? class$edu$neu$ccs$XShort : (class$edu$neu$ccs$XShort = ConsoleGateway.class$("edu.neu.ccs.XShort")));
            Stringable obj = this.demandObject(prompt);
            XShort x = (XShort)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public short demandShort(String prompt, short value) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XShort != null ? class$edu$neu$ccs$XShort : (class$edu$neu$ccs$XShort = ConsoleGateway.class$("edu.neu.ccs.XShort")));
            Stringable obj = this.demandObject(prompt, String.valueOf(value));
            XShort x = (XShort)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public short demandShort(String prompt, short value, StringableFilter filter) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XShort != null ? class$edu$neu$ccs$XShort : (class$edu$neu$ccs$XShort = ConsoleGateway.class$("edu.neu.ccs.XShort")));
            Stringable obj = this.demandObject(prompt, String.valueOf(value), filter);
            XShort x = (XShort)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public int demandInt(String prompt) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XInt != null ? class$edu$neu$ccs$XInt : (class$edu$neu$ccs$XInt = ConsoleGateway.class$("edu.neu.ccs.XInt")));
            Stringable obj = this.demandObject(prompt);
            XInt x = (XInt)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public int demandInt(String prompt, int value) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XInt != null ? class$edu$neu$ccs$XInt : (class$edu$neu$ccs$XInt = ConsoleGateway.class$("edu.neu.ccs.XInt")));
            Stringable obj = this.demandObject(prompt, String.valueOf(value));
            XInt x = (XInt)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public int demandInt(String prompt, int value, StringableFilter filter) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XInt != null ? class$edu$neu$ccs$XInt : (class$edu$neu$ccs$XInt = ConsoleGateway.class$("edu.neu.ccs.XInt")));
            Stringable obj = this.demandObject(prompt, String.valueOf(value), filter);
            XInt x = (XInt)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public long demandLong(String prompt) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XLong != null ? class$edu$neu$ccs$XLong : (class$edu$neu$ccs$XLong = ConsoleGateway.class$("edu.neu.ccs.XLong")));
            Stringable obj = this.demandObject(prompt);
            XLong x = (XLong)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public long demandLong(String prompt, long value) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XLong != null ? class$edu$neu$ccs$XLong : (class$edu$neu$ccs$XLong = ConsoleGateway.class$("edu.neu.ccs.XLong")));
            Stringable obj = this.demandObject(prompt, String.valueOf(value));
            XLong x = (XLong)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public long demandLong(String prompt, long value, StringableFilter filter) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XLong != null ? class$edu$neu$ccs$XLong : (class$edu$neu$ccs$XLong = ConsoleGateway.class$("edu.neu.ccs.XLong")));
            Stringable obj = this.demandObject(prompt, String.valueOf(value), filter);
            XLong x = (XLong)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public float demandFloat(String prompt) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XFloat != null ? class$edu$neu$ccs$XFloat : (class$edu$neu$ccs$XFloat = ConsoleGateway.class$("edu.neu.ccs.XFloat")));
            Stringable obj = this.demandObject(prompt);
            XFloat x = (XFloat)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public float demandFloat(String prompt, float value) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XFloat != null ? class$edu$neu$ccs$XFloat : (class$edu$neu$ccs$XFloat = ConsoleGateway.class$("edu.neu.ccs.XFloat")));
            Stringable obj = this.demandObject(prompt, String.valueOf(value));
            XFloat x = (XFloat)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public float demandFloat(String prompt, float value, StringableFilter filter) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XFloat != null ? class$edu$neu$ccs$XFloat : (class$edu$neu$ccs$XFloat = ConsoleGateway.class$("edu.neu.ccs.XFloat")));
            Stringable obj = this.demandObject(prompt, String.valueOf(value), filter);
            XFloat x = (XFloat)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public double demandDouble(String prompt) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XDouble != null ? class$edu$neu$ccs$XDouble : (class$edu$neu$ccs$XDouble = ConsoleGateway.class$("edu.neu.ccs.XDouble")));
            Stringable obj = this.demandObject(prompt);
            XDouble x = (XDouble)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public double demandDouble(String prompt, double value) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XDouble != null ? class$edu$neu$ccs$XDouble : (class$edu$neu$ccs$XDouble = ConsoleGateway.class$("edu.neu.ccs.XDouble")));
            Stringable obj = this.demandObject(prompt, String.valueOf(value));
            XDouble x = (XDouble)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public double demandDouble(String prompt, double value, StringableFilter filter) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XDouble != null ? class$edu$neu$ccs$XDouble : (class$edu$neu$ccs$XDouble = ConsoleGateway.class$("edu.neu.ccs.XDouble")));
            Stringable obj = this.demandObject(prompt, String.valueOf(value), filter);
            XDouble x = (XDouble)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public char demandChar(String prompt) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XChar != null ? class$edu$neu$ccs$XChar : (class$edu$neu$ccs$XChar = ConsoleGateway.class$("edu.neu.ccs.XChar")));
            Stringable obj = this.demandObject(prompt);
            XChar x = (XChar)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public char demandChar(String prompt, char value) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XChar != null ? class$edu$neu$ccs$XChar : (class$edu$neu$ccs$XChar = ConsoleGateway.class$("edu.neu.ccs.XChar")));
            Stringable obj = this.demandObject(prompt, String.valueOf(value));
            XChar x = (XChar)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public char demandChar(String prompt, char value, StringableFilter filter) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XChar != null ? class$edu$neu$ccs$XChar : (class$edu$neu$ccs$XChar = ConsoleGateway.class$("edu.neu.ccs.XChar")));
            Stringable obj = this.demandObject(prompt, String.valueOf(value), filter);
            XChar x = (XChar)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public boolean demandBoolean(String prompt) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XBoolean != null ? class$edu$neu$ccs$XBoolean : (class$edu$neu$ccs$XBoolean = ConsoleGateway.class$("edu.neu.ccs.XBoolean")));
            Stringable obj = this.demandObject(prompt);
            XBoolean x = (XBoolean)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public boolean demandBoolean(String prompt, boolean value) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XBoolean != null ? class$edu$neu$ccs$XBoolean : (class$edu$neu$ccs$XBoolean = ConsoleGateway.class$("edu.neu.ccs.XBoolean")));
            Stringable obj = this.demandObject(prompt, String.valueOf(value));
            XBoolean x = (XBoolean)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public boolean demandBoolean(String prompt, boolean value, StringableFilter filter) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XBoolean != null ? class$edu$neu$ccs$XBoolean : (class$edu$neu$ccs$XBoolean = ConsoleGateway.class$("edu.neu.ccs.XBoolean")));
            Stringable obj = this.demandObject(prompt, String.valueOf(value), filter);
            XBoolean x = (XBoolean)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public String demandString(String prompt) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XString != null ? class$edu$neu$ccs$XString : (class$edu$neu$ccs$XString = ConsoleGateway.class$("edu.neu.ccs.XString")));
            Stringable obj = this.demandObject(prompt);
            XString x = (XString)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public String demandString(String prompt, String defaultText) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XString != null ? class$edu$neu$ccs$XString : (class$edu$neu$ccs$XString = ConsoleGateway.class$("edu.neu.ccs.XString")));
            Stringable obj = this.demandObject(prompt, defaultText);
            XString x = (XString)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public String demandString(String prompt, String defaultText, StringableFilter filter) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XString != null ? class$edu$neu$ccs$XString : (class$edu$neu$ccs$XString = ConsoleGateway.class$("edu.neu.ccs.XString")));
            Stringable obj = this.demandObject(prompt, defaultText, filter);
            XString x = (XString)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public BigInteger demandBigInteger(String prompt) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XBigInteger != null ? class$edu$neu$ccs$XBigInteger : (class$edu$neu$ccs$XBigInteger = ConsoleGateway.class$("edu.neu.ccs.XBigInteger")));
            Stringable obj = this.demandObject(prompt);
            XBigInteger x = (XBigInteger)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public BigInteger demandBigInteger(String prompt, BigInteger value) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XBigInteger != null ? class$edu$neu$ccs$XBigInteger : (class$edu$neu$ccs$XBigInteger = ConsoleGateway.class$("edu.neu.ccs.XBigInteger")));
            Stringable obj = this.demandObject(prompt, String.valueOf(String.valueOf(value)));
            XBigInteger x = (XBigInteger)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public BigInteger demandBigInteger(String prompt, BigInteger value, StringableFilter filter) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XBigInteger != null ? class$edu$neu$ccs$XBigInteger : (class$edu$neu$ccs$XBigInteger = ConsoleGateway.class$("edu.neu.ccs.XBigInteger")));
            Stringable obj = this.demandObject(prompt, String.valueOf(String.valueOf(value)), filter);
            XBigInteger x = (XBigInteger)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public BigDecimal demandBigDecimal(String prompt) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XBigDecimal != null ? class$edu$neu$ccs$XBigDecimal : (class$edu$neu$ccs$XBigDecimal = ConsoleGateway.class$("edu.neu.ccs.XBigDecimal")));
            Stringable obj = this.demandObject(prompt);
            XBigDecimal x = (XBigDecimal)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public BigDecimal demandBigDecimal(String prompt, BigDecimal value) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XBigDecimal != null ? class$edu$neu$ccs$XBigDecimal : (class$edu$neu$ccs$XBigDecimal = ConsoleGateway.class$("edu.neu.ccs.XBigDecimal")));
            Stringable obj = this.demandObject(prompt, String.valueOf(String.valueOf(value)));
            XBigDecimal x = (XBigDecimal)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }

        public BigDecimal demandBigDecimal(String prompt, BigDecimal value, StringableFilter filter) {
            Class oldClass = this.getDataType();
            this.setDataType(class$edu$neu$ccs$XBigDecimal != null ? class$edu$neu$ccs$XBigDecimal : (class$edu$neu$ccs$XBigDecimal = ConsoleGateway.class$("edu.neu.ccs.XBigDecimal")));
            Stringable obj = this.demandObject(prompt, String.valueOf(String.valueOf(value)), filter);
            XBigDecimal x = (XBigDecimal)obj;
            this.setDataType(oldClass);
            return x.getValue();
        }
    }

    public class ConsoleOutputStream
    extends OutputStream {
        private int stream = 0;

        public ConsoleOutputStream(int destination) {
            this.stream = destination;
        }

        public void close() {
        }

        public void flush() throws IOException {
            ConsoleGateway.this.flush(this.stream);
        }

        public void write(byte[] b) {
            ConsoleGateway.this.write(new String(b), this.stream);
        }

        public void write(byte[] b, int offset, int length) {
            ConsoleGateway.this.write(new String(b, offset, length), this.stream);
        }

        public void write(int b) {
            ConsoleGateway.this.write(String.valueOf((char)b), this.stream);
        }
    }
}

