/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.codec;

import edu.neu.ccs.codec.Codec;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Vector;

public final class EscapedCodec
implements Codec,
Serializable {
    private static final String SEPARATOR = ",";
    private static final String ESCAPE = "\\";
    private static final String NULL = "\u0000";

    public String encode(String[] data) {
        if (data == null) {
            return NULL;
        }
        String s = "";
        int i = 0;
        while (i < data.length) {
            s = String.valueOf(s) + this.escape(data[i]) + SEPARATOR;
            ++i;
        }
        return s;
    }

    public String[] decode(String data) throws ParseException {
        if (data == null) {
            return null;
        }
        if (data.equals(NULL)) {
            return null;
        }
        Vector<String> elements = new Vector<String>();
        boolean esc = false;
        StringBuffer current = new StringBuffer();
        int i = 0;
        while (i < data.length()) {
            if (data.indexOf(ESCAPE, i) == i) {
                if (esc) {
                    esc = false;
                    current.append(ESCAPE);
                } else {
                    esc = true;
                }
                i += ESCAPE.length();
                continue;
            }
            if (data.indexOf(SEPARATOR, i) == i) {
                if (esc) {
                    current.append(SEPARATOR);
                } else {
                    if (current.toString().equals(NULL)) {
                        elements.add(null);
                    } else {
                        elements.add(current.toString());
                    }
                    current.delete(0, current.length());
                }
                esc = false;
                i += SEPARATOR.length();
                continue;
            }
            if (esc) {
                current.append(ESCAPE);
            }
            current.append(data.charAt(i++));
            esc = false;
        }
        return elements.toArray(new String[0]);
    }

    public String getPrefix() {
        return "ESC";
    }

    private String escape(String data) {
        if (data == null) {
            return NULL;
        }
        StringBuffer buffer = new StringBuffer(data.length());
        int i = 0;
        while (i < data.length()) {
            if (data.indexOf(SEPARATOR, i) == i) {
                buffer.append(ESCAPE);
                buffer.append(SEPARATOR);
                i += SEPARATOR.length();
                continue;
            }
            if (data.indexOf(ESCAPE, i) == i) {
                buffer.append(ESCAPE);
                buffer.append(ESCAPE);
                i += ESCAPE.length();
                continue;
            }
            buffer.append(data.charAt(i++));
        }
        return buffer.toString();
    }
}

