/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.codec;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XObject;
import edu.neu.ccs.codec.Codec;
import edu.neu.ccs.codec.CountPrefixCodec;
import edu.neu.ccs.codec.EscapedCodec;
import edu.neu.ccs.util.JPTError;
import java.text.ParseException;
import java.util.Hashtable;

public class CodecUtilities {
    private static Hashtable codecs = null;

    public static String[] decode(String data) {
        if (!CodecUtilities.areCodecsInstalled()) {
            CodecUtilities.installStandardCodecs();
        }
        if (data.length() < 3) {
            throw new JPTError("Data is not valid encoded data: " + data);
        }
        String id = data.substring(0, 3);
        data = data.substring(3);
        Codec c = (Codec)codecs.get(id);
        if (c == null) {
            throw new JPTError("Codec identifier not recognized: " + id);
        }
        try {
            return c.decode(data);
        }
        catch (ParseException ex) {
            throw new JPTError("Parse exception while decoding data: " + ex.getMessage());
        }
    }

    public static String encode(String[] data) {
        return CodecUtilities.encode(data, CodecUtilities.getDefaultCodec());
    }

    public static String encode(String[] data, String codecID) {
        Codec c;
        if (!CodecUtilities.areCodecsInstalled()) {
            CodecUtilities.installStandardCodecs();
        }
        if ((c = (Codec)codecs.get(codecID)) == null) {
            throw new JPTError("Codec identifier not recognized: " + codecID);
        }
        return String.valueOf(c.getPrefix()) + c.encode(data);
    }

    public static String encode(Stringable[] data) {
        return CodecUtilities.encode(data, CodecUtilities.getDefaultCodec());
    }

    public static String encode(Stringable[] data, String codecID) {
        return CodecUtilities.encode(XObject.toStringArray(data), codecID);
    }

    public static String getDefaultCodec() {
        if (!CodecUtilities.areCodecsInstalled()) {
            CodecUtilities.installStandardCodecs();
        }
        return "CPC";
    }

    public static void installCodec(Codec c) {
        codecs.put(c.getPrefix(), c);
    }

    private static boolean areCodecsInstalled() {
        return codecs != null;
    }

    private static void installStandardCodecs() {
        codecs = new Hashtable();
        CodecUtilities.installCodec(new CountPrefixCodec());
        CodecUtilities.installCodec(new EscapedCodec());
    }
}

