/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XNumber;
import edu.neu.ccs.XObject;
import edu.neu.ccs.parser.Parser;
import edu.neu.ccs.parser.ParserUtilities;
import java.text.ParseException;

public class XLong
extends XNumber {
    private long value = 0L;

    public XLong() {
    }

    public XLong(long v) {
        this.value = v;
    }

    public XLong(String s) throws ParseException {
        this.fromStringData(s);
    }

    public void fromStringData(String data) throws ParseException {
        long oldValue = this.value;
        Parser p = ParserUtilities.getDefaultParser();
        Object obj = p.parse(data);
        if (!(obj instanceof XNumber)) {
            throw new ParseException("Expected numeric value.", data.length());
        }
        XNumber n = (XNumber)obj;
        this.value = n.longValue();
        this.changeAdapter.firePropertyChange("value", new Long(oldValue), data);
    }

    public String toStringData() {
        return String.valueOf(this.value);
    }

    public byte byteValue() {
        if (this.getValue() > 127L || this.getValue() < -128L) {
            throw new NumberFormatException("Number beyond precision of a byte.");
        }
        return (byte)this.getValue();
    }

    public short shortValue() {
        if (this.getValue() > 32767L || this.getValue() < -32768L) {
            throw new NumberFormatException("Number beyond precision of a short.");
        }
        return (short)this.getValue();
    }

    public int intValue() {
        if (this.getValue() > Integer.MAX_VALUE || this.getValue() < Integer.MIN_VALUE) {
            throw new NumberFormatException("Number beyond precision of a int.");
        }
        return (int)this.getValue();
    }

    public long longValue() {
        return this.getValue();
    }

    public float floatValue() {
        return this.getValue();
    }

    public double doubleValue() {
        return this.getValue();
    }

    public boolean equals(Object other) {
        if (other instanceof XLong) {
            return this.getValue() == ((XLong)other).getValue();
        }
        return false;
    }

    public int hashCode() {
        return new Long(this.getValue()).hashCode();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public void setValue(long l) {
        long oldValue = this.value;
        this.value = l;
        if (this.getValue() != oldValue) {
            this.changeAdapter.firePropertyChange("value", new Long(oldValue), new Long(this.getValue()));
        }
    }

    public long getValue() {
        return this.value;
    }

    public static long parseLong(String s) throws NumberFormatException {
        try {
            return new XLong((String)s).value;
        }
        catch (ParseException e) {
            throw new NumberFormatException(XObject.formatErrorMessage(e, s));
        }
    }

    public static long[] toPrimitiveArray(XLong[] x) {
        if (x == null) {
            return null;
        }
        long[] temp = new long[x.length];
        int i = 0;
        while (i < temp.length) {
            if (x[i] != null) {
                temp[i] = x[i].getValue();
            }
            ++i;
        }
        return temp;
    }

    public static XLong[] toXArray(long[] a) {
        if (a == null) {
            return null;
        }
        XLong[] temp = new XLong[a.length];
        int i = 0;
        while (i < temp.length) {
            temp[i] = new XLong(a[i]);
            ++i;
        }
        return temp;
    }
}

