/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XLong;
import edu.neu.ccs.XObject;
import edu.neu.ccs.filter.FilterException;
import edu.neu.ccs.filter.RangeFilter;
import java.awt.Color;
import java.text.ParseException;
import java.util.StringTokenizer;

public class XColor
extends XObject {
    private Color color = Color.black;

    public XColor() {
    }

    public XColor(Color c) {
        this.setValue(c);
    }

    public XColor(int r, int g, int b) {
        this(new Color(r, g, b));
    }

    public XColor(int r, int g, int b, int a) {
        this(new Color(r, g, b, a));
    }

    public XColor(float r, float g, float b) {
        this(new Color(r, g, b));
    }

    public XColor(float r, float g, float b, float a) {
        this(new Color(r, g, b, a));
    }

    public XColor(String s) throws ParseException {
        this.fromStringData(s);
    }

    public void fromStringData(String data) throws ParseException {
        if (data == null) {
            throw new ParseException("Input was null.", -1);
        }
        StringTokenizer tokenizer = new StringTokenizer(data, ", ");
        int arraysize = tokenizer.countTokens();
        if (arraysize < 3 || arraysize > 4) {
            throw new ParseException("Expected 3 or 4 component values.", data.length());
        }
        String[] component = new String[arraysize];
        int i = 0;
        while (i < arraysize) {
            component[i] = tokenizer.nextToken();
            ++i;
        }
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 255;
        try {
            RangeFilter.Long filter = new RangeFilter.Long(0L, 255L);
            XLong R = (XLong)filter.filterStringable(new XLong(component[0]));
            r = (int)R.getValue();
            XLong G = (XLong)filter.filterStringable(new XLong(component[1]));
            g = (int)G.getValue();
            XLong B = (XLong)filter.filterStringable(new XLong(component[2]));
            b = (int)B.getValue();
            if (arraysize == 4) {
                XLong A = (XLong)filter.filterStringable(new XLong(component[3]));
                a = (int)A.getValue();
            }
        }
        catch (NumberFormatException ex) {
            throw new ParseException(ex.getMessage(), -1);
        }
        catch (FilterException ex) {
            throw new ParseException(ex.getMessage(), -1);
        }
        this.setValue(r, g, b, a);
    }

    public String toStringData() {
        int r = this.color.getRed();
        int g = this.color.getGreen();
        int b = this.color.getBlue();
        int a = this.color.getAlpha();
        if (a == 255) {
            return String.valueOf(r) + ", " + g + ", " + b;
        }
        return String.valueOf(r) + ", " + g + ", " + b + ", " + a;
    }

    public boolean equals(Object other) {
        if (other instanceof XColor) {
            return this.getValue().equals(((XColor)other).getValue());
        }
        return this.getValue().equals(other);
    }

    public int hashCode() {
        return this.color.hashCode();
    }

    public String toString() {
        return this.toStringData();
    }

    public void setValue(Color c) {
        Color oldValue = this.color;
        if (c == null) {
            c = Color.black;
        }
        this.color = c;
        if (!this.getValue().equals(oldValue)) {
            this.changeAdapter.firePropertyChange("value", oldValue, this.getValue());
        }
    }

    public void setValue(int r, int g, int b) {
        this.setValue(new Color(r, g, b));
    }

    public void setValue(int r, int g, int b, int a) {
        this.setValue(new Color(r, g, b, a));
    }

    public void setValue(float r, float g, float b) {
        this.setValue(new Color(r, g, b));
    }

    public void setValue(float r, float g, float b, float a) {
        this.setValue(new Color(r, g, b, a));
    }

    public Color getValue() {
        return this.color;
    }

    public static Color parseColor(String data) throws NumberFormatException {
        try {
            return new XColor((String)data).color;
        }
        catch (ParseException e) {
            throw new NumberFormatException(XObject.formatErrorMessage(e, data));
        }
    }

    public static Color[] toPrimitiveArray(XColor[] x) {
        if (x == null) {
            return null;
        }
        Color[] temp = new Color[x.length];
        int i = 0;
        while (i < temp.length) {
            if (x[i] != null) {
                temp[i] = x[i].getValue();
            }
            ++i;
        }
        return temp;
    }

    public static XColor[] toXArray(Color[] a) {
        if (a == null) {
            return null;
        }
        XColor[] temp = new XColor[a.length];
        int i = 0;
        while (i < temp.length) {
            if (a[i] != null) {
                temp[i] = new XColor(a[i]);
            }
            ++i;
        }
        return temp;
    }
}

