/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XObject;
import java.text.ParseException;

public class XChar
extends XObject {
    private char value = '\u0000';

    public XChar() {
    }

    public XChar(char c) {
        this.value = c;
    }

    public XChar(String s) throws ParseException {
        this.fromStringData(s);
    }

    public void fromStringData(String data) throws ParseException {
        char oldValue = this.value;
        if (data == null) {
            throw new ParseException("Input was null.", -1);
        }
        if (data.length() == 0) {
            throw new ParseException("No input provided. ", -1);
        }
        if (data.length() > 1) {
            throw new ParseException("Provide one character only. ", 1);
        }
        this.value = data.charAt(0);
        this.changeAdapter.firePropertyChange("value", new Character(oldValue), data);
    }

    public String toStringData() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof XChar) {
            return this.getValue() == ((XChar)other).getValue();
        }
        return false;
    }

    public int hashCode() {
        return new Character(this.getValue()).hashCode();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public void setValue(char c) {
        char oldValue = this.value;
        this.value = c;
        if (this.getValue() != oldValue) {
            this.changeAdapter.firePropertyChange("value", new Character(oldValue), new Character(this.getValue()));
        }
    }

    public char getValue() {
        return this.value;
    }

    public static char parseChar(String s) throws NumberFormatException {
        try {
            return new XChar((String)s).value;
        }
        catch (ParseException e) {
            throw new NumberFormatException(XObject.formatErrorMessage(e, s));
        }
    }

    public static char[] toPrimitiveArray(XChar[] x) {
        if (x == null) {
            return null;
        }
        char[] temp = new char[x.length];
        int i = 0;
        while (i < temp.length) {
            if (x[i] != null) {
                temp[i] = x[i].getValue();
            }
            ++i;
        }
        return temp;
    }

    public static XChar[] toXArray(char[] a) {
        if (a == null) {
            return null;
        }
        XChar[] temp = new XChar[a.length];
        int i = 0;
        while (i < temp.length) {
            temp[i] = new XChar(a[i]);
            ++i;
        }
        return temp;
    }
}

