/* ------------------------------------------------------------------
   Functional (External) Iterator Pattern 
*/


class TreeRange implements IRange {

    // Use a CurrentRange to keep track of which subtree is acting
    // as the current range
    ACurrentRange currentRange;

    // Constructor
    TreeRange(AAncestorTree tree) {
    
    	if (tree instanceof ConsAncestorTree){
    	
    	    if ( ((ConsAncestorTree)tree).mother instanceof EmptyAncestorTree)
    		    this.currentRange = new CurrentSelf((ConsAncestorTree)tree);
    		    
    	    else
    		    this.currentRange = new CurrentLeft((ConsAncestorTree)tree);
    	}
    	
    	/* implements IRange for empty tree */
    	else
    	    this.currentRange = new CurrentEmpty();
    }    

    /* ------------------------------------------------------------
       Methods
       ------------------------------------------------------------ */

    // Move to the next Person in this collection
    // available: this.currentRange
    public void next () {
	    this.currentRange = this.currentRange.nextCurrentRange();
    }

    // Provide the current Person in this collection
    // available: this.currentRange
    public Object current() {
        return this.currentRange.current();
    }

    // Does this collection contain any more Persons
    // available: this.currentRange
    public boolean hasMore() {
	    return this.currentRange.hasMore();
    }
}


    

    

	
    
