import java.awt.*;

public class IRangeTests extends JPFalt 
{
    public static void main(String[] args) { new IRangeTests(); }

    /* In this client class, we will iterate over various classes that
       implement the IRange interface. Each of the classes will be some
       sort of collection of Persons */

    // Some Persons
    Person pFrank = new Person("Frank", 10, Color.blue);
    Person pJim = new Person("Jim", 40, Color.black);
    Person pMary = new Person("Mary", 35, Color.blue);
    Person pRoy = new Person("Roy", 71, Color.black);
    Person pSally = new Person("Sally", 63, Color.green);
    Person pTim =  new Person("Tim", 75, Color.black);
    Person pGertrude = new Person("Gertrude", 69, Color.black);
    Person pBen = new Person("Ben", 95, Color.blue);
    Person pJane = new Person("Jane", 85, Color.blue);

    /* sample method to print all persons in the given list */
    void printer(IRange i) { 
        console.out.print("["); 
        for(IRange r = i; r.hasMore(); r.next())
            console.out.print(" " + ((Person)r.current()).name  + " "); 
        console.out.println("]"); 
    }

    /*-------------------------------------------------------------------------
     Sample data objects 
     ------------------------------------------------------------------------*/
    AListPerson personList1 = new ConsPerson(pFrank,
			       new ConsPerson(pJim,
			        new ConsPerson(pMary,
			         new ConsPerson(pRoy,
			          new ConsPerson(pSally,
			           new ConsPerson(pTim,
			            new ConsPerson(pGertrude,
			             new ConsPerson(pBen,
			              new ConsPerson(pJane, new EmptyPerson())))))))));

    AListPerson personList2 = new ConsPerson(pTim,
		               new ConsPerson(pSally,
		                new ConsPerson(pJim,
			         new ConsPerson(pGertrude, new EmptyPerson()))));

    Object[] emptyPersonArray = new Object[]{};
    Object[] personArray1 = new Object[]{pFrank, pJim, pMary, pRoy, pSally, pTim, pGertrude, pBen, pJane};
    Object[] personArray2 = new Object[]{pFrank, pJim, pMary}; // 40

    EmptyAncestorTree mtTree = new EmptyAncestorTree();
    
    ConsAncestorTree bentree = new ConsAncestorTree(pBen, mtTree, mtTree);
    ConsAncestorTree janetree = new ConsAncestorTree(pJane, mtTree, mtTree);
    ConsAncestorTree gertrudetree = new ConsAncestorTree(pGertrude, janetree, bentree);
    ConsAncestorTree timtree = new ConsAncestorTree(pTim, mtTree, mtTree);
    ConsAncestorTree marytree = new ConsAncestorTree(pMary, gertrudetree, timtree);
    ConsAncestorTree roytree = new ConsAncestorTree(pRoy, mtTree, mtTree);
    ConsAncestorTree sallytree = new ConsAncestorTree(pSally, mtTree, mtTree);
    ConsAncestorTree jimtree = new ConsAncestorTree(pJim, sallytree, roytree);
    ConsAncestorTree franktree = new ConsAncestorTree(pFrank, marytree, jimtree);

    /* ------------------------------------------------------------
       containsBlueEyedPerson
       ------------------------------------------------------------ */

    // containsBlueEyedPerson
    // To determine if the given IRange object contains a Person with blue eyes
    // available: i.hasMore() ... i.next() ... i.current() ...
    boolean containsBlueEyedPerson(IRange i) {
    
    	for(IRange r = i; r.hasMore(); r.next()){
    	    if (((Person)r.current()).eyecolor.equals(Color.blue)) 
    	        return true;
    	}
    	
    	return false;
    }

    /*--- Tests for containsBlueEyedPerson ----------------------------------*/
    void TestContainsBlueEyedPerson() {
    	testHeader("Testing allOverEighteen");
    	
    	ListRange lr0 = new ListRange(new EmptyPerson());
    	ListRange lr1 = new ListRange(personList1);
    	ListRange lr2 = new ListRange(personList2);

    	println("\n Test with empty ListRange");
    	expected(false);
    	actual(containsBlueEyedPerson(lr0));
    	       
    	println("\n Test positive with ListRange");
    	expected(true);
    	actual(containsBlueEyedPerson(lr1));

    	println("\n Test negative with ListRange");
    	expected(false);
    	actual(containsBlueEyedPerson(lr2));

    	TreeRange tr0 = new TreeRange(new EmptyAncestorTree());
    	TreeRange tr1 = new TreeRange(jimtree);
    	TreeRange tr2 = new TreeRange(marytree);

    	println("\n Test with empty tree");
    	expected(false);
    	actual(containsBlueEyedPerson(tr0));

    	println("\n Test negative with non-empty tree");
    	expected(false);
    	actual(containsBlueEyedPerson(tr1));

    	println("\n Test positive with non-empty tree");
    	expected(true);
    	actual(containsBlueEyedPerson(tr2));
    }

    /* ------------------------------------------------------------
       allOverEighteen
       ------------------------------------------------------------ */
    
    // allOverEighteen
    // To determine if all of the Persons in the given IRange object 
    //      are over 18 years old
    // available: i.hasMore() ... i.next() ... i.current() ...
    boolean allOverEighteen(IRange i) {
    
    	for(IRange r = i; r.hasMore(); r.next()){
    	    if (((Person)r.current()).age < 18) 
    	        return false;
    	}
    	return true;
    }	   

    /*--- Tests for allOverEighteen -----------------------------------------*/
    void TestAllOverEighteen() {
    	testHeader("Testing allOverEighteen");

    	ArrayRange ar0 = new ArrayRange(new Object[]{});
    	ArrayRange ar1 = new ArrayRange(personArray1);

    	TreeRange tr0 = new TreeRange(new EmptyAncestorTree());
    	TreeRange tr1 = new TreeRange(franktree);
    	TreeRange tr2 = new TreeRange(jimtree);

    	ListRange lr0 = new ListRange(new EmptyPerson());
    	ListRange lr1 = new ListRange(personList1);
    	ListRange lr2 = new ListRange(personList2);


    	println("\n test with empty array");
    	expected(true);
    	actual(allOverEighteen(ar0));

    	println("\n test negative with array");
    	expected(false);
    	actual(allOverEighteen(ar1));

    	println("\n test with empty tree");
    	expected(true);
    	actual(allOverEighteen(tr0));

    	println("\n test negative with tree");
    	expected(false);
    	actual(allOverEighteen(tr1));

    	println("\n test positive with tree");
    	expected(true);
    	actual(allOverEighteen(tr2));

    	println("\n test with empty list");
    	expected(true);
    	actual(allOverEighteen(lr0));

    	println("\n test negative with list");
    	expected(false);
    	actual(allOverEighteen(lr1));

    	println("\n test positive with list");
    	expected(true);
    	actual(allOverEighteen(lr2));
    }


    /* ------------------------------------------------------------
       andMap
       ------------------------------------------------------------ */
    // andMap
    /*
    boolean andMap(IRange i, IPerson2Bool p2b){

      ...
	
    }
    */

    /* ------------------------------------------------------------
       orMap
       ------------------------------------------------------------
    // orMap
    /*
    boolean orMap(IRange i, IPerson2Bool p2b){

      ...
    }
    */

    /* ------------------------------------------------------------
       totalYears
       ------------------------------------------------------------ */

    // totalYears
    // To sum up all the ages of the People in the given IRangeCollection
    int totalYears(IRange i, int total) {
    	if (i.hasMore()) {
    	    {
    		int newTotal = total + ((Person)i.current()).age;
    		i.next();
    		return totalYears(i, newTotal);
    	    }
    	}
    	else
    	    return total;	    
    }



    /*--- Tests for totalYears ----------------------------------------------*/
    void TestTotalYears(){
    	testHeader("Testing totalYears");

    	ArrayRange ar0 = new ArrayRange(new Object[]{});
    	ArrayRange ar1 = new ArrayRange(personArray1);	
    	ArrayRange ar2 = new ArrayRange(personArray2);

    	TreeRange tr0 = new TreeRange(new EmptyAncestorTree());
    	TreeRange tr1 = new TreeRange(franktree);

    	ListRange lr0 = new ListRange(new EmptyPerson());
    	ListRange lr1 = new ListRange(personList1);



    	println("\n test with empty array");
    	expected(0);
    	actual(totalYears(ar0, 0));

    	println("\n test with array");
    	expected(85);
    	actual(totalYears(ar2, 0));

    	println("\n test with empty list");
    	expected(0);
    	actual(totalYears(lr0, 0));

    	println("\n test with empty tree");
    	expected(0);
    	actual(totalYears(tr0, 0));

    	println("\n the next three should all be the same");
    	println(totalYears(ar1, 0));
    	println(totalYears(tr1, 0));
    	println(totalYears(lr1, 0));
    }

}

    

