class CurrentRight extends ACurrentRange {

    // The tree hosting this CurrentLeft
    ConsAncestorTree hostTree;

    // The right subtree
    TreeRange rightRange;
    

    // Constructor
    CurrentRight(ConsAncestorTree _hostTree){
	hostTree = _hostTree;
	rightRange = new TreeRange(_hostTree.father);
    }

    /* ------------------------------------------------------------
       Methods
       ------------------------------------------------------------ */

    /* ------------------------------------------------------------
       To produce the next CurrentRange
       available: rightRange
       ------------------------------------------------------------ */
    ACurrentRange nextCurrentRange() {
	rightRange.next();
	return this;	
    }

    /* ------------------------------------------------------------
       To produce the current object in this CurrentRange
       available: rightRange
       ------------------------------------------------------------ */
    Object current() {
	return rightRange.current();
    }	

    /* ------------------------------------------------------------
       Indicate if this CurrentRange hasMore
       available: rightRange
       ------------------------------------------------------------ */
    boolean hasMore() {
	return rightRange.hasMore();
    }
}
