class CurrentLeft extends ACurrentRange {

    // The tree hosting this CurrentLeft
    ConsAncestorTree hostTree;

    // The left subtree
    TreeRange leftRange;

    // Constructor
    CurrentLeft(ConsAncestorTree _hostTree){
	hostTree = _hostTree;
	leftRange = new TreeRange(_hostTree.mother);
    }

    /* ------------------------------------------------------------
       Methods
       ------------------------------------------------------------ */

    /* ------------------------------------------------------------
       To produce the next CurrentRange
       template:
                if (this.leftRange.hasMore())
		   ... this ...
		   ... this.hostTree ...
		   ... this.leftRange.next() ...
		else
		   ... this ...
		   ... this.hostTree ...
		   ... this.leftRange.next() ...
       ------------------------------------------------------------ */
    ACurrentRange nextCurrentRange() {
	if (this.leftRange.hasMore())
	    this.leftRange.next();

	if (this.leftRange.hasMore())
	    return this;
	else
	    return new CurrentSelf(this.hostTree);
    }

    /* ------------------------------------------------------------
       To produce the current object in this CurrentRange
       available: this.leftRange.current();
       ------------------------------------------------------------ */
    Object current() {
	return this.leftRange.current();
    }

    /* ------------------------------------------------------------
       Indicate if this CurrentRange hasMore
       ------------------------------------------------------------ */    
    boolean hasMore() {
	return true;
    }
}
