class ConsPerson extends AListPerson {

    // The first Person in the list
    Person first;

    // The remaining Persons in the list
    AListPerson rest;

    // constructor
    ConsPerson (Person _first, AListPerson _rest){
	this.first = _first;
	this.rest = _rest;
    }

    // insert
    // To insert a person into this list
    // assume list is sorted
    // template:
    //          if (p.age < this.first.age)
    //            ... this.first ... this.rest ... this.rest.insert(p) ...
    //          else
    //            ... this.first ... this.rest ... this.rest.insert(p) ...
    //
    AListPerson insert(Person p) {
	if (p.age < this.first.age)
	    return new ConsPerson(p, this);
	else
	    return new ConsPerson(this.first, this.rest.insert(p));
    }    

    // toString
    public String toString () {
	return "new " + getClass().getName() + "("
	    + this.first + ", " + this.rest + ")";
    }
}
