/* ------------------------------------------------------------------
   Functional (External) Iterator Pattern 
*/

class ArrayRange implements IRange {

    // The array to iterate over
    Object[] o;

    // Current index into the array
    int ptr = 0;

    // Constructor
    ArrayRange(Object[] l) { o = l; }
        
    /* ------------------------------------------------------------
       Methods
       ------------------------------------------------------------ */


    // Produce the next Person in the array
    public void next() {
        ptr = ptr+1; 
    }


    // Produce the current Person in the array
    public Object current() { 
        return o[ptr]; 
    }


    // Indicate whether there are more Persons in the array
    public boolean hasMore() { 
        return 0 <= ptr && ptr < o.length; 
    }
}
