/*
 * @(#)ConsInt.java  9 February 2003
 */

/*
 * Abstract class that defines the behavior of a cons list of int
 */

public class ConsInt extends AListInt{
    /* member data */
	int first;
	AListInt rest;
    
    /* constructor */
	ConsInt(int afirst, AListInt aRest){
		this.first = afirst;
		this.rest = aRest;
     }

    /* methods */ 
    /*--------------------------------------------------------
     mapIntToInt: converts the consumed (list of int) to (list of int)
        as prescribed by the method (int -> int)  
     consume: (int -> int) (list of int)
     produce: (list of int)
    --------------------------------------------------------*/
    AListInt mapIntToInt(IInt2Int i2i){
		return new ConsInt(i2i.apply(this.first), this.rest.mapIntToInt(i2i));
	}
   
  
    /*--------------------------------------------------------
     orMap: converts the consumed (list of int) to a boolean 
        if the method (int -> boolean) returns at least one true 
     consume: (int -> boolean) (list of int) 
     produce: boolean
    --------------------------------------------------------*/
    boolean orMapInt(IInt2Bool i2b){
		return i2b.apply(this.first) || this.rest.orMapInt(i2b);
	}
     
    /*--------------------------------------------------------
     count: counts the number of ints in this list
     consume: this
     return: int
     -------------------------------------------------------*/
    int count(){
		return 1 + this.rest.count();   
	}
	
	/*-------------------------------------------------------
     print the contents of this list
     -------------------------------------------------------*/
    public String toString(){
        return "new " + getClass().getName() + "("
               + first + ",\n\t" + rest + ")";
    }
} 