/*
 * @(#)StringClassTest.java    2 February 2003
 */

public class StringClassTest extends JPFalt{

    public static void main(String[] args) { new StringClassTest(); }

    ///////////////////////////////////////////////////////////
    // Place your test methods here.                         //
    ///////////////////////////////////////////////////////////

	/** Test suite for the class String */
    public void TestStrings(){
    
		/*---------------------------------------------------- 
    	 Define a String object and print the value.
    	----------------------------------------------------*/
    	println("\nDefine two String objects, print values.");
    	println(new String("Hello"));
    	println(new String("Good Bye!"));
    	
    	println("\nDefine two Strings and print the values.");
    	println("Hello");
    	println("Good Bye!");
    	
    	
		/*---------------------------------------------------- 
    	 Define two String objects. 
    	----------------------------------------------------*/
    	String alphabet = 
    	            new String("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    	            
    	String myName = "Bugs Bunny";
    	
    	println("\nDefine two Strings and print the values.");
    	println(alphabet);
    	println(myName);
    	
		/*---------------------------------------------------- 
    	 Test the length() method
    	----------------------------------------------------*/
    	testHeader("length()");
    	
    	expected(26);
    	actual(alphabet.length());
    	
    	expected(10);
    	actual(myName.length());
    	
    	
		/*---------------------------------------------------- 
    	 Test the charAtIndex(int someIndex) method
    	----------------------------------------------------*/
    	testHeader("charAt(int someIndex)");
    	
    	expected('A' );
    	actual(alphabet.charAt(0));
    	
    	expected('Z' );
    	actual(alphabet.charAt(25));
    	
    	expected('Z' );
    	actual(alphabet.charAt( alphabet.length() - 1 ));
    	
    	expected('B' );
    	actual(myName.charAt(0));
    	
    	
		/*---------------------------------------------------- 
    	 Test the compareTo(String someString) method
    	*
    	* Lexicographical comparison - uses dictionary rules
    	*
    	* returns int <0 if this String is before given String
    	* returns  0 if this String equals to the given String
    	* returns int >0 if this String is after given String
    	----------------------------------------------------*/
    	testHeader("compareTo(String someString)");
    	
    	expected("(value < 0)");
    	actual(alphabet.compareTo("alphabeta"));
    	
    	expected("(value < 0)");
    	actual(alphabet.compareTo("ALPHABETA"));
    	
    	expected(0);
    	actual(alphabet.compareTo("ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
    	
    	expected("(value > 0)");
    	actual(alphabet.compareTo("ABCDAAA"));
    	
    	expected(0);
    	actual(myName.compareTo("Bugs Bunny"));
    	
    	expected("(value < 0)");
    	actual(alphabet.compareTo(myName));
    	
    	expected("(value > 0)");
    	actual(myName.compareTo(alphabet));
    	    	

		/*--------------------------------------------------------------------- 
    	 Test the startsWith(String prefix) method
    	---------------------------------------------------------------------*/
    	testHeader("startsWith(String prefix)");
    	
    	expected(false);
    	actual(alphabet.startsWith("alphabeta"));
    	
    	expected(true);
    	actual(alphabet.startsWith("ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
    	
    	expected(true);
    	actual(alphabet.startsWith("ABCDEFG"));
    	
    	expected(false);
    	actual(alphabet.startsWith("ABCDAAA"));
    	
    	expected(true);
    	actual(myName.startsWith("Bugs Bunny"));
    	
    	expected(false);
    	actual(alphabet.startsWith(myName));
    	
    	expected(false);
    	actual(myName.startsWith(alphabet));

		/*--------------------------------------------------------------------- 
    	 END OD TEST SUITE FOR String class
    	---------------------------------------------------------------------*/
    }

    
}

