/*
 * @(#)EmptyInt.java  26 January 2003
 */

/*
 * A class that defines an empty list of numbers
 */

public class EmptyInt extends AListInt{
    
/*------------------------------------------------------------
 Methods required by AList
------------------------------------------------------------*/

    /*--------------------------------------------------------
     Determine whether the given object appears in this list.
     -------------------------------------------------------*/
    boolean contains(int n){
        return false;
    }
    
    /*--------------------------------------------------------
     Count the number of items in this list
     -------------------------------------------------------*/
    int count(){
        return 0;
    }
        
    
    /*--------------------------------------------------------
     Produce a sorted list from this list of numbers.
     -------------------------------------------------------*/
    AListInt sort(){
        return this;
    }    
    
    /*--------------------------------------------------------
     Insert a number into this sorted list
     -------------------------------------------------------*/
    AListInt insert(int n){
        return (new ConsInt(n, this));
    }
                                    
    /*--------------------------------------------------------
     Print this list
     -------------------------------------------------------*/
    public String toString(){
        return "*";
    }
}
    
