/*
 * @(#)ConsInt.java  26 January 2003
 */

/*
 * A class that defines the behavior of a constructed list of numbers
 */

public class ConsInt extends AListInt{

    /*--------------------------------------------------------
     Member data
     -------------------------------------------------------*/
    
    /* first item in this list */
    int first; 
    
    /* the rest of this list   */
    AListInt rest;
    
    /*--------------------------------------------------------
     Constructor
     -------------------------------------------------------*/
    public ConsInt(int n, AListInt alon){
        
        /* the first item in this list */
        first = n;
        
        /* the rest of this list */
        rest  = alon;
    }
    
    /*--------------------------------------------------------
     Determine whether the given object appears in this list.
     -------------------------------------------------------*/
    boolean contains(int n){
        return true;
    }
    
                                        
    /*--------------------------------------------------------
     Count the number of items in this list
     -------------------------------------------------------*/
    int count(){
        return (1 + rest.count());
    }
        
    /*--------------------------------------------------------
     Produce a sorted list from this list of numbers.
     -------------------------------------------------------*/
    AListInt sort(){
        return (rest.sort()).insert(first);
    }
    
    /*--------------------------------------------------------
     Insert a number into this sorted list
     -------------------------------------------------------*/
    AListInt insert(int n){
        if (n < first)
            return (new ConsInt(n, this));
        else
            return (new ConsInt(first, rest.insert(n)));
    }
    
    /*--------------------------------------------------------
     Print this list
     -------------------------------------------------------*/
    public String toString(){
        return "new " + getClass().getName() + "("
               + first + ",\n\t" + rest + ")";
    }
        
    
}
    
