/*
 * @(#)AListInt.java 26 January 2003
 */

/*
 * Abstract class that defines the behavior of a list of int
 */

public abstract class AListInt{
    
    /* data definition:
     *   List is 
     *      either empty
     *      or     structure: 
     *                 first - an integer
     *                 rest  - a List of int
     */    
     
    /*--------------------------------------------------------
     Count the number of items in this list
     -------------------------------------------------------*/
    abstract int count();
        
    /*--------------------------------------------------------
     Determine whether the given object appears in this list.
     -------------------------------------------------------*/
    abstract boolean contains(int n);
    
    /*--------------------------------------------------------
     Produce a sorted list from this list of numbers.
     -------------------------------------------------------*/
    abstract AListInt sort();
    
    /*--------------------------------------------------------
     Insert a number into a sorted list
     -------------------------------------------------------*/
    abstract AListInt insert(int n);
                                            
}
    
