/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XNumber;
import edu.neu.ccs.XObject;
import edu.neu.ccs.parser.Parser;
import edu.neu.ccs.parser.ParserUtilities;
import java.text.ParseException;

public class XInt
extends XNumber {
    private int value = 0;

    public XInt() {
    }

    public XInt(int i) {
        this.value = i;
    }

    public XInt(String s) throws ParseException {
        this.fromStringData(s);
    }

    public void fromStringData(String data) throws ParseException {
        int oldValue = this.value;
        Parser p = ParserUtilities.getDefaultParser();
        Object obj = p.parse(data);
        if (!(obj instanceof XNumber)) {
            throw new ParseException("Expected numeric value.", data.length());
        }
        XNumber n = (XNumber)obj;
        this.value = n.intValue();
        this.changeAdapter.firePropertyChange("value", new Integer(oldValue), data);
    }

    public String toStringData() {
        return String.valueOf(this.value);
    }

    public byte byteValue() {
        if (this.getValue() > 127 || this.getValue() < -128) {
            throw new NumberFormatException("Number beyond precision of a byte.");
        }
        return (byte)this.getValue();
    }

    public short shortValue() {
        if (this.getValue() > Short.MAX_VALUE || this.getValue() < Short.MIN_VALUE) {
            throw new NumberFormatException("Number beyond precision of a short.");
        }
        return (short)this.getValue();
    }

    public int intValue() {
        return this.getValue();
    }

    public long longValue() {
        return this.getValue();
    }

    public float floatValue() {
        return this.getValue();
    }

    public double doubleValue() {
        return this.getValue();
    }

    public boolean equals(Object other) {
        if (other instanceof XInt) {
            return this.getValue() == ((XInt)other).getValue();
        }
        return false;
    }

    public int hashCode() {
        return new Integer(this.getValue()).hashCode();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public void setValue(int i) {
        int oldValue = this.value;
        this.value = i;
        if (this.getValue() != oldValue) {
            this.changeAdapter.firePropertyChange("value", new Integer(oldValue), new Integer(this.getValue()));
        }
    }

    public int getValue() {
        return this.value;
    }

    public static int parseInt(String s) throws NumberFormatException {
        try {
            return new XInt((String)s).value;
        }
        catch (ParseException e) {
            throw new NumberFormatException(XObject.formatErrorMessage(e, s));
        }
    }

    public static int[] toPrimitiveArray(XInt[] x) {
        if (x == null) {
            return null;
        }
        int[] temp = new int[x.length];
        int i = 0;
        while (i < temp.length) {
            if (x[i] != null) {
                temp[i] = x[i].getValue();
            }
            ++i;
        }
        return temp;
    }

    public static XInt[] toXArray(int[] a) {
        if (a == null) {
            return null;
        }
        XInt[] temp = new XInt[a.length];
        int i = 0;
        while (i < temp.length) {
            temp[i] = new XInt(a[i]);
            ++i;
        }
        return temp;
    }
}

