/*
 * @(#)EmptyAncestorTree.java  30 January 2003
 */

/*
 * Class that defines the behavior of an empty ancestor tree
 */
import java.awt.*;
import java.awt.geom.*;

public class EmptyAncestorTree extends AncestorTree{
        
    /*--------------------------------------------------------
     Methods required by AncestorTree
     -------------------------------------------------------*/

    /*--------------------------------------------------------
     Determine whether the given name appears in this tree.
     -------------------------------------------------------*/
    boolean contains(String aName){
        return false;
    }
        
    /********************************************************/
    /// MORE METHODS TO APPEAR HERE //////////////////////////
    /********************************************************/    



    /*--------------------------------------------------------
     Utility methods
     -------------------------------------------------------*/

    /*--------------------------------------------------------
     Print the contents of this tree
     -------------------------------------------------------*/
    public String toString(){
        return "*";
    }
    
    /*--------------------------------------------------------
     Display this tree in the given graphics context.
     -------------------------------------------------------*/
    public void showTree(int level, int minloc, int maxloc, Graphics2D g2){
    
        showNode("EMPTY", Color.red, level, minloc, maxloc, g2);
    }
    
}
    
