/*
 * @(#)ConsAncestorTree.java  30 January 2003
 */

/*
 * Class that defines the behavior of an ancestor tree
 * that is not empty
 */
import java.awt.*;
import java.awt.geom.*;
import edu.neu.ccs.*;

public class ConsAncestorTree extends AncestorTree{
    
    /*--------------------------------------------------------
     Member data
     -------------------------------------------------------*/
     
    AncestorTree father = new EmptyAncestorTree();
    AncestorTree mother = new EmptyAncestorTree();
    String         name = null;
    Color      eyeColor = null;
     
    /*--------------------------------------------------------
     Constructor
     -------------------------------------------------------*/
    ConsAncestorTree(AncestorTree myFather, 
                     AncestorTree myMother, 
                     String myName, 
                     Color myEyeColor){
    
    
        this.father   = myFather;
        this.mother   = myMother;
        this.name     = myName;
        this.eyeColor = myEyeColor;                   
    }
     
    /*--------------------------------------------------------
     Methods required by AncestorTree
     -------------------------------------------------------*/
         
    /*--------------------------------------------------------
     Determine whether the given name appears in this tree.
     -------------------------------------------------------*/
    boolean contains(String aName){
    
        // compare with the current node
        if (this.name.equals(aName))
            return true;
        
        // return    (father subtree contains)
        //        or (mother subtree contains)
        return ((this.father.contains(aName)) ||
                (this.mother.contains(aName)) );

    }
    
    /********************************************************/
    /// MORE METHODS TO APPEAR HERE //////////////////////////
    /********************************************************/    



    /*--------------------------------------------------------
     Utility methods
     -------------------------------------------------------*/

    /*--------------------------------------------------------
     Print the contents of this tree
     -------------------------------------------------------*/
    public String toString(){

        return ("[ " + this.father 
               + ", " + this.mother
               + ", " + this.name 
               + ", (" + new XColor(this.eyeColor) + ") ]");        
    }
    
    /*--------------------------------------------------------
     Display this tree in the given graphics context.
     -------------------------------------------------------*/
    public void showTree(int level, int minloc, int maxloc, Graphics2D g2){
        
        this.father.showTree(level + 1, minloc, (minloc + maxloc) / 2, g2);
        showNode(name, eyeColor, level, minloc, maxloc, g2);        
        this.mother.showTree(level + 1, (minloc + maxloc) / 2, maxloc, g2);
    }
}
    
