/* AncestorTreeTest.java  1 February 2002 */

import java.awt.*;
import java.awt.geom.*;

public class AncestorTreeTest extends JPFalt 
{
    public static void main(String[] args) { new AncestorTreeTest(); }
    
    ///////////////////////////////////////////////////////////
    // Place your actual methods here.                       //
    ///////////////////////////////////////////////////////////

	/** Test suite for the class AncestorTree */
	
	/*--------------------------------------------------------
	 Define AncestorTree objects; print member data values.
	--------------------------------------------------------*/
    void TestAncestorTree(){
    
    	AncestorTree empty = new EmptyAncestorTree();
    	println(empty);
    	
    	
    	AncestorTree carl = new ConsAncestorTree(
                	                empty,
                	                empty,
                	                "Carl", 
                	                Color.green); 
    	println(carl);

    	AncestorTree betty = new ConsAncestorTree(
                	                empty,
                	                empty,
                	                "Betty", 
                	                Color.blue); 
    	println(betty);
    	                    
    	AncestorTree ellen = new ConsAncestorTree(
                	                new ConsAncestorTree(
                        	                empty,
                        	                empty,
                                            "Joe", Color.black),
                                    new ConsAncestorTree(
                        	                empty,
                        	                empty,
                        	                "Grace", 
                        	                Color.blue),        
                	                "Ellen", 
                	                Color.blue);
    	println(ellen);

        /* Code to dipslay the tree in the graphics window */
        pressReturn("Carl");
        carl.showTree(1, 0, 400,  window.getBufferGraphics());
        window.repaint();

        pressReturn("Betty");
        betty.showTree(1, 0, 400,  window.getBufferGraphics());
        window.repaint();

        pressReturn("Ellen");
        ellen.showTree(1, 0, 400,  window.getBufferGraphics());
        window.repaint();

        pressReturn("Empty");
        empty.showTree(1, 0, 400,  window.getBufferGraphics());
        window.repaint();

    }
    
	/*------------------------------------------------------------------------- 
	 Test the findName(String aName) method
	-------------------------------------------------------------------------*/
    void TestFindName(){

    	testHeader("findName(String aName)");
    	
    	/*--------------------------------------------------------------------- 
    	 Define four AncestorTree objects. 
    	---------------------------------------------------------------------*/
    	AncestorTree empty = new EmptyAncestorTree();
    	
    	
    	AncestorTree carl = new ConsAncestorTree(
                	                empty,
                	                empty,
                	                "Carl", 
                	                Color.green); 
    	                    
    	AncestorTree betty = new ConsAncestorTree(
                	                empty,
                	                empty,
                	                "Betty", 
                	                Color.blue); 
    	                    
    	AncestorTree ellen = new ConsAncestorTree(
                	                new ConsAncestorTree(
                        	                empty,
                        	                empty,
                                            "Joe", Color.black),
                                    new ConsAncestorTree(
                        	                empty,
                        	                empty,
                        	                "Grace", 
                        	                Color.blue),        
                	                "Ellen", 
                	                Color.blue);

    	expected(true);
    	actual( carl.contains("Carl"));
    	
    	expected(false);
    	actual( ellen.contains("Carl"));
    	
    	expected(true);
    	actual( ellen.contains("Joe"));
    	
    	expected(true);
    	actual( ellen.contains("Grace"));
    	
    	expected(true);
    	actual( ellen.contains("Joe"));
    	
    }
    
	/*------------------------------------------------------------------------- 
	 Test the mean() method
	-------------------------------------------------------------------------*/
    void TestHeight(){ 	
    	
       	testHeader("height()");
    	
		/*--------------------------------------------------------------------- 
        ???????????????????????????????
    	---------------------------------------------------------------------*/
    }	
    
    
    /* ?????????????????????????? */
    	
	/*--------------------------------------------------------------------- 
	 End of test suite for class AncestorTree
	---------------------------------------------------------------------*/    
	/*--------------------------------------------------------------------- 
	 Simple test of showing text in the graphics window
	---------------------------------------------------------------------*/    
    void HelloWorld(){
    
        String s = "Hello World!";
        Graphics2D g2 = window.getBufferGraphics();
        
        g2.setFont(new Font("Courier", Font.BOLD, 12));
        g2.setPaint(Color.red);
        g2.drawString(s, 100, 200);
        
        window.repaint();
    }

}
