/*
 * @(#)AncestorTree.java  30 January 2003
 */

/*
 * Abstract class that defines the behavior of an ancestor tree
 */
import java.awt.*;
import java.awt.geom.*;

public abstract class AncestorTree{
    
    /* data definition:
     *   ancestor tree is 
     *      either empty
     *      or     structure: 
     *                  tree node contains
     *                      father - a tree node
     *                      mother - a tree node
     *                      name   - a String
     *                      eyeColor - a String
     */    
           
    /*--------------------------------------------------------
     Determine whether the given name appears in this tree.
     -------------------------------------------------------*/
    abstract boolean contains(String aName);
    
    
    /********************************************************/
    /// MORE METHODS TO APPEAR HERE //////////////////////////
    /********************************************************/    

 
    /*--------------------------------------------------------
     Utility methods
     -------------------------------------------------------*/

    /*--------------------------------------------------------
     Display this tree in the given graphics context.
     -------------------------------------------------------*/
    abstract void showTree(int level, int minloc, int maxloc, Graphics2D g2);
        
    /*--------------------------------------------------------
     * utility method that displays one node at the specified level
     * int the given area of the graphics context
     -------------------------------------------------------*/
    protected void showNode(String s, Color eyeColor, 
                            int level, int minloc, int maxloc, Graphics2D g2){
    
        int y = 30 * level;
        int x = (maxloc + minloc)/2 - 6 * (s.length()/2);
        Line2D.Double l= new Line2D.Double();
        
        g2.setFont(new Font("Courier", Font.BOLD, 12));
        g2.setPaint(eyeColor);
        g2.drawString(s, x, y);
        
        if (level > 1){
            int y1 = 30 * (level - 1) + 1;
            int y2 = y - 12;
            int x1 = (maxloc + minloc)/2;
            
            l.setLine(x1, y1, x1, y2);
            g2.draw(l);
        }
        
        if (! s.equals("EMPTY")){
            l.setLine(minloc + (maxloc - minloc)/4, y + 1, maxloc - (maxloc - minloc)/4, y + 1);
            g2.draw(l);
        }
        
    }
    
}
    
