/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.FocusActionAdapter;
import edu.neu.ccs.gui.Laminate;
import edu.neu.ccs.gui.MouseAction;
import edu.neu.ccs.gui.MouseActionAdapter;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.ZooContainer;
import edu.neu.ccs.gui.ZooGroup;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;

public class Zoo
extends ZooContainer {
    protected MouseActionAdapter mouseAdapter = null;
    protected Hashtable laminateTable = new Hashtable();
    protected ListSelectionModel selectionModel = null;
    protected boolean restrictingBounds = true;
    protected boolean moveable = true;
    protected boolean resizeable = true;
    protected boolean designMode = true;
    private Stroke dashedStroke = new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{3.0f, 5.0f}, 0.0f);
    protected Point lassoStart = null;
    protected Point lassoLast = null;
    protected Color focusedHighlightColor = SystemColor.textHighlight;
    protected Color unfocusedHighlightColor = null;
    public final Action SELECT_ALL_ACTION = new 1("Select all");
    public final Action DESELECT_ALL_ACTION = new 2("Deselect all");
    public final Action GROUP_SELECTED_COMPONENTS_ACTION = new 3("Group selected components");
    public final Action UNGROUP_SELECTED_COMPONENT_ACTION = new 4("Ungroup selected component");
    public final Action UNGROUP_SELECTED_COMPONENTS_ACTION = new 5("Ungroup selected components");
    public final Action TOGGLE_DESIGN_MODE_ACTION = new 6("Toggle design mode");
    public final Action SET_DESIGN_MODE_ON_ACTION = new 7("Set design mode on");
    public final Action SET_DESIGN_MODE_OFF_ACTION = new 8("Set design mode off");
    public final Action SEND_TO_BACK_ACTION = new 9("Send to back");
    public final Action BRING_TO_FRONT_ACTION = new 10("Bring to front");
    public final Action MOVE_UP_ACTION = new 11("Move up");
    public final Action MOVE_DOWN_ACTION = new 12("Move down");

    public Zoo() {
        this(true);
    }

    public Zoo(boolean isRestricting) {
        this.setRestrictingBounds(isRestricting);
        this.installSelectionModel();
        this.installMouseAdapter();
        this.installFocusAdapter();
        this.updateSelectionActions();
        this.updateDesignModeActions();
    }

    public Component addChildItem(Component c) {
        return this.addChildItemImpl(c, 0);
    }

    public Component addChildItem(Component c, int z) {
        return this.addChildItemImpl(c, z);
    }

    public Component[] getItems() {
        Vector<Component> items = new Vector<Component>();
        Component c = null;
        ZooGroup group = null;
        Component[] child = null;
        int i = 0;
        while (i < this.getComponentCount()) {
            c = this.getComponent(i);
            if (c instanceof ZooGroup) {
                group = (ZooGroup)c;
                child = group.getItems();
                int j = 0;
                while (j < child.length) {
                    items.add(child[j]);
                    ++j;
                }
            } else if (!(c instanceof Laminate)) {
                items.add(c);
            }
            ++i;
        }
        return items.toArray(new Component[0]);
    }

    public Component getChildItem(int z) {
        if (z < 0) {
            throw new ArrayIndexOutOfBoundsException("Zoo z-order is invalid: " + z);
        }
        int zTemp = z;
        Component c = null;
        int i = 0;
        while (i < this.getComponentCount()) {
            c = this.getComponent(i);
            if (!(c instanceof Laminate)) {
                if (zTemp == 0) {
                    return this.getComponent(i);
                }
                --zTemp;
            }
            ++i;
        }
        throw new ArrayIndexOutOfBoundsException("Zoo z-order is invalid: " + z);
    }

    public Component[] getChildItems() {
        Vector<Component> child = new Vector<Component>();
        int i = 0;
        while (i < this.getComponentCount()) {
            if (!(this.getComponent(i) instanceof Laminate)) {
                child.add(this.getComponent(i));
            }
            ++i;
        }
        return child.toArray(new Component[0]);
    }

    public int getChildItemCount() {
        int z = 0;
        int i = 0;
        while (i < this.getComponentCount()) {
            if (!(this.getComponent(i) instanceof Laminate)) {
                ++z;
            }
            ++i;
        }
        return z;
    }

    public Component removeChildItem(Component c) {
        return this.removeChildItemImpl(c);
    }

    public Component removeChildItem(int z) {
        return this.removeChildItemImpl(this.getChildItem(z));
    }

    public void removeAllItems() {
        super.removeAllItems();
        this.deselectAll();
        this.updateSelectionActions();
    }

    public int moveToZOrder(Component c, int newZ) {
        int z = this.inverseGetChildItem(c);
        if (z == -1) {
            return -1;
        }
        if (z == newZ) {
            return z;
        }
        boolean select = this.selectionModel.isSelectedIndex(z);
        newZ = super.moveToZOrder(c, newZ);
        if (select) {
            this.addToSelection(c);
        }
        this.updateSelection();
        return newZ;
    }

    public ZooGroup group(Component[] components) {
        boolean select = false;
        int temp = 0;
        int i = 0;
        while (i < components.length) {
            temp = this.inverseGetChildItem(components[i]);
            if (temp > -1) {
                select |= this.selectionModel.isSelectedIndex(temp);
            }
            if (select) break;
            ++i;
        }
        ZooGroup group = super.group(components);
        if (group == null) {
            return null;
        }
        if (select) {
            this.addToSelection(group);
        }
        this.updateSelectionActions();
        return group;
    }

    public Component[] ungroup(ZooGroup group) {
        int z = this.inverseGetChildItem(group);
        if (z == -1) {
            return new Component[0];
        }
        boolean select = this.selectionModel.isSelectedIndex(z);
        Component[] components = super.ungroup(group);
        if (select) {
            int i = 0;
            while (i < components.length) {
                this.addToSelection(components[i]);
                ++i;
            }
        }
        this.updateSelection();
        this.updateSelectionActions();
        return components;
    }

    public void selectAll() {
        if (this.selectionModel.isSelectionEmpty() && this.getChildItemCount() == 0) {
            return;
        }
        if (this.selectionModel.getMinSelectionIndex() == 0 && this.selectionModel.getMaxSelectionIndex() == this.getChildItemCount() - 1) {
            return;
        }
        if (!this.hasFocus()) {
            this.requestFocus();
        }
        this.selectionModel.setSelectionInterval(0, this.getChildItemCount() - 1);
        this.updateSelection();
        this.updateSelectionActions();
    }

    public void deselectAll() {
        if (this.selectionModel.isSelectionEmpty() && this.getChildItemCount() == 0) {
            return;
        }
        if (this.selectionModel.isSelectionEmpty()) {
            return;
        }
        if (!this.hasFocus()) {
            this.requestFocus();
        }
        this.selectionModel.clearSelection();
        this.updateSelection();
        this.updateSelectionActions();
        this.repaint();
    }

    public void addToSelection(Component c) {
        int z = this.inverseGetChildItem(c);
        if (z == -1) {
            return;
        }
        if (!this.hasFocus()) {
            this.requestFocus();
        }
        if (!this.selectionModel.isSelectedIndex(z)) {
            this.selectionModel.addSelectionInterval(z, z);
            Laminate glass = this.getLaminateFor(c);
            if (glass != null) {
                glass.setSelected(true);
            }
            this.updateSelectionActions();
            this.repaint();
        }
    }

    public void removeFromSelection(Component c) {
        int z = this.inverseGetChildItem(c);
        if (z == -1) {
            return;
        }
        if (!this.hasFocus()) {
            this.requestFocus();
        }
        if (this.selectionModel.isSelectedIndex(z)) {
            this.selectionModel.removeSelectionInterval(z, z);
            Laminate glass = this.getLaminateFor(c);
            if (glass != null) {
                glass.setSelected(false);
            }
            this.updateSelectionActions();
            this.repaint();
        }
    }

    public void selectOnly(Component c) {
        int z = this.inverseGetChildItem(c);
        if (z == -1) {
            return;
        }
        this.selectionModel.setSelectionInterval(z, z);
        this.updateSelection();
        this.updateSelectionActions();
    }

    /*
     * Unable to fully structure code
     */
    public void setSelectedComponents(Component[] c) {
        if (c == null) {
            return;
        }
        select = new boolean[this.getChildItemCount()];
        i = 0;
        while (i < c.length) {
            z = this.inverseGetChildItem(c[i]);
            if (z != -1) {
                select[z] = true;
            }
            ++i;
        }
        i = 0;
        while (i < select.length) {
            if (this.selectionModel.isSelectedIndex(i) != select[i]) break;
            ++i;
        }
        if (i == select.length) {
            return;
        }
        this.selectionModel.clearSelection();
        start = 0;
        end = 0;
        while (start < select.length && !select[start]) {
            ++start;
        }
        end = start;
        ** GOTO lbl36
        {
            ++end;
            do {
                if (end < select.length && select[end]) continue block3;
                end = end == start ? start + 1 : end;
                this.selectionModel.addSelectionInterval(start, end - 1);
                start = end;
                while (start < select.length && !select[start]) {
                    ++start;
                }
                end = start;
lbl36:
                // 2 sources

            } while (start < select.length);
        }
        this.updateSelection();
        this.updateSelectionActions();
    }

    public Component getSelectedComponent() {
        if (this.selectionModel.isSelectionEmpty()) {
            return null;
        }
        return this.getChildItem(this.selectionModel.getMinSelectionIndex());
    }

    public Component getSelectedComponent(int index) {
        if (this.selectionModel.isSelectionEmpty()) {
            return null;
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("Index into selected components invalid: " + index);
        }
        int count = index;
        int i = this.selectionModel.getMinSelectionIndex();
        while (i <= this.selectionModel.getMaxSelectionIndex()) {
            if (this.selectionModel.isSelectedIndex(i)) {
                if (count == 0) {
                    return this.getChildItem(i);
                }
                --count;
            }
            ++i;
        }
        throw new ArrayIndexOutOfBoundsException("Index into selected components invalid: " + index);
    }

    public Component[] getSelectedComponents() {
        Vector<Component> select = new Vector<Component>();
        Component[] child = this.getChildItems();
        int i = this.selectionModel.getMinSelectionIndex();
        while (i <= this.selectionModel.getMaxSelectionIndex()) {
            if (this.selectionModel.isSelectedIndex(i)) {
                select.add(child[i]);
            }
            ++i;
        }
        return select.toArray(new Component[0]);
    }

    public int getSelectedComponentCount() {
        if (this.isSelectionEmpty()) {
            return 0;
        }
        int numSelected = 0;
        int i = this.selectionModel.getMinSelectionIndex();
        while (i <= this.selectionModel.getMaxSelectionIndex()) {
            if (this.selectionModel.isSelectedIndex(i)) {
                ++numSelected;
            }
            ++i;
        }
        return numSelected;
    }

    public boolean isSelectionEmpty() {
        return this.selectionModel.isSelectionEmpty();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public ZooGroup groupSelection() {
        Component[] select = this.getSelectedComponents();
        if (select.length > 1) {
            return this.group(select);
        }
        return null;
    }

    public void ungroupSelection() {
        Component[] components = this.getSelectedComponents();
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof ZooGroup) {
                this.ungroup((ZooGroup)components[i]);
            }
            ++i;
        }
    }

    public void setInDesignMode(boolean designing) {
        this.designMode = designing;
        if (this.designMode) {
            this.mouseAdapter.addAsListenerTo(this);
        } else {
            this.mouseAdapter.removeAsListenerTo(this);
        }
        Laminate glass = null;
        Component[] child = this.getChildItems();
        int i = 0;
        while (i < child.length) {
            glass = this.getLaminateFor(child[i]);
            if (glass != null) {
                glass.setActivated(this.designMode);
                if (!this.designMode) {
                    glass.setSelected(false);
                }
            }
            ++i;
        }
        this.updateDesignModeActions();
        if (this.designMode) {
            this.updateSelection();
        }
        this.repaint();
    }

    public boolean isInDesignMode() {
        return this.designMode;
    }

    public void setRestrictingBounds(boolean isRestricting) {
        this.restrictingBounds = isRestricting;
    }

    public boolean isRestrictingBounds() {
        return this.restrictingBounds;
    }

    public void setAllowsMove(boolean allowsMove) {
        this.moveable = allowsMove;
    }

    public boolean allowsMove() {
        return this.moveable;
    }

    public void setAllowsResize(boolean allowsResize) {
        this.resizeable = allowsResize;
    }

    public boolean allowsResize() {
        return this.resizeable;
    }

    public void setFocusedHighlightColor(Color c) {
        if (c == null) {
            return;
        }
        this.focusedHighlightColor = c;
    }

    public Color getFocusedHighlightColor() {
        return this.focusedHighlightColor;
    }

    public void setUnfocusedHighlightColor(Color c) {
        if (c == null) {
            return;
        }
        this.unfocusedHighlightColor = c;
    }

    public Color getUnfocusedHighlightColor() {
        if (this.unfocusedHighlightColor == null) {
            return this.computeUnfocusedHighlightColor(this.getFocusedHighlightColor());
        }
        return this.unfocusedHighlightColor;
    }

    public Laminate getLaminateFor(Component c) {
        Object o = this.laminateTable.get(c);
        if (o instanceof Laminate) {
            return (Laminate)o;
        }
        return null;
    }

    public boolean isFocusTraversable() {
        return this.isInDesignMode();
    }

    public boolean isManagingFocus() {
        return this.isInDesignMode();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.hasFocus() && this.isInDesignMode()) {
            Graphics2D g2 = (Graphics2D)g;
            Rectangle lasso = this.getLassoBounds();
            if (lasso != null) {
                Stroke temp = g2.getStroke();
                g2.setColor(Color.black);
                g2.setStroke(this.dashedStroke);
                g2.draw(lasso);
                g2.setStroke(temp);
            } else if (this.isSelectionEmpty()) {
                Insets in = this.getInsets();
                g2.setColor(SystemColor.textHighlight);
                g2.drawRect(in.left, in.top, this.getWidth() - 1 - in.left - in.right, this.getHeight() - 1 - in.top - in.bottom);
            }
        }
    }

    protected Laminate createLaminateFor(Component c) {
        return new Laminate(c, this.isInDesignMode());
    }

    protected void installMouseAdapter() {
        this.mouseAdapter = new MouseActionAdapter(this);
        this.mouseAdapter.addMousePressedAction(new 13());
        this.mouseAdapter.addMouseDraggedAction(new 14());
        this.mouseAdapter.addMouseReleasedAction(new 15());
    }

    protected void installSelectionModel() {
        this.selectionModel = new DefaultListSelectionModel();
        this.selectionModel.setSelectionMode(2);
    }

    protected void installFocusAdapter() {
        FocusActionAdapter focusAdapter = new FocusActionAdapter();
        this.addFocusListener(focusAdapter);
        16 repaint = new 16();
        focusAdapter.addFocusGainedAction(repaint);
        focusAdapter.addFocusLostAction(repaint);
    }

    protected void updateSelection() {
        Component[] child = this.getChildItems();
        int i = 0;
        while (i < child.length) {
            Laminate glass = this.getLaminateFor(child[i]);
            if (glass != null) {
                glass.setSelected(this.selectionModel.isSelectedIndex(i));
            }
            ++i;
        }
        this.repaint();
    }

    protected Rectangle getLassoBounds() {
        if (this.lassoStart == null) {
            return null;
        }
        int x1 = Math.min(this.lassoStart.x, this.lassoLast.x);
        int y1 = Math.min(this.lassoStart.y, this.lassoLast.y);
        int x2 = Math.max(this.lassoStart.x, this.lassoLast.x);
        int y2 = Math.max(this.lassoStart.y, this.lassoLast.y);
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    protected void startLasso(MouseEvent evt) {
        this.lassoLast = this.lassoStart = new Point(evt.getX(), evt.getY());
        if (!evt.isShiftDown()) {
            this.deselectAll();
        }
    }

    protected void resizeLasso(MouseEvent evt) {
        this.lassoLast = new Point(evt.getX(), evt.getY());
        Rectangle lasso = this.getLassoBounds();
        Component[] child = this.getChildItems();
        int i = 0;
        while (i < child.length) {
            if (lasso.contains(child[i].getBounds())) {
                this.addToSelection(child[i]);
            } else if (!evt.isShiftDown()) {
                this.removeFromSelection(child[i]);
            }
            ++i;
        }
        this.repaint();
    }

    protected void endLasso(MouseEvent evt) {
        this.lassoStart = null;
        this.lassoLast = null;
        this.repaint();
    }

    protected void updateSelectionActions() {
        this.SELECT_ALL_ACTION.setEnabled(this.getSelectedComponentCount() != this.getChildItemCount());
        this.DESELECT_ALL_ACTION.setEnabled(this.isSelectionEmpty() ^ true);
        Component[] selected = this.getSelectedComponents();
        Component c = this.getSelectedComponent();
        this.GROUP_SELECTED_COMPONENTS_ACTION.setEnabled(selected.length > 1);
        this.UNGROUP_SELECTED_COMPONENT_ACTION.setEnabled(c instanceof ZooGroup);
        int z = this.inverseGetChildItem(c);
        this.SEND_TO_BACK_ACTION.setEnabled(selected.length == 1 && z < this.getChildItemCount() - 1 && z != -1);
        this.BRING_TO_FRONT_ACTION.setEnabled(selected.length == 1 && z > 0);
        this.MOVE_UP_ACTION.setEnabled(selected.length == 1 && z > 0);
        this.MOVE_DOWN_ACTION.setEnabled(selected.length == 1 && z < this.getChildItemCount() - 1 && z != -1);
        if (selected.length < 1) {
            this.UNGROUP_SELECTED_COMPONENTS_ACTION.setEnabled(false);
            return;
        }
        int i = 0;
        while (i < selected.length) {
            if (!(selected[i] instanceof ZooGroup)) {
                this.UNGROUP_SELECTED_COMPONENTS_ACTION.setEnabled(false);
                return;
            }
            ++i;
        }
        this.UNGROUP_SELECTED_COMPONENTS_ACTION.setEnabled(true);
    }

    protected void updateDesignModeActions() {
        this.SET_DESIGN_MODE_ON_ACTION.setEnabled(this.isInDesignMode() ^ true);
        this.SET_DESIGN_MODE_OFF_ACTION.setEnabled(this.isInDesignMode());
    }

    protected Color computeUnfocusedHighlightColor(Color c) {
        if (c == null) {
            return Color.black;
        }
        int intensity = Math.max(c.getRed(), Math.max(c.getBlue(), c.getGreen()));
        if ((double)intensity / 255.0 < 0.1) {
            return c.brighter();
        }
        return c.darker();
    }

    private Component addChildItemImpl(Component c, int z) {
        if (c == null) {
            return null;
        }
        if (z == -1) {
            z = this.getChildItemCount();
        }
        if (z < 0 || z > this.getChildItemCount()) {
            throw new ArrayIndexOutOfBoundsException("Zoo z-order invalid: " + z);
        }
        if (c.getHeight() == 0 && c.getWidth() == 0) {
            c.setSize(c.getPreferredSize());
        }
        Laminate glass = this.createLaminateFor(c);
        this.laminateTable.put(c, glass);
        int index = this.zOrderToIndex(z);
        this.add((Component)glass, index);
        this.add(c, index + 1);
        this.selectionModel.insertIndexInterval(z, 1, true);
        this.selectionModel.removeSelectionInterval(z, z);
        this.updateSelection();
        this.updateSelectionActions();
        return c;
    }

    private Component removeChildItemImpl(Component c) {
        Component[] child = this.getChildItems();
        int i = 0;
        while (i < child.length) {
            if (child[i] == c) {
                this.removeComponentImpl(c, i);
                this.updateSelection();
                return c;
            }
            ++i;
        }
        return null;
    }

    private void removeComponentImpl(Component c, int z) {
        if (c instanceof Laminate) {
            return;
        }
        if (z == -1) {
            z = this.inverseGetChildItem(c);
        }
        if (z == -1) {
            return;
        }
        Laminate glass = this.getLaminateFor(c);
        c.removeComponentListener(glass);
        glass.setTarget(null);
        this.remove(glass);
        this.remove(c);
        this.selectionModel.removeIndexInterval(z, z);
        this.updateSelectionActions();
    }

    private int zOrderToIndex(int z) {
        int i = 0;
        while (i < this.getComponentCount()) {
            if (z == 0) {
                return i;
            }
            if (!(this.getComponent(i) instanceof Laminate)) {
                --z;
            }
            ++i;
        }
        return this.getComponentCount();
    }

    private final class 1
    extends SimpleAction {
        public void perform() {
            Zoo.this.selectAll();
        }

        /* synthetic */ 1(String $0) {
            super($0);
        }
    }

    private final class 2
    extends SimpleAction {
        public void perform() {
            Zoo.this.deselectAll();
        }

        /* synthetic */ 2(String $0) {
            super($0);
        }
    }

    private final class 3
    extends SimpleAction {
        public void perform() {
            Zoo.this.groupSelection();
        }

        /* synthetic */ 3(String $0) {
            super($0);
        }
    }

    private final class 4
    extends SimpleAction {
        public void perform() {
            Component c = Zoo.this.getSelectedComponent();
            if (c instanceof ZooGroup) {
                Zoo.this.ungroup((ZooGroup)c);
            }
        }

        /* synthetic */ 4(String $0) {
            super($0);
        }
    }

    private final class 5
    extends SimpleAction {
        public void perform() {
            Zoo.this.ungroupSelection();
        }

        /* synthetic */ 5(String $0) {
            super($0);
        }
    }

    private final class 6
    extends SimpleAction {
        public void perform() {
            Zoo.this.setInDesignMode(Zoo.this.isInDesignMode() ^ true);
        }

        /* synthetic */ 6(String $0) {
            super($0);
        }
    }

    private final class 7
    extends SimpleAction {
        public void perform() {
            Zoo.this.setInDesignMode(true);
        }

        /* synthetic */ 7(String $0) {
            super($0);
        }
    }

    private final class 8
    extends SimpleAction {
        public void perform() {
            Zoo.this.setInDesignMode(false);
        }

        /* synthetic */ 8(String $0) {
            super($0);
        }
    }

    private final class 9
    extends SimpleAction {
        public void perform() {
            Zoo.this.sendToBack(Zoo.this.getSelectedComponent());
        }

        /* synthetic */ 9(String $0) {
            super($0);
        }
    }

    private final class 10
    extends SimpleAction {
        public void perform() {
            Zoo.this.bringToFront(Zoo.this.getSelectedComponent());
        }

        /* synthetic */ 10(String $0) {
            super($0);
        }
    }

    private final class 11
    extends SimpleAction {
        public void perform() {
            Zoo.this.moveUp(Zoo.this.getSelectedComponent());
        }

        /* synthetic */ 11(String $0) {
            super($0);
        }
    }

    private final class 12
    extends SimpleAction {
        public void perform() {
            Zoo.this.moveDown(Zoo.this.getSelectedComponent());
        }

        /* synthetic */ 12(String $0) {
            super($0);
        }
    }

    private final class 13
    extends MouseAction {
        public void mouseActionPerformed(MouseEvent evt) {
            Zoo.this.startLasso(evt);
        }

        /* synthetic */ 13() {
        }
    }

    private final class 14
    extends MouseAction {
        public void mouseActionPerformed(MouseEvent evt) {
            Zoo.this.resizeLasso(evt);
        }

        /* synthetic */ 14() {
        }
    }

    private final class 15
    extends MouseAction {
        public void mouseActionPerformed(MouseEvent evt) {
            Zoo.this.endLasso(evt);
        }

        /* synthetic */ 15() {
        }
    }

    private final class 16
    extends SimpleAction {
        public void perform() {
            Zoo.this.repaint();
        }

        /* synthetic */ 16() {
        }
    }
}

