/*
 * @(#)EmptyStrings.java  1.0  26 January 2003
 *
 *   Viera Proulx      vkp@ccs.neu.edu
 */

/*
 * A class that defines the behavior of an empty list of Strings
 */

public class EmptyStrings extends AList{
    
    /*
     * the default constructor
     */
    public EmptyStrings(){
        
    }

                                    
    /*
     * count the number of items in this list
     */
    int count(){
        return 0;
    }
        
    /*
     * determine whether the given object appears in this list.
     */
    boolean contains(Object o){
        return false;
    }
    
    /*
     * produce a sorted list from this list of Strings.
     */
    AList sort(){
        return this;
    }    
    
    /*
     * insert a number into a sorted list
     */
    AList insert(Comparable o){
        return (new ConsStrings((String)o, this));
    }
                                    
    /*
     * print the contents of this list
     */
    public String toString(){
        return "*";
    }
}
    
