/*
 * @(#)ConsIntegers.java  1.0  26 January 2003
 *
 *   Viera Proulx      vkp@ccs.neu.edu
 */

/*
 * A class that defines the behavior of a constructed list of numbers
 */

public class ConsIntegers extends AList{

    Integer first;
    AList rest;
    
    /*
     * the default constructor
     */
    public ConsIntegers(Integer n, AList alon){
        
        /* the first item in this list */
        first = n;
        
        /* the rest of this list */
        rest  = alon;
    }
    
                                        
    /*
     * count the number of items in this list
     */
    int count(){
        return (1 + rest.count());
    }
        
    /*
     * determine whether the given number appears in this list.
     */
    boolean contains(Object n){
        if (first.equals(n))
            return true;
        else
            return rest.contains(n);
    }
    
    /*
     * produce a sorted list from this list of numbers.
     */
    AList sort(){
        return (rest.sort()).insert(first);
    }
    
    /*
     * insert a number into a sorted list
     */
    AList insert(Comparable n){
        if (n.compareTo(first) < 0)
            return (new ConsIntegers((Integer)n, this));
        else
            return (new ConsIntegers(first, rest.insert(n)));
    }
    
    /*
     * print the contents of this list
     */
    public String toString(){
        return "new " + getClass().getName() + "("
               + first + ",\n\t" + rest + ")";
    }
        
    
}
    
