/*
 * @(#)AList.java  1.0  26 January 2003
 *
 *   Viera Proulx      vkp@ccs.neu.edu
 */

/*
 * Abstract class that defines the behavior of a list of objects
 */

public abstract class AList{
    
    /* data definition:
     *   List is 
     *      either empty
     *      or     structure: 
     *                 first - an object
     *                 rest  - a List of objects
     */    
     
    /*
     * count the number of items in this list
     */
    abstract int count();
        
    /*
     * determine whether the given object appears in this list.
     */
    abstract boolean contains(Object o);
    
    /*
     * produce a sorted list from this list.
     */
    abstract AList sort();
    
    /*
     * insert an object into a sorted list
     */
    abstract AList insert(Comparable o);
                                            
}
    
