/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.jpf;

import edu.neu.ccs.gui.Annotation;
import edu.neu.ccs.gui.GeneralDialog;
import edu.neu.ccs.gui.PaintAction;
import edu.neu.ccs.gui.PaintActionCapsule;
import edu.neu.ccs.gui.TablePanel;
import edu.neu.ccs.jpf.JPFApplication;
import edu.neu.ccs.util.JPTConstants;
import edu.neu.ccs.util.JPTError;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.border.EmptyBorder;

public class JPFBase
implements JPTConstants {
    private static final PaintAction CHECK_ACTION = new 1();
    private static final PaintAction X_ACTION = new 2();

    protected boolean declaresMethod(Class c, String method) {
        return this.hasConstructorsAndMethods(c, null, new String[]{method}, false, true);
    }

    protected boolean declaresMethodNoDialog(Class c, String method) {
        return this.hasConstructorsAndMethods(c, null, new String[]{method}, false, false);
    }

    protected boolean providesMethod(Class c, String method) {
        return this.hasConstructorsAndMethods(c, null, new String[]{method}, true, true);
    }

    protected boolean providesMethodNoDialog(Class c, String method) {
        return this.hasConstructorsAndMethods(c, null, new String[]{method}, true, false);
    }

    protected boolean declaresMethods(Class c, String[] methods) {
        return this.hasConstructorsAndMethods(c, null, methods, false, true);
    }

    protected boolean declaresMethodsNoDialog(Class c, String[] methods) {
        return this.hasConstructorsAndMethods(c, null, methods, false, false);
    }

    protected boolean providesMethods(Class c, String[] methods) {
        return this.hasConstructorsAndMethods(c, null, methods, true, true);
    }

    protected boolean providesMethodsNoDialog(Class c, String[] methods) {
        return this.hasConstructorsAndMethods(c, null, methods, true, false);
    }

    protected boolean declaresConstructor(Class c, String constructor) {
        return this.hasConstructorsAndMethods(c, new String[]{constructor}, null, false, true);
    }

    protected boolean declaresConstructorNoDialog(Class c, String constructor) {
        return this.hasConstructorsAndMethods(c, new String[]{constructor}, null, false, false);
    }

    protected boolean declaresConstructors(Class c, String[] constructors) {
        return this.hasConstructorsAndMethods(c, constructors, null, false, true);
    }

    protected boolean declaresConstructorsNoDialog(Class c, String[] constructors) {
        return this.hasConstructorsAndMethods(c, constructors, null, false, false);
    }

    protected boolean declaresConstructorsAndMethods(Class c, String[] constructors, String[] methods) {
        return this.hasConstructorsAndMethods(c, constructors, methods, false, true);
    }

    protected boolean declaresConstructorsAndMethodsNoDialog(Class c, String[] constructors, String[] methods) {
        return this.hasConstructorsAndMethods(c, constructors, methods, false, false);
    }

    protected boolean providesConstructorsAndMethods(Class c, String[] constructors, String[] methods) {
        return this.hasConstructorsAndMethods(c, constructors, methods, true, true);
    }

    protected boolean providesConstructorsAndMethodsNoDialog(Class c, String[] constructors, String[] methods) {
        return this.hasConstructorsAndMethods(c, constructors, methods, true, false);
    }

    protected void report(Class c, String[] constructors, boolean[] isConstructorDeclared, String[] methods, boolean[] isMethodDeclared) {
        TablePanel methodsPanel = new TablePanel(constructors.length + methods.length, 2, 20, 5, 7);
        PaintAction action = null;
        int row = 0;
        int i = 0;
        while (i < constructors.length) {
            action = isConstructorDeclared[i] ? CHECK_ACTION : X_ACTION;
            methodsPanel.addObject((Object)new PaintActionCapsule((Action)action, 10, 15), row, 0);
            methodsPanel.addObject((Object)new Annotation(constructors[i]), row, 1);
            ++row;
            ++i;
        }
        int i2 = 0;
        while (i2 < methods.length) {
            action = isMethodDeclared[i2] ? CHECK_ACTION : X_ACTION;
            methodsPanel.addObject((Object)new PaintActionCapsule((Action)action, 10, 15), row, 0);
            methodsPanel.addObject((Object)new Annotation(methods[i2]), row, 1);
            ++row;
            ++i2;
        }
        String insert = "";
        if (constructors.length > 0 && methods.length > 0) {
            insert = "constructors and methods";
        } else if (constructors.length > 0) {
            insert = "constructors";
        } else if (methods.length > 0) {
            insert = "methods";
        }
        TablePanel mainPanel = new TablePanel(new Object[]{"The following " + insert + " are required\n" + "in class " + JPFApplication.className(c) + ":", methodsPanel}, 1, 0, 10, 1);
        mainPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        GeneralDialog.showOKDialog(mainPanel, "Required " + insert);
    }

    private boolean hasConstructorsAndMethods(Class c, String[] constructors, String[] methods, boolean recurse, boolean showDialog) {
        if (constructors == null) {
            constructors = new String[]{};
        }
        boolean[] isConstructorDeclared = new boolean[constructors.length];
        if (methods == null) {
            methods = new String[]{};
        }
        boolean[] isMethodDeclared = new boolean[methods.length];
        boolean allDeclared = true;
        int i = 0;
        while (i < constructors.length) {
            isConstructorDeclared[i] = this.hasConstructorImpl(c, constructors[i]);
            if (!isConstructorDeclared[i]) {
                allDeclared = false;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < methods.length) {
            isMethodDeclared[i2] = this.hasMethodImpl(c, methods[i2], recurse);
            if (!isMethodDeclared[i2]) {
                allDeclared = false;
            }
            ++i2;
        }
        if (!allDeclared && showDialog) {
            this.report(c, constructors, isConstructorDeclared, methods, isMethodDeclared);
        }
        return allDeclared;
    }

    private boolean hasMethodImpl(Class c, String method, boolean recurse) {
        if (c == null) {
            return false;
        }
        MethodSignature sig = new MethodSignature(method);
        try {
            Method[] methods = c.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                if (sig.equals(methods[i])) {
                    return true;
                }
                ++i;
            }
            if (recurse) {
                return this.hasMethodImpl(c.getSuperclass(), method, true);
            }
            return false;
        }
        catch (SecurityException securityException) {
            return true;
        }
    }

    private boolean hasConstructorImpl(Class c, String constructor) {
        if (c == null) {
            return false;
        }
        ConstructorSignature sig = new ConstructorSignature(constructor);
        try {
            Constructor<?>[] constructors = c.getDeclaredConstructors();
            int i = 0;
            while (i < constructors.length) {
                if (sig.equals(constructors[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (SecurityException securityException) {
            return true;
        }
    }

    private final class 1
    extends PaintAction {
        private Stroke stroke = new BasicStroke(2.0f);

        public void paint(Component c, Graphics g) {
            int width13 = c.getWidth() / 3;
            int height12 = c.getHeight() / 2;
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setStroke(this.stroke);
            g2.setColor(new Color(0, 128, 0));
            g2.draw(new Line2D.Double(0.0, height12, width13, c.getHeight() - 1));
            g2.draw(new Line2D.Double(width13, c.getHeight() - 1, height12 + 1, 0.0));
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends PaintAction {
        private Stroke stroke = new BasicStroke(2.0f);

        public void paint(Component c, Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setStroke(this.stroke);
            g2.setColor(Color.red);
            g2.draw(new Line2D.Double(0.0, 0.0, c.getWidth() - 1, c.getHeight() - 1));
            g2.draw(new Line2D.Double(c.getWidth() - 1, 0.0, 0.0, c.getHeight() - 1));
        }

        /* synthetic */ 2() {
        }
    }

    private static abstract class MemberSignature {
        protected int modifiers = 0;
        protected String name = null;

        protected abstract void fromString(String var1) throws JPTError;

        protected void addModifier(String token) {
            int newModifier = 0;
            if (token.equals("public")) {
                newModifier = 1;
            } else if (token.equals("protected")) {
                newModifier = 4;
            } else if (token.equals("private")) {
                newModifier = 2;
            } else if (token.equals("abstract")) {
                newModifier = 1024;
            } else if (token.equals("static")) {
                newModifier = 8;
            } else if (token.equals("final")) {
                newModifier = 16;
            } else if (token.equals("synchronized")) {
                newModifier = 32;
            }
            this.modifiers |= newModifier;
        }

        protected boolean isModifier(String token) {
            return token.equals("public") || token.equals("protected") || token.equals("private") || token.equals("abstract") || token.equals("static") || token.equals("final") || token.equals("synchronized");
        }

        protected String className(Class c) {
            String s = c.getName();
            int pos = s.lastIndexOf(".");
            if (pos < 0) {
                return s;
            }
            return s.substring(pos + 1);
        }

        protected String modifierString() {
            String s = "";
            if (Modifier.isPublic(this.modifiers)) {
                s = String.valueOf(s) + "public ";
            }
            if (Modifier.isProtected(this.modifiers)) {
                s = String.valueOf(s) + "protected ";
            }
            if (Modifier.isPrivate(this.modifiers)) {
                s = String.valueOf(s) + "private ";
            }
            if (Modifier.isAbstract(this.modifiers)) {
                s = String.valueOf(s) + "abstract ";
            }
            if (Modifier.isStatic(this.modifiers)) {
                s = String.valueOf(s) + "static ";
            }
            if (Modifier.isFinal(this.modifiers)) {
                s = String.valueOf(s) + "final ";
            }
            if (Modifier.isSynchronized(this.modifiers)) {
                s = String.valueOf(s) + "synchronized ";
            }
            return s;
        }

        MemberSignature() {
        }
    }

    private static abstract class ParametrizedSignature
    extends MemberSignature {
        private ArrayList parameters = new ArrayList();
        private ArrayList parameterNames = new ArrayList();

        protected void addParameter(String type, String name) {
            this.parameters.add(type);
            this.parameterNames.add(name);
        }

        public String[] getParameterTypes() {
            return this.parameters.toArray(new String[0]);
        }

        public String[] getParameterNames() {
            return this.parameterNames.toArray(new String[0]);
        }

        protected String parameterString() {
            String s = "(";
            String[] pTypes = this.getParameterTypes();
            String[] pNames = this.getParameterNames();
            if (pTypes.length > 0) {
                s = String.valueOf(s) + pTypes[0] + " " + pNames[0];
                int i = 1;
                while (i < pTypes.length) {
                    s = String.valueOf(s) + "," + pTypes[i] + " " + pTypes[i];
                    ++i;
                }
            }
            s = String.valueOf(s) + ")";
            return s;
        }

        ParametrizedSignature() {
        }
    }

    private static class MethodSignature
    extends ParametrizedSignature {
        protected String returnType = null;

        public MethodSignature(String s) throws JPTError {
            this.fromString(s);
        }

        protected void fromString(String s) throws JPTError {
            StringTokenizer t = new StringTokenizer(s);
            try {
                String s1 = t.nextToken();
                while (this.isModifier(s1)) {
                    this.addModifier(s1);
                    s1 = t.nextToken();
                }
                this.returnType = s1;
                this.name = t.nextToken("(,) ");
                while (t.hasMoreTokens()) {
                    s1 = t.nextToken();
                    String s2 = t.nextToken();
                    this.addParameter(s1, s2);
                }
            }
            catch (Exception exception) {
                throw new JPTError("Method signature malformed: " + s);
            }
        }

        public String toString() {
            String s = "";
            s = String.valueOf(s) + this.modifierString();
            s = String.valueOf(s) + this.returnType + " " + this.name;
            s = String.valueOf(s) + this.parameterString();
            return s;
        }

        public boolean equals(Method m) {
            String[] sTypes;
            if (m.getModifiers() != this.modifiers) {
                return false;
            }
            if (!m.getName().equals(this.name)) {
                return false;
            }
            if (!this.className(m.getReturnType()).equals(this.returnType)) {
                return false;
            }
            Class<?>[] mTypes = m.getParameterTypes();
            if (mTypes.length != (sTypes = this.getParameterTypes()).length) {
                return false;
            }
            int i = 0;
            while (i < mTypes.length) {
                if (!this.className(mTypes[i]).equals(sTypes[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private static class ConstructorSignature
    extends ParametrizedSignature {
        public ConstructorSignature(String s) throws JPTError {
            this.fromString(s);
        }

        protected void fromString(String s) throws JPTError {
            StringTokenizer t = new StringTokenizer(s);
            try {
                String s2;
                String s1 = t.nextToken();
                if (this.isModifier(s1)) {
                    this.addModifier(s1);
                }
                this.name = s2 = t.nextToken("(,) ");
                while (t.hasMoreTokens()) {
                    s1 = t.nextToken();
                    s2 = t.nextToken();
                    this.addParameter(s1, s2);
                }
            }
            catch (Exception exception) {
                throw new JPTError("Constructor signature malformed: " + s);
            }
        }

        public String toString() {
            String s = "";
            s = String.valueOf(s) + this.modifierString();
            s = String.valueOf(s) + this.name;
            s = String.valueOf(s) + this.parameterString();
            return s;
        }

        public boolean equals(Constructor c) {
            String[] sTypes;
            if (c.getModifiers() != this.modifiers) {
                return false;
            }
            if (!c.getName().equals(this.name)) {
                return false;
            }
            Class<?>[] cTypes = c.getParameterTypes();
            if (cTypes.length != (sTypes = this.getParameterTypes()).length) {
                return false;
            }
            int i = 0;
            while (i < cTypes.length) {
                if (!this.className(cTypes[i]).equals(sTypes[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected boolean isModifier(String token) {
            return token.equals("public") || token.equals("protected") || token.equals("private");
        }
    }
}

