/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.filter;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.filter.FilterException;
import edu.neu.ccs.filter.MaximumBoundFilter;
import edu.neu.ccs.filter.MinimumBoundFilter;
import edu.neu.ccs.filter.NumericFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class RangeFilter
extends NumericFilter
implements PropertyChangeListener {
    public static final String MINIMUM = "minimum";
    public static final String MAXIMUM = "maximum";
    public static final String MINIMUM_INCLUSIVE = "minimum.inclusive";
    public static final String MAXIMUM_INCLUSIVE = "maximum.inclusive";
    protected MinimumBoundFilter minimum = null;
    protected MaximumBoundFilter maximum = null;

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.minimum) {
            if (evt.getPropertyName() == MINIMUM) {
                this.changeAdapter.firePropertyChange(MINIMUM, evt.getOldValue(), evt.getNewValue());
            } else if (evt.getPropertyName() == "inclusive") {
                this.changeAdapter.firePropertyChange(MINIMUM_INCLUSIVE, evt.getOldValue(), evt.getNewValue());
            }
        } else if (evt.getSource() == this.maximum) {
            if (evt.getPropertyName() == MAXIMUM) {
                this.changeAdapter.firePropertyChange(MAXIMUM, evt.getOldValue(), evt.getNewValue());
            } else if (evt.getPropertyName() == "inclusive") {
                this.changeAdapter.firePropertyChange(MAXIMUM_INCLUSIVE, evt.getOldValue(), evt.getNewValue());
            }
        }
    }

    public static class Long
    extends RangeFilter {
        public Long(long min, long max) {
            this(min, true, max, true);
        }

        public Long(long min, boolean minInclusive, long max, boolean maxInclusive) {
            this.minimum = new MinimumBoundFilter.Long(min, minInclusive);
            this.minimum.addPropertyChangeListener(this);
            this.maximum = new MaximumBoundFilter.Long(max, maxInclusive);
            this.maximum.addPropertyChangeListener(this);
        }

        public Stringable filterStringable(Stringable obj) throws FilterException {
            obj = super.filterStringable(obj);
            try {
                obj = this.minimum.filterStringable(obj);
                obj = this.maximum.filterStringable(obj);
            }
            catch (FilterException filterException) {
                String message = "Value not within the range ";
                message = String.valueOf(message) + (this.isMinimumInclusive() ? "[" : "(");
                message = String.valueOf(message) + this.getMinimum() + ",";
                message = String.valueOf(message) + this.getMaximum();
                message = String.valueOf(message) + (this.isMaximumInclusive() ? "]" : ")");
                throw new FilterException(obj, message);
            }
            return obj;
        }

        public void setMinimum(long min) {
            this.getMinimumFilter().setMinimum(min);
        }

        public long getMinimum() {
            return this.getMinimumFilter().getMinimum();
        }

        public void setMaximum(long max) {
            this.getMaximumFilter().setMaximum(max);
        }

        public long getMaximum() {
            return this.getMaximumFilter().getMaximum();
        }

        public void setMinimumInclusive(boolean inclusive) {
            this.minimum.setInclusive(inclusive);
        }

        public boolean isMinimumInclusive() {
            return this.minimum.isInclusive();
        }

        public void setMaximumInclusive(boolean inclusive) {
            this.maximum.setInclusive(inclusive);
        }

        public boolean isMaximumInclusive() {
            return this.maximum.isInclusive();
        }

        protected MinimumBoundFilter.Long getMinimumFilter() {
            return (MinimumBoundFilter.Long)this.minimum;
        }

        protected MaximumBoundFilter.Long getMaximumFilter() {
            return (MaximumBoundFilter.Long)this.maximum;
        }
    }

    public static class Double
    extends RangeFilter {
        public Double(double min, double max) {
            this(min, true, max, true);
        }

        public Double(double min, boolean minInclusive, double max, boolean maxInclusive) {
            this.minimum = new MinimumBoundFilter.Double(min, minInclusive);
            this.minimum.addPropertyChangeListener(this);
            this.maximum = new MaximumBoundFilter.Double(max, maxInclusive);
            this.maximum.addPropertyChangeListener(this);
        }

        public Stringable filterStringable(Stringable obj) throws FilterException {
            obj = super.filterStringable(obj);
            try {
                obj = this.minimum.filterStringable(obj);
                obj = this.maximum.filterStringable(obj);
            }
            catch (FilterException filterException) {
                String message = "Value not within the range ";
                message = String.valueOf(message) + (this.isMinimumInclusive() ? "[" : "(");
                message = String.valueOf(message) + this.getMinimum() + ",";
                message = String.valueOf(message) + this.getMaximum();
                message = String.valueOf(message) + (this.isMaximumInclusive() ? "]" : ")");
                throw new FilterException(obj, message);
            }
            return obj;
        }

        public void setMinimum(double min) {
            this.getMinimumFilter().setMinimum(min);
        }

        public double getMinimum() {
            return this.getMinimumFilter().getMinimum();
        }

        public void setMaximum(double max) {
            this.getMaximumFilter().setMaximum(max);
        }

        public double getMaximum() {
            return this.getMaximumFilter().getMaximum();
        }

        public void setMinimumInclusive(boolean inclusive) {
            this.minimum.setInclusive(inclusive);
        }

        public boolean isMinimumInclusive() {
            return this.minimum.isInclusive();
        }

        public void setMaximumInclusive(boolean inclusive) {
            this.maximum.setInclusive(inclusive);
        }

        public boolean isMaximumInclusive() {
            return this.maximum.isInclusive();
        }

        protected MinimumBoundFilter.Double getMinimumFilter() {
            return (MinimumBoundFilter.Double)this.minimum;
        }

        protected MaximumBoundFilter.Double getMaximumFilter() {
            return (MaximumBoundFilter.Double)this.maximum;
        }
    }

    public static class BigInteger
    extends RangeFilter {
        public BigInteger(java.math.BigInteger min, java.math.BigInteger max) {
            this(min, true, max, true);
        }

        public BigInteger(java.math.BigInteger min, boolean minInclusive, java.math.BigInteger max, boolean maxInclusive) {
            this.minimum = new MinimumBoundFilter.BigInteger(min, minInclusive);
            this.minimum.addPropertyChangeListener(this);
            this.maximum = new MaximumBoundFilter.BigInteger(max, maxInclusive);
            this.maximum.addPropertyChangeListener(this);
        }

        public Stringable filterStringable(Stringable obj) throws FilterException {
            obj = super.filterStringable(obj);
            try {
                obj = this.minimum.filterStringable(obj);
                obj = this.maximum.filterStringable(obj);
            }
            catch (FilterException filterException) {
                String message = "Value not within the range ";
                message = String.valueOf(message) + (this.isMinimumInclusive() ? "[" : "(");
                message = String.valueOf(message) + this.getMinimum() + ",";
                message = String.valueOf(message) + this.getMaximum();
                message = String.valueOf(message) + (this.isMaximumInclusive() ? "]" : ")");
                throw new FilterException(obj, message);
            }
            return obj;
        }

        public void setMinimum(java.math.BigInteger min) {
            this.getMinimumFilter().setMinimum(min);
        }

        public java.math.BigInteger getMinimum() {
            return this.getMinimumFilter().getMinimum();
        }

        public void setMaximum(java.math.BigInteger max) {
            this.getMaximumFilter().setMaximum(max);
        }

        public java.math.BigInteger getMaximum() {
            return this.getMaximumFilter().getMaximum();
        }

        public void setMinimumInclusive(boolean inclusive) {
            this.minimum.setInclusive(inclusive);
        }

        public boolean isMinimumInclusive() {
            return this.minimum.isInclusive();
        }

        public void setMaximumInclusive(boolean inclusive) {
            this.maximum.setInclusive(inclusive);
        }

        public boolean isMaximumInclusive() {
            return this.maximum.isInclusive();
        }

        protected MinimumBoundFilter.BigInteger getMinimumFilter() {
            return (MinimumBoundFilter.BigInteger)this.minimum;
        }

        protected MaximumBoundFilter.BigInteger getMaximumFilter() {
            return (MaximumBoundFilter.BigInteger)this.maximum;
        }
    }

    public static class BigDecimal
    extends RangeFilter {
        protected MinimumBoundFilter.BigDecimal minimum = null;
        protected MaximumBoundFilter.BigDecimal maximum = null;

        public BigDecimal(java.math.BigDecimal min, java.math.BigDecimal max) {
            this(min, true, max, true);
        }

        public BigDecimal(java.math.BigDecimal min, boolean minInclusive, java.math.BigDecimal max, boolean maxInclusive) {
            this.minimum = new MinimumBoundFilter.BigDecimal(min, minInclusive);
            this.minimum.addPropertyChangeListener(this);
            this.maximum = new MaximumBoundFilter.BigDecimal(max, maxInclusive);
            this.maximum.addPropertyChangeListener(this);
        }

        public Stringable filterStringable(Stringable obj) throws FilterException {
            obj = super.filterStringable(obj);
            try {
                obj = this.minimum.filterStringable(obj);
                obj = this.maximum.filterStringable(obj);
            }
            catch (FilterException filterException) {
                String message = "Value not within the range ";
                message = String.valueOf(message) + (this.isMinimumInclusive() ? "[" : "(");
                message = String.valueOf(message) + this.getMinimum() + ",";
                message = String.valueOf(message) + this.getMaximum();
                message = String.valueOf(message) + (this.isMaximumInclusive() ? "]" : ")");
                throw new FilterException(obj, message);
            }
            return obj;
        }

        public void setMinimum(java.math.BigDecimal min) {
            this.getMinimumFilter().setMinimum(min);
        }

        public java.math.BigDecimal getMinimum() {
            return this.getMinimumFilter().getMinimum();
        }

        public void setMaximum(java.math.BigDecimal max) {
            this.getMaximumFilter().setMaximum(max);
        }

        public java.math.BigDecimal getMaximum() {
            return this.getMaximumFilter().getMaximum();
        }

        public void setMinimumInclusive(boolean inclusive) {
            this.minimum.setInclusive(inclusive);
        }

        public boolean isMinimumInclusive() {
            return this.minimum.isInclusive();
        }

        public void setMaximumInclusive(boolean inclusive) {
            this.maximum.setInclusive(inclusive);
        }

        public boolean isMaximumInclusive() {
            return this.maximum.isInclusive();
        }

        protected MinimumBoundFilter.BigDecimal getMinimumFilter() {
            return this.minimum;
        }

        protected MaximumBoundFilter.BigDecimal getMaximumFilter() {
            return this.maximum;
        }
    }
}

