/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.console;

import edu.neu.ccs.console.ConsoleWindow;
import edu.neu.ccs.util.JPTConstants;
import edu.neu.ccs.util.SystemUtilities;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

final class ConsoleTextPane
extends JTextPane
implements JPTConstants,
Serializable {
    public static final int OUT = 0;
    public static final int ERR = 1;
    public static final int IN = 2;
    private transient String endl = null;
    private int start = 0;
    private StyleContext context = null;
    private DefaultStyledDocument doc = null;
    private Style base = null;
    private Color[] color = new Color[]{Color.black, Color.black, Color.black};
    private ConsoleWindow window = null;

    private ConsoleTextPane() {
        this.endl = SystemUtilities.getLineSeparator();
    }

    public ConsoleTextPane(ConsoleWindow w) {
        this();
        this.window = w;
        this.context = new StyleContext();
        this.doc = new DefaultStyledDocument(this.context);
        this.setStyledDocument(this.doc);
        this.base = this.context.getStyle("default");
        StyleConstants.setFontFamily(this.base, "monospaced");
        StyleConstants.setFontSize(this.base, 12);
        this.doc.setCharacterAttributes(0, this.doc.getLength(), this.base, false);
        this.setStream(0);
    }

    public void processComponentKeyEvent(KeyEvent evt) {
        switch (evt.getID()) {
            case 401: 
            case 402: {
                if (evt.getKeyCode() != 10 && evt.getKeyCode() != 8) break;
                evt.consume();
                return;
            }
            default: {
                if (this.getCaretPosition() < this.start || this.getSelectionStart() < this.start) {
                    this.beep();
                    evt.consume();
                    return;
                }
                if (evt.getKeyChar() == '\n' || evt.getKeyChar() == '\r') {
                    try {
                        try {
                            this.doc.insertString(this.doc.getLength(), this.endl, this.getStyleFor(2));
                            this.fireConsoleInputPerformed(this.doc.getText(this.start, this.doc.getLength() - this.start));
                            evt.consume();
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    catch (Throwable throwable) {}
                    return;
                }
                if (evt.getKeyChar() != '\b' || this.getCaretPosition() != this.start) break;
                this.beep();
                evt.consume();
                return;
            }
        }
        super.processComponentKeyEvent(evt);
        this.setCharacterAttributes(this.getStyleFor(2), true);
    }

    public void append(String text, int stream) {
        this.setStream(stream);
        this.start = this.doc.getLength();
        this.setCaretPosition(this.start);
        try {
            this.doc.insertString(this.doc.getLength(), text, this.getStyleFor(stream));
        }
        catch (BadLocationException badLocationException) {}
        this.start = this.doc.getLength();
        this.setCaretPosition(this.start);
    }

    public void replaceSelection(String text) {
        if (this.getSelectionStart() >= this.start) {
            super.replaceSelection(text);
        } else {
            this.beep();
        }
    }

    public void cut() {
        if (this.getSelectionStart() >= this.start) {
            super.cut();
        } else {
            this.beep();
        }
    }

    public void paste() {
        if (this.getSelectionStart() >= this.start) {
            super.paste();
        } else {
            this.beep();
        }
    }

    public void setFontSize(int size) {
        Style font = this.context.addStyle(null, this.context.getStyle("default"));
        StyleConstants.setFontSize(font, size);
        StyleConstants.setFontSize(this.base, size);
        this.doc.setCharacterAttributes(0, this.doc.getLength(), font, false);
    }

    public void setStream(int stream) {
        if (stream == 2) {
            this.start = this.doc.getLength();
            this.setCaretPosition(this.start);
            this.setCharacterAttributes(this.getStyleFor(stream), true);
            this.setEditable(true);
            this.requestFocus();
        } else {
            this.setEditable(false);
            this.transferFocus();
        }
    }

    public void setInputColor(Color c) {
        this.color[2] = c;
    }

    public Color getInputColor() {
        return this.color[2];
    }

    public void setOutputColor(Color c) {
        this.color[0] = c;
    }

    public Color getOutputColor() {
        return this.color[0];
    }

    public void setErrorColor(Color c) {
        this.color[1] = c;
    }

    public Color getErrorColor() {
        return this.color[1];
    }

    private void fireConsoleInputPerformed(String text) {
        this.window.consoleInputPerformed(text);
    }

    private Style getStyleFor(int stream) {
        Style s = this.context.addStyle(null, this.base);
        StyleConstants.setForeground(s, this.color[stream]);
        return s;
    }

    private void beep() {
        new DefaultEditorKit.BeepAction().actionPerformed(new ActionEvent(this, 1001, "beep"));
    }
}

